/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.render;

import net.minecraft.class_1059;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import net.minecraft.class_918;
import net.spell_engine.api.render.CustomLayers;
import net.spell_engine.api.render.CustomModels;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.entity.SpellProjectile;

public class SpellProjectileRenderer<T extends class_1297>
extends class_897<T> {
    private final class_918 itemRenderer;
    private final float scale;
    private final boolean lit;
    public static final class_1921 LAYER = CustomLayers.projectile(class_1059.field_5275, false);

    public SpellProjectileRenderer(class_5617.class_5618 ctx, float scale, boolean lit) {
        super(ctx);
        this.itemRenderer = ctx.method_32168();
        this.scale = scale;
        this.lit = lit;
    }

    public SpellProjectileRenderer(class_5617.class_5618 arg) {
        this(arg, 1.0f, false);
    }

    protected int method_24087(T entity, class_2338 pos) {
        return this.lit ? 15 : super.method_24087(entity, pos);
    }

    public void method_3936(T entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        if (((class_1297)entity).field_6012 >= 2 || !(this.field_4676.field_4686.method_19331().method_5858(entity) < 12.25)) {
            SpellProjectile projectile;
            matrices.method_22903();
            matrices.method_22905(this.scale, this.scale, this.scale);
            if (entity instanceof SpellProjectile && (projectile = (SpellProjectile)entity).renderData() != null) {
                Spell.ProjectileData.Client renderData = projectile.renderData();
                switch (renderData.render) {
                    case FLAT: {
                        matrices.method_22907(this.field_4676.method_24197());
                        matrices.method_22907(class_1160.field_20705.method_23214(180.0f));
                        break;
                    }
                    case DEEP: {
                        class_243 velocity = entity.method_18798();
                        if (projectile.previousVelocity != null) {
                            velocity = projectile.previousVelocity.method_35590(velocity, (double)tickDelta);
                        }
                        velocity = velocity.method_1029();
                        double directionBasedYaw = Math.toDegrees(Math.atan2(velocity.field_1352, velocity.field_1350)) + 180.0;
                        double directionBasedPitch = Math.toDegrees(Math.asin(velocity.field_1351));
                        matrices.method_22907(class_1160.field_20705.method_23214((float)directionBasedYaw));
                        matrices.method_22907(class_1160.field_20703.method_23214((float)directionBasedPitch));
                    }
                }
                long time = ((class_1297)entity).field_6002.method_8510();
                float absoluteTime = (float)time + tickDelta;
                matrices.method_22907(class_1160.field_20707.method_23214(absoluteTime * renderData.rotate_degrees_per_tick));
                matrices.method_22905(renderData.scale, renderData.scale, renderData.scale);
                if (renderData.model_id != null && !renderData.model_id.isEmpty()) {
                    class_2960 modelId = new class_2960(renderData.model_id);
                    CustomModels.render(LAYER, this.itemRenderer, modelId, matrices, vertexConsumers, light, entity.method_5628());
                }
            }
            matrices.method_22909();
            super.method_3936(entity, yaw, tickDelta, matrices, vertexConsumers, light);
        }
    }

    public class_2960 method_3931(class_1297 entity) {
        return class_1059.field_5275;
    }
}

