/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.network;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1268;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.spell_engine.api.spell.ParticleBatch;
import net.spell_engine.config.ServerConfig;
import net.spell_engine.internals.SpellCast;

public class Packets {

    public static class ConfigSync {
        public static class_2960 ID = new class_2960("spell_engine", "config_sync");

        public static class_2540 write(ServerConfig config) {
            Gson gson = new Gson();
            String json = gson.toJson((Object)config);
            class_2540 buffer = PacketByteBufs.create();
            buffer.method_10814(json);
            return buffer;
        }

        public static ServerConfig read(class_2540 buffer) {
            Gson gson = new Gson();
            String json = buffer.method_19772();
            ServerConfig config = (ServerConfig)gson.fromJson(json, ServerConfig.class);
            return config;
        }
    }

    public static class SpellRegistrySync {
        public static class_2960 ID = new class_2960("spell_engine", "spell_registry_sync");
    }

    public record ParticleBatches(SourceType sourceType, List<Spawn> spawns) {
        public static class_2960 ID = new class_2960("spell_engine", "particle_effects");

        public class_2540 write(float countMultiplier) {
            class_2540 buffer = PacketByteBufs.create();
            buffer.writeInt(this.sourceType.ordinal());
            buffer.writeInt(this.spawns.size());
            for (Spawn spawn : this.spawns) {
                buffer.writeInt(spawn.sourceEntityId);
                buffer.writeDouble(spawn.sourceLocation.field_1352);
                buffer.writeDouble(spawn.sourceLocation.field_1351);
                buffer.writeDouble(spawn.sourceLocation.field_1350);
                ParticleBatches.write(spawn.batch, buffer, countMultiplier);
            }
            return buffer;
        }

        private static void write(ParticleBatch batch, class_2540 buffer, float countMultiplier) {
            buffer.method_10814(batch.particle_id);
            buffer.writeInt(batch.shape.ordinal());
            buffer.writeInt(batch.origin.ordinal());
            buffer.writeInt(batch.rotation != null ? batch.rotation.ordinal() : -1);
            buffer.writeFloat(batch.count * countMultiplier);
            buffer.writeFloat(batch.min_speed);
            buffer.writeFloat(batch.max_speed);
            buffer.writeFloat(batch.angle);
            buffer.writeFloat(batch.extent);
        }

        private static ParticleBatch readBatch(class_2540 buffer) {
            return new ParticleBatch(buffer.method_19772(), ParticleBatch.Shape.values()[buffer.readInt()], ParticleBatch.Origin.values()[buffer.readInt()], ParticleBatch.Rotation.from(buffer.readInt()), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }

        public static ParticleBatches read(class_2540 buffer) {
            SourceType sourceType = SourceType.values()[buffer.readInt()];
            int spawnCount = buffer.readInt();
            ArrayList<Spawn> spawns = new ArrayList<Spawn>();
            for (int i = 0; i < spawnCount; ++i) {
                spawns.add(new Spawn(buffer.readInt(), new class_243(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), ParticleBatches.readBatch(buffer)));
            }
            return new ParticleBatches(sourceType, spawns);
        }

        public static enum SourceType {
            ENTITY,
            COORDINATE;

        }

        public record Spawn(int sourceEntityId, class_243 sourceLocation, ParticleBatch batch) {
        }
    }

    public record SpellAnimation(int playerId, SpellCast.Animation type, String name) {
        public static class_2960 ID = new class_2960("spell_engine", "spell_animation");

        public class_2540 write() {
            class_2540 buffer = PacketByteBufs.create();
            buffer.writeInt(this.playerId);
            buffer.writeInt(this.type.ordinal());
            buffer.method_10814(this.name);
            return buffer;
        }

        public static SpellAnimation read(class_2540 buffer) {
            int playerId = buffer.readInt();
            SpellCast.Animation type = SpellCast.Animation.values()[buffer.readInt()];
            String name = buffer.method_19772();
            return new SpellAnimation(playerId, type, name);
        }
    }

    public record SpellCooldown(class_2960 spellId, int duration) {
        public static class_2960 ID = new class_2960("spell_engine", "spell_cooldown");

        public class_2540 write() {
            class_2540 buffer = PacketByteBufs.create();
            buffer.method_10814(this.spellId.toString());
            buffer.writeInt(this.duration);
            return buffer;
        }

        public static SpellCooldown read(class_2540 buffer) {
            class_2960 spellId = new class_2960(buffer.method_19772());
            int duration = buffer.readInt();
            return new SpellCooldown(spellId, duration);
        }
    }

    public record SpellRequest(class_1268 hand, SpellCast.Action action, class_2960 spellId, int slot, int remainingUseTicks, int[] targets) {
        public static class_2960 ID = new class_2960("spell_engine", "release_request");

        public class_2540 write() {
            class_2540 buffer = PacketByteBufs.create();
            buffer.method_10817((Enum)this.hand);
            buffer.method_10817((Enum)this.action);
            buffer.method_10814(this.spellId.toString());
            buffer.writeInt(this.slot);
            buffer.writeInt(this.remainingUseTicks);
            buffer.method_10806(this.targets);
            return buffer;
        }

        public static SpellRequest read(class_2540 buffer) {
            class_1268 hand = (class_1268)buffer.method_10818(class_1268.class);
            SpellCast.Action action = (SpellCast.Action)buffer.method_10818(SpellCast.Action.class);
            class_2960 spellId = new class_2960(buffer.method_19772());
            int slot = buffer.readInt();
            int remainingUseTicks = buffer.readInt();
            int[] targets = buffer.method_10787();
            return new SpellRequest(hand, action, spellId, slot, remainingUseTicks, targets);
        }
    }
}

