/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.utils;

import net.minecraft.class_238;
import net.minecraft.class_243;

public class VectorHelper {
    public static double angleBetween(class_243 a, class_243 b) {
        double cosineTheta = a.method_1026(b) / (a.method_1033() * b.method_1033());
        double angle = Math.acos(cosineTheta) * 57.29577951308232;
        if (Double.isNaN(angle)) {
            return 0.0;
        }
        return angle;
    }

    public static double angleWithSignBetween(class_243 a, class_243 b, class_243 planeNormal) {
        double cosineTheta = a.method_1026(b) / (a.method_1033() * b.method_1033());
        double angle = Math.toDegrees(Math.acos(cosineTheta));
        class_243 cross = a.method_1036(b);
        if (Double.isNaN(angle *= Math.signum(cross.method_1026(planeNormal)))) {
            return 0.0;
        }
        return angle;
    }

    public static class_243 distanceVector(class_243 point, class_238 box) {
        double dx = 0.0;
        if (box.field_1323 > point.field_1352) {
            dx = box.field_1323 - point.field_1352;
        } else if (box.field_1320 < point.field_1352) {
            dx = box.field_1320 - point.field_1352;
        }
        double dy = 0.0;
        if (box.field_1322 > point.field_1351) {
            dy = box.field_1322 - point.field_1351;
        } else if (box.field_1325 < point.field_1351) {
            dy = box.field_1325 - point.field_1351;
        }
        double dz = 0.0;
        if (box.field_1321 > point.field_1350) {
            dz = box.field_1321 - point.field_1350;
        } else if (box.field_1324 < point.field_1350) {
            dz = box.field_1324 - point.field_1350;
        }
        return new class_243(dx, dy, dz);
    }

    public static class_243 rotateTowards(class_243 vector, class_243 towards, double angleToRotate) {
        class_243 rotated;
        if (angleToRotate == 0.0) {
            return vector;
        }
        class_243 originalVector = new class_243(vector.field_1352, vector.field_1351, vector.field_1350);
        double angleBetween = VectorHelper.angleWithSignBetween(vector = vector.method_1029(), towards = towards.method_1029(), vector.method_1036(towards));
        if (angleBetween == 0.0) {
            return originalVector;
        }
        if (angleBetween <= angleToRotate) {
            rotated = towards;
        } else {
            class_243 v1 = vector;
            double towardsLength = Math.sin(Math.toRadians(angleToRotate)) / Math.cos(Math.toRadians(90.0 - angleBetween + angleToRotate));
            class_243 v2 = towards.method_1021(towardsLength);
            rotated = v1.method_1019(v2).method_1029();
        }
        rotated = rotated.method_1021(originalVector.method_1033());
        return rotated;
    }
}

