/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.util.queue;

import de.siphalor.spiceoffabric.util.queue.FixedLengthIntFIFOQueue;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.NoSuchElementException;
import java.util.function.IntConsumer;
import org.jetbrains.annotations.NotNull;

public class ArrayFixedLengthIntFIFOQueue
implements FixedLengthIntFIFOQueue {
    protected int[] array;
    protected int size;
    protected int start;

    public ArrayFixedLengthIntFIFOQueue(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("A fixed length fifo queue must not have a negative length!");
        }
        this.array = new int[size];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public int get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(index + " is out of bounds for fixed FIFO queue (s: " + this.size + ", l: " + this.array.length + ")");
        }
        if ((index += this.start) >= this.array.length) {
            index -= this.array.length;
        }
        return this.array[index];
    }

    @Override
    public void enqueue(int x) {
        if (this.getLength() == 0) {
            return;
        }
        if (this.size == this.getLength()) {
            throw new IllegalStateException("Tried to enqueue more elements than length permits onto fixed FIFO queue");
        }
        this.array[(this.start + this.size++) % this.array.length] = x;
    }

    @Override
    public Integer forceEnqueue(int x) {
        if (this.getLength() == 0) {
            return null;
        }
        if (this.isFull()) {
            int overwrite = this.dequeue();
            this.enqueue(x);
            return overwrite;
        }
        this.enqueue(x);
        return null;
    }

    @Override
    public int dequeue() {
        if (this.size <= 0) {
            throw new NoSuchElementException();
        }
        --this.size;
        int x = this.array[this.start++];
        if (this.start >= this.array.length) {
            this.start = 0;
        }
        return x;
    }

    @Override
    public int first() {
        if (this.size <= 0) {
            throw new NoSuchElementException();
        }
        return this.array[this.start];
    }

    @NotNull
    public IntIterator iterator() {
        return new IntIterator(){
            private int offset;

            public int nextInt() {
                if (this.offset >= ArrayFixedLengthIntFIFOQueue.this.size) {
                    throw new NoSuchElementException();
                }
                return ArrayFixedLengthIntFIFOQueue.this.array[(ArrayFixedLengthIntFIFOQueue.this.start + this.offset++) % ArrayFixedLengthIntFIFOQueue.this.array.length];
            }

            public boolean hasNext() {
                return this.offset < ArrayFixedLengthIntFIFOQueue.this.size;
            }
        };
    }

    public void forEach(IntConsumer action) {
        int pos = this.start;
        for (int l = this.size; l > 0; --l) {
            action.accept(this.array[pos++]);
            if (pos < this.array.length) continue;
            pos = 0;
        }
    }

    @Override
    public int getLength() {
        return this.array.length;
    }

    @Override
    public void setLength(int newLength) {
        if (newLength < 0) {
            throw new IllegalArgumentException("A fixed length fifo queue must not have a negative length!");
        }
        if (newLength < this.array.length) {
            this.shortenTo(newLength);
        } else if (newLength > this.array.length) {
            this.extendTo(newLength);
        }
    }

    private void shortenTo(int newLength) {
        int overflow = this.size - newLength;
        if (overflow > 0) {
            this.start = (this.start + overflow) % this.array.length;
            this.size -= overflow;
        }
        this.changeSizeTo(newLength);
    }

    private void extendTo(int newLength) {
        this.changeSizeTo(newLength);
    }

    private void changeSizeTo(int newLength) {
        int[] newArray = new int[newLength];
        int spaceToEnd = this.array.length - this.start;
        if (this.size <= spaceToEnd) {
            System.arraycopy(this.array, this.start, newArray, 0, this.size);
        } else {
            System.arraycopy(this.array, this.start, newArray, 0, spaceToEnd);
            System.arraycopy(this.array, 0, newArray, spaceToEnd, this.size - spaceToEnd);
        }
        this.start = 0;
        this.array = newArray;
    }
}

