/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.travelstaff.render;

import ca.lukegrahamlandry.travelstaff.Constants;
import ca.lukegrahamlandry.travelstaff.platform.Services;
import ca.lukegrahamlandry.travelstaff.render.OutlineBuffer;
import ca.lukegrahamlandry.travelstaff.util.TeleportHandler;
import ca.lukegrahamlandry.travelstaff.util.TravelAnchorList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_761;
import net.minecraft.class_765;
import org.apache.commons.lang3.tuple.Pair;

public class TravelAnchorRenderer {
    public static final class_1921 BOLD_LINES = Services.PLATFORM.createLines("bold_lines", 3);
    public static final class_1921 VERLY_BOLD_LINES = Services.PLATFORM.createLines("very_bold_lines", 5);
    public static class_1087 MODEL = class_310.method_1551().method_1541().method_3349(Constants.getTravelAnchor().method_9564());

    public static void renderAnchors(class_4587 poseStack, float partialTick) {
        class_638 level = class_310.method_1551().field_1687;
        class_746 player = class_310.method_1551().field_1724;
        if (level != null && player != null && (TeleportHandler.canBlockTeleport((class_1657)player) || TeleportHandler.canItemTeleport((class_1657)player, class_1268.field_5808) || TeleportHandler.canItemTeleport((class_1657)player, class_1268.field_5810))) {
            double maxDistanceSq = TeleportHandler.getMaxDistance((class_1657)player);
            maxDistanceSq *= maxDistanceSq;
            TravelAnchorList list = TravelAnchorList.get((class_1937)class_310.method_1551().field_1687);
            double posX = class_3532.method_16436((double)partialTick, (double)player.field_6014, (double)player.method_23317());
            double posY = class_3532.method_16436((double)partialTick, (double)player.field_6036, (double)player.method_23318());
            double posZ = class_3532.method_16436((double)partialTick, (double)player.field_5969, (double)player.method_23321());
            class_243 projection = class_310.method_1551().field_1773.method_19418().method_19326();
            double projPosX = projection.field_1352;
            double projPosY = projection.field_1351;
            double projPosZ = projection.field_1350;
            Pair<class_2338, String> pair = TeleportHandler.getAnchorToTeleport((class_1937)level, (class_1657)player, player.method_24515().method_10074());
            for (class_2338 pos : list.anchors.keySet()) {
                TravelAnchorList.Entry entry;
                double distanceSq = pos.method_40081(posX, posY, posZ);
                if (!(distanceSq <= maxDistanceSq) || (entry = list.getEntry(pos)) == null) continue;
                int light = level.method_22340(pos) ? class_765.method_23687((int)level.method_8314(class_1944.field_9282, pos), (int)level.method_8314(class_1944.field_9284, pos)) : class_765.method_23687((int)15, (int)15);
                boolean active = pair != null && pos.equals(pair.getLeft());
                boolean directText = distanceSq <= 225.0;
                poseStack.method_22903();
                TravelAnchorRenderer.loadProjection(poseStack, pos);
                if (distanceSq > 100.0) {
                    double distance = Math.sqrt(distanceSq);
                    poseStack.method_22904(0.5, 0.5, 0.5);
                    double log = Math.log(distance) / 2.3;
                    float scale = (float)(log * log * log);
                    poseStack.method_22905(scale, scale, scale);
                    poseStack.method_22904(-0.5, -0.5, -0.5);
                }
                TravelAnchorRenderer.renderAnchor(poseStack, OutlineBuffer.INSTANCE, directText ? entry.name : null, entry.state, light, true, active, distanceSq);
                poseStack.method_22909();
                if (directText || entry.name.trim().isEmpty()) continue;
                poseStack.method_22903();
                double blockScale = Math.sqrt(0.0035 * Math.sqrt(distanceSq));
                if (blockScale < (double)0.1f) {
                    blockScale = 0.1f;
                }
                blockScale *= Math.sin(Math.toRadians((double)((Integer)class_310.method_1551().field_1690.method_41808().method_41753()).intValue() / 4.0));
                if (active) {
                    blockScale *= 1.3;
                }
                TravelAnchorRenderer.loadProjection(poseStack, projPosX, projPosY, projPosZ);
                CircleRotation rot = TravelAnchorRenderer.rotateCircle(projPosX - ((double)pos.method_10263() + 0.5), projPosY - ((double)pos.method_10264() + 0.5 + 0.5 * blockScale), projPosZ - ((double)pos.method_10260() + 0.5));
                rot.apply(poseStack);
                poseStack.method_22904(0.0, 5.0, 0.0);
                double doubleScale = 0.1;
                doubleScale *= Math.sin(Math.toRadians((double)((Integer)class_310.method_1551().field_1690.method_41808().method_41753()).intValue() / 4.0));
                if (active) {
                    doubleScale *= 1.3;
                }
                float scale = (float)doubleScale;
                rot.reverse(poseStack);
                Objects.requireNonNull(class_310.method_1551().field_1772);
                poseStack.method_22904(0.0, 0.05 + doubleScale * 9.0, 0.0);
                poseStack.method_22907(class_310.method_1551().method_1561().method_24197());
                poseStack.method_22905(-scale, -scale, scale);
                int color = 0xFFFFFF;
                if (active) {
                    color = class_124.field_1065.method_532() == null ? 0xFFFFFF : class_124.field_1065.method_532();
                }
                class_1159 matrix4f = poseStack.method_23760().method_23761();
                class_5250 tc = class_2561.method_43470((String)entry.name.trim());
                float textOpacitySetting = class_310.method_1551().field_1690.method_19343(0.5f);
                int alpha = (int)(textOpacitySetting * 255.0f) << 24;
                float halfWidth = -class_310.method_1551().field_1772.method_27525((class_5348)tc) / 2;
                class_310.method_1551().field_1772.method_30882((class_2561)tc, halfWidth, 0.0f, color, false, matrix4f, (class_4597)OutlineBuffer.INSTANCE, true, alpha, class_765.method_23687((int)15, (int)15));
                class_310.method_1551().field_1772.method_30882((class_2561)tc, halfWidth, 0.0f, color, false, matrix4f, (class_4597)OutlineBuffer.INSTANCE, false, 0, class_765.method_23687((int)15, (int)15));
                poseStack.method_22909();
            }
            class_310.method_1551().method_22940().method_23000().method_22993();
        }
    }

    public static void renderAnchor(class_4587 poseStack, class_4597 buffer, @Nullable String name, class_2680 state, int light, boolean glow, boolean active, double distanceSq) {
        if (state == null || state.method_26204() == Constants.getTravelAnchor()) {
            class_4588 vertex = buffer.getBuffer(class_1921.method_23577());
            class_310.method_1551().method_1541().method_3350().method_3367(poseStack.method_23760(), vertex, state, MODEL, 1.0f, 1.0f, 1.0f, light, class_4608.field_21444);
        } else {
            class_310.method_1551().method_1541().method_3353(state, poseStack, buffer, light, class_4608.field_21444);
        }
        if (glow) {
            class_1921 type = distanceSq > 7225.0 ? class_1921.method_23594() : (distanceSq > 1444.0 ? BOLD_LINES : VERLY_BOLD_LINES);
            class_4588 vertex = buffer.getBuffer(type);
            class_761.method_22980((class_4587)poseStack, (class_4588)vertex, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (name != null && !name.trim().isEmpty()) {
            double doubleScale = Math.sqrt(0.0035 * Math.sqrt(distanceSq));
            if (doubleScale < (double)0.1f) {
                doubleScale = 0.1f;
            }
            doubleScale *= Math.sin(Math.toRadians((double)((Integer)class_310.method_1551().field_1690.method_41808().method_41753()).intValue() / 4.0));
            if (active) {
                doubleScale *= 1.3;
            }
            float scale = (float)doubleScale;
            poseStack.method_22903();
            Objects.requireNonNull(class_310.method_1551().field_1772);
            poseStack.method_22904(0.5, 1.05 + doubleScale * 9.0, 0.5);
            poseStack.method_22907(class_310.method_1551().method_1561().method_24197());
            poseStack.method_22905(-scale, -scale, scale);
            int color = 0xFFFFFF;
            if (active) {
                color = class_124.field_1065.method_532() == null ? 0xFFFFFF : class_124.field_1065.method_532();
            }
            class_1159 matrix4f = poseStack.method_23760().method_23761();
            class_5250 tc = class_2561.method_43470((String)name.trim());
            float textOpacitySetting = class_310.method_1551().field_1690.method_19343(0.5f);
            int alpha = (int)(textOpacitySetting * 255.0f) << 24;
            float halfWidth = -class_310.method_1551().field_1772.method_27525((class_5348)tc) / 2;
            class_310.method_1551().field_1772.method_30882((class_2561)tc, halfWidth, 0.0f, color, false, matrix4f, buffer, true, alpha, class_765.method_23687((int)15, (int)15));
            class_310.method_1551().field_1772.method_30882((class_2561)tc, halfWidth, 0.0f, color, false, matrix4f, buffer, false, 0, class_765.method_23687((int)15, (int)15));
            poseStack.method_22909();
        }
    }

    private static CircleRotation rotateCircle(double x, double y, double z) {
        float yr = Float.NaN;
        if (z != 0.0) {
            yr = (float)(Math.atan2(x, z) + 1.5707963267948966);
        }
        double hor = Math.sqrt(x * x + z * z);
        float zr = (float)(Math.atan2(hor, y) + Math.PI);
        return new CircleRotation(yr, zr);
    }

    public static void loadProjection(class_4587 poseStack, class_2338 pos) {
        TravelAnchorRenderer.loadProjection(poseStack, pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public static void loadProjection(class_4587 poseStack, class_243 pos) {
        TravelAnchorRenderer.loadProjection(poseStack, pos.field_1352, pos.field_1351, pos.field_1350);
    }

    public static void loadProjection(class_4587 poseStack, double x, double y, double z) {
        class_243 projection = class_310.method_1551().field_1773.method_19418().method_19326();
        poseStack.method_22904(x - projection.field_1352, y - projection.field_1351, z - projection.field_1350);
    }

    private record CircleRotation(float y, float z) {
        public void apply(class_4587 poseStack) {
            if (!Float.isNaN(this.y)) {
                poseStack.method_22907(class_1160.field_20705.method_23626(this.y));
            }
            poseStack.method_22907(class_1160.field_20707.method_23626(this.z));
        }

        public void reverse(class_4587 poseStack) {
            poseStack.method_22907(class_1160.field_20707.method_23626(-this.z));
            if (!Float.isNaN(this.y)) {
                poseStack.method_22907(class_1160.field_20705.method_23626(-this.y));
            }
        }
    }
}

