/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.travelstaff.util;

import ca.lukegrahamlandry.travelstaff.Constants;
import ca.lukegrahamlandry.travelstaff.block.TileTravelAnchor;
import ca.lukegrahamlandry.travelstaff.enchantments.RangeEnchantment;
import ca.lukegrahamlandry.travelstaff.enchantments.TeleportationEnchantment;
import ca.lukegrahamlandry.travelstaff.item.ItemTravelStaff;
import ca.lukegrahamlandry.travelstaff.platform.Services;
import ca.lukegrahamlandry.travelstaff.util.TravelAnchorList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.apache.commons.lang3.tuple.Pair;

public class TeleportHandler {
    public static boolean anchorTeleport(class_1937 level, class_1657 player, @Nullable class_2338 except, @Nullable class_1268 hand) {
        Pair<class_2338, String> anchor = TeleportHandler.getAnchorToTeleport(level, player, except);
        return TeleportHandler.teleportPlayer(player, anchor, hand);
    }

    public static Pair<class_2338, String> getAnchorToTeleport(class_1937 level, class_1657 player, @Nullable class_2338 except) {
        boolean allow;
        boolean bl = allow = !player.method_5715() || TeleportHandler.canBlockTeleport(player);
        if (allow) {
            double maxDistance = TeleportHandler.getMaxDistance(player);
            class_243 positionVec = player.method_19538().method_1031(0.0, (double)player.method_5751(), 0.0);
            Optional<Pair> anchor = TravelAnchorList.get(level).getAnchorsAround(player.method_19538(), Math.pow(maxDistance, 2.0)).filter(pair -> except == null || !except.equals(pair.getLeft())).min((p1, p2) -> {
                double angle1 = Math.abs(TeleportHandler.getAngleRadians(positionVec, (class_2338)p1.getLeft(), player.method_36454(), player.method_36455()));
                double angle2 = Math.abs(TeleportHandler.getAngleRadians(positionVec, (class_2338)p2.getLeft(), player.method_36454(), player.method_36455()));
                return Double.compare(angle1, angle2);
            }).filter(p -> Math.abs(TeleportHandler.getAngleRadians(positionVec, (class_2338)p.getLeft(), player.method_36454(), player.method_36455())) <= Math.toRadians(Services.CONFIG.getMaxAngle())).filter(p -> TeleportHandler.canTeleportTo((class_1922)level, (class_2338)p.getLeft()));
            return anchor.orElse(null);
        }
        return null;
    }

    public static boolean teleportPlayer(class_1657 player, @Nullable Pair<class_2338, String> anchor, @Nullable class_1268 hand) {
        if (anchor != null) {
            if (!player.method_37908().field_9236) {
                class_243 teleportVec = TeleportHandler.checkTeleport(player, ((class_2338)anchor.getLeft()).method_10084());
                if (teleportVec == null) {
                    return false;
                }
                player.method_5859(teleportVec.method_10216() + 0.5, teleportVec.method_10214(), teleportVec.method_10215() + 0.5);
            }
            player.field_6017 = 0.0f;
            if (hand != null) {
                player.method_23667(hand, true);
            }
            player.method_17356(class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
            if (!player.field_6002.field_9236) {
                player.method_7353((class_2561)class_2561.method_43469((String)"travelstaff.tp.success", (Object[])new Object[]{anchor.getRight()}), true);
            }
            return true;
        }
        if (!player.field_6002.field_9236) {
            player.method_7353((class_2561)class_2561.method_43471((String)"travelstaff.tp.fail"), true);
        }
        return false;
    }

    public static boolean shortTeleport(class_1937 level, class_1657 player, class_1268 hand) {
        class_243 targetVec = player.method_19538().method_1031(0.0, (double)player.method_5751(), 0.0);
        class_243 lookVec = player.method_5720();
        class_2338 target = null;
        for (double i = Services.CONFIG.getShortTeleportDistance(); i >= 2.0; i -= 0.5) {
            class_243 v3d = targetVec.method_1019(lookVec.method_18805(i, i, i));
            target = new class_2338((double)Math.round(v3d.field_1352), (double)Math.round(v3d.field_1351), (double)Math.round(v3d.field_1350));
            if (TeleportHandler.canTeleportTo((class_1922)level, target.method_10074())) break;
            target = null;
        }
        if (target != null) {
            if (!player.method_37908().field_9236) {
                class_243 teleportVec = TeleportHandler.checkTeleport(player, target);
                if (teleportVec == null) {
                    return false;
                }
                player.method_5859(teleportVec.method_10216() + 0.5, teleportVec.method_10214(), teleportVec.method_10215() + 0.5);
            }
            player.field_6017 = 0.0f;
            player.method_23667(hand, true);
            player.method_17356(class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
            return true;
        }
        if (!player.field_6002.field_9236) {
            player.method_7353((class_2561)class_2561.method_43471((String)"travelstaff.hop.fail"), true);
        }
        return false;
    }

    public static boolean canTeleportTo(class_1922 level, class_2338 target) {
        return !TeleportHandler.fullBlockAt(level, target.method_10062().method_10086(1)) && !TeleportHandler.fullBlockAt(level, target.method_10062().method_10086(2)) && target.method_10264() >= level.method_31607();
    }

    private static boolean fullBlockAt(class_1922 level, class_2338 target) {
        return class_2248.method_9614((class_265)level.method_8320(target).method_26218(level, target));
    }

    public static boolean canPlayerTeleport(class_1657 player, class_1268 hand) {
        if (player != null) {
            return TeleportHandler.canItemTeleport(player, hand) || TeleportHandler.canBlockTeleport(player);
        }
        return false;
    }

    public static class_2338 down(class_1657 player) {
        return new class_2338(player.method_5829().method_1005().field_1352, player.method_23318(), player.method_5829().method_1005().field_1350).method_10074();
    }

    public static boolean canBlockTeleport(class_1657 player) {
        return player.method_37908().method_8320(TeleportHandler.down(player)).method_26204() == Constants.getTravelAnchor();
    }

    public static boolean canItemTeleport(class_1657 player, class_1268 hand) {
        return player.method_5998(hand).method_7909() instanceof ItemTravelStaff || class_1890.method_8225((class_1887)TeleportationEnchantment.INSTANCE, (class_1799)player.method_5998(hand)) >= 1;
    }

    private static double getAngleRadians(class_243 positionVec, class_2338 anchor, float yRot, float xRot) {
        class_243 blockVec = new class_243((double)anchor.method_10263() + 0.5 - positionVec.field_1352, (double)anchor.method_10264() + 1.0 - positionVec.field_1351, (double)anchor.method_10260() + 0.5 - positionVec.field_1350).method_1029();
        class_243 lookVec = class_243.method_1030((float)xRot, (float)yRot).method_1029();
        return Math.acos(lookVec.method_1026(blockVec));
    }

    public static double getMaxDistance(class_1657 player) {
        int mainHandLevel = class_1890.method_8225((class_1887)RangeEnchantment.INSTANCE, (class_1799)player.method_5998(class_1268.field_5808));
        int offHandLevel = class_1890.method_8225((class_1887)RangeEnchantment.INSTANCE, (class_1799)player.method_5998(class_1268.field_5810));
        int lvl = Math.max(mainHandLevel, offHandLevel);
        return Services.CONFIG.getMaxDistance() * (1.0 + (double)lvl / 2.0);
    }

    public static boolean canElevate(class_1657 player) {
        if (player != null) {
            return player.method_37908().method_8320(TeleportHandler.down(player)).method_26204() == Constants.getTravelAnchor();
        }
        return false;
    }

    public static boolean elevateUp(class_1657 player) {
        String name;
        class_2338 target;
        class_2586 tile;
        if (!TeleportHandler.canElevate(player)) {
            return false;
        }
        class_1937 level = player.method_37908();
        class_2338.class_2339 searchPos = player.method_24515().method_10062().method_25503();
        while (!(level.method_31606((class_2338)searchPos) || level.method_8320((class_2338)searchPos).method_26204() == Constants.getTravelAnchor() && TeleportHandler.canTeleportTo((class_1922)level, (class_2338)searchPos))) {
            searchPos.method_10098(class_2350.field_11036);
        }
        class_2680 state = level.method_8320((class_2338)searchPos);
        Pair anchor = null;
        if (state.method_26204() == Constants.getTravelAnchor() && TeleportHandler.canTeleportTo((class_1922)level, (class_2338)searchPos) && (tile = level.method_8321(target = searchPos.method_10062())) instanceof TileTravelAnchor && !(name = ((TileTravelAnchor)tile).getName()).isEmpty()) {
            anchor = Pair.of((Object)target, (Object)name);
        }
        return TeleportHandler.teleportPlayer(player, anchor, null);
    }

    public static boolean elevateDown(class_1657 player) {
        String name;
        class_2338 target;
        class_2586 tile;
        if (!TeleportHandler.canElevate(player)) {
            return false;
        }
        class_1937 level = player.method_37908();
        class_2338.class_2339 searchPos = player.method_24515().method_10062().method_10087(2).method_25503();
        while (!(level.method_31606((class_2338)searchPos) || level.method_8320((class_2338)searchPos).method_26204() == Constants.getTravelAnchor() && TeleportHandler.canTeleportTo((class_1922)level, (class_2338)searchPos))) {
            searchPos.method_10098(class_2350.field_11033);
        }
        class_2680 state = level.method_8320((class_2338)searchPos);
        Pair anchor = null;
        if (state.method_26204() == Constants.getTravelAnchor() && TeleportHandler.canTeleportTo((class_1922)level, (class_2338)searchPos) && (tile = level.method_8321(target = searchPos.method_10062())) instanceof TileTravelAnchor && !(name = ((TileTravelAnchor)tile).getName()).isEmpty()) {
            anchor = Pair.of((Object)target, (Object)name);
        }
        return TeleportHandler.teleportPlayer(player, anchor, null);
    }

    @Nullable
    private static class_243 checkTeleport(class_1657 player, class_2338 target) {
        return new class_243((double)target.method_10263(), (double)target.method_10264(), (double)target.method_10260());
    }
}

