/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.travelstaff.util;

import ca.lukegrahamlandry.travelstaff.Constants;
import ca.lukegrahamlandry.travelstaff.platform.Services;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.apache.commons.lang3.tuple.Pair;

public class TravelAnchorList
extends class_18 {
    private static final TravelAnchorList clientInstance = new TravelAnchorList();
    public final HashMap<class_2338, Entry> anchors = new HashMap();

    public static TravelAnchorList get(class_1937 level) {
        if (!level.field_9236) {
            class_26 storage = ((class_3218)level).method_17983();
            return (TravelAnchorList)storage.method_17924(TravelAnchorList::new, TravelAnchorList::new, "travelstaff");
        }
        return clientInstance;
    }

    public TravelAnchorList() {
    }

    public TravelAnchorList(class_2487 nbt) {
        this();
        this.load(nbt);
    }

    public void load(@Nonnull class_2487 nbt) {
        this.anchors.clear();
        if (nbt.method_10573("anchors", 9)) {
            boolean anyOldFormat = false;
            class_2499 list = nbt.method_10554("anchors", 10);
            for (int i = 0; i < list.size(); ++i) {
                class_2680 state;
                class_2487 entryNBT = list.method_10602(i);
                if (!entryNBT.method_10545("x") || !entryNBT.method_10545("y") || !entryNBT.method_10545("z") || !entryNBT.method_10545("name")) continue;
                class_2338 pos = new class_2338(entryNBT.method_10550("x"), entryNBT.method_10550("y"), entryNBT.method_10550("z")).method_10062();
                String name = entryNBT.method_10558("name");
                if (name.isEmpty()) continue;
                if (entryNBT.method_10545("state2")) {
                    state = class_2512.method_10681((class_2487)entryNBT.method_10562("state2"));
                } else if (entryNBT.method_10545("state")) {
                    state = class_2248.method_9531((int)entryNBT.method_10550("state"));
                    anyOldFormat = true;
                } else {
                    state = Constants.getTravelAnchor().method_9564();
                }
                this.anchors.put(pos, new Entry(entryNBT.method_10558("name"), state));
            }
            if (anyOldFormat) {
                this.method_80();
            }
        }
    }

    @Nonnull
    public class_2487 method_75(@Nonnull class_2487 compound) {
        class_2499 list = new class_2499();
        for (Map.Entry<class_2338, Entry> entry : this.anchors.entrySet()) {
            class_2487 entryNBT = new class_2487();
            entryNBT.method_10569("x", entry.getKey().method_10263());
            entryNBT.method_10569("y", entry.getKey().method_10264());
            entryNBT.method_10569("z", entry.getKey().method_10260());
            entryNBT.method_10582("name", entry.getValue().name);
            entryNBT.method_10566("state2", (class_2520)class_2512.method_10686((class_2680)entry.getValue().state));
            list.add((Object)entryNBT);
        }
        compound.method_10566("anchors", (class_2520)list);
        return compound;
    }

    public class_2487 saveForNetwork() {
        class_2487 compound = new class_2487();
        class_2499 list = new class_2499();
        for (Map.Entry<class_2338, Entry> entry : this.anchors.entrySet()) {
            class_2487 entryNBT = new class_2487();
            entryNBT.method_10569("x", entry.getKey().method_10263());
            entryNBT.method_10569("y", entry.getKey().method_10264());
            entryNBT.method_10569("z", entry.getKey().method_10260());
            entryNBT.method_10582("name", entry.getValue().name);
            entryNBT.method_10569("state", class_2248.method_9507((class_2680)entry.getValue().state));
            list.add((Object)entryNBT);
        }
        compound.method_10566("anchors", (class_2520)list);
        return compound;
    }

    public void setAnchor(class_1937 level, class_2338 pos, @Nullable String name, @Nullable class_2680 state) {
        if (!level.field_9236) {
            boolean needsUpdate = false;
            class_2338 immutablePos = pos.method_10062();
            if (name == null || name.trim().isEmpty()) {
                if (this.anchors.containsKey(immutablePos)) {
                    this.anchors.remove(immutablePos);
                    needsUpdate = true;
                }
            } else {
                Entry oldEntry;
                if (state == null) {
                    state = Constants.getTravelAnchor().method_9564();
                }
                if ((oldEntry = (Entry)this.anchors.getOrDefault(immutablePos, null)) == null || !oldEntry.name.equals(name) || oldEntry.state != state) {
                    this.anchors.put(pos.method_10062(), new Entry(name, state));
                    needsUpdate = true;
                }
            }
            this.method_80();
            if (needsUpdate) {
                Services.NETWORK.sendAnchorListToClients((class_3218)level, this);
            }
        }
    }

    public String getAnchor(class_2338 pos) {
        Entry entry = this.getEntry(pos);
        return entry == null ? null : entry.name;
    }

    public Entry getEntry(class_2338 pos) {
        return this.anchors.getOrDefault(pos.method_10062(), null);
    }

    public Stream<Pair<class_2338, String>> getAnchorsAround(class_243 pos, double maxDistanceSq) {
        return this.anchors.entrySet().stream().filter(entry -> ((class_2338)entry.getKey()).method_10262(new class_2382(pos.field_1352, pos.field_1351, pos.field_1350)) < maxDistanceSq).map(entry -> Pair.of((Object)((class_2338)entry.getKey()), (Object)((Entry)entry.getValue()).name));
    }

    public static class Entry {
        public String name;
        public class_2680 state;

        public Entry(String name, class_2680 state) {
            this.name = name;
            this.state = state;
        }
    }
}

