/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.cache;

import com.direwolf20.buildinggadgets.common.network.bidirection.PacketSetRemoteInventoryCache;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryLinker;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Multiset;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class RemoteInventoryCache {
    private final Stopwatch timer = Stopwatch.createStarted();
    private final boolean isCopyPaste;
    private boolean forceUpdate;
    private InventoryLinker.InventoryLink location;
    private Multiset<ItemVariant> cache;

    public RemoteInventoryCache(boolean isCopyPaste) {
        this.isCopyPaste = isCopyPaste;
    }

    public void setCache(Multiset<ItemVariant> cache) {
        this.cache = cache;
    }

    public void forceUpdate() {
        this.forceUpdate = true;
    }

    public boolean maintainCache(class_1799 gadget) {
        InventoryLinker.InventoryLink loc = InventoryLinker.getDataFromStack(gadget);
        if (this.isCacheOld(loc)) {
            this.updateCache(loc, gadget);
        }
        return loc != null;
    }

    public Multiset<ItemVariant> getCache() {
        return this.cache;
    }

    private void updateCache(InventoryLinker.InventoryLink loc, class_1799 gadget) {
        this.location = loc;
        if (loc == null) {
            this.cache = null;
        } else {
            class_746 player = class_310.method_1551().field_1724;
            if (player.method_5998(class_1268.field_5808) == gadget) {
                PacketSetRemoteInventoryCache.send(this.isCopyPaste, class_1268.field_5808);
            } else if (player.method_5998(class_1268.field_5810) == gadget) {
                PacketSetRemoteInventoryCache.send(this.isCopyPaste, class_1268.field_5810);
            }
        }
    }

    private boolean isCacheOld(@Nullable InventoryLinker.InventoryLink loc) {
        if (this.forceUpdate || !Objects.equals(this.location, loc) || this.timer.elapsed(TimeUnit.MILLISECONDS) >= 5000L) {
            this.timer.reset();
            this.timer.start();
            this.forceUpdate = false;
            return true;
        }
        return false;
    }
}

