/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.renders;

import com.direwolf20.buildinggadgets.client.renderer.OurRenderTypes;
import com.direwolf20.buildinggadgets.client.renders.BaseRenderer;
import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.component.BGComponent;
import com.direwolf20.buildinggadgets.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.tainted.building.PlacementTarget;
import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.building.view.IBuildView;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateProvider;
import com.direwolf20.buildinggadgets.common.tainted.template.Template;
import com.direwolf20.buildinggadgets.common.world.MockDelegationWorld;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1159;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_291;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_776;

public class CopyPasteRender
extends BaseRenderer
implements ITemplateProvider.IUpdateListener {
    private MultiVBORenderer renderBuffer;
    private int tickTrack = 0;
    private UUID lastRendered = null;
    private class_5944 instance;

    @Override
    public void onTemplateUpdate(ITemplateProvider provider, ITemplateKey key, Template template) {
        if (provider.getId(key).equals(this.lastRendered)) {
            this.renderBuffer = null;
        }
    }

    @Override
    public void onTemplateUpdateSend(ITemplateProvider provider, ITemplateKey key, Template template) {
        this.onTemplateUpdate(provider, key, template);
    }

    @Override
    public void renderAfterSetup(WorldRenderContext context, class_1657 player, class_1799 heldItem) {
        if (GadgetCopyPaste.getToolMode(heldItem) == GadgetCopyPaste.ToolMode.COPY) {
            GadgetCopyPaste.getSelectedRegion(heldItem).ifPresent(region -> {
                class_4587 stack = context.matrixStack();
                class_243 cameraView = context.camera().method_19326();
                stack.method_22903();
                stack.method_22904(-cameraView.method_10216(), -cameraView.method_10214(), -cameraView.method_10215());
                this.renderCopy(stack, (Region)region);
                stack.method_22909();
            });
        }
    }

    @Override
    public void render(WorldRenderContext context, class_1657 player, class_1799 heldItem) {
        super.render(context, player, heldItem);
        if (GadgetCopyPaste.getToolMode(heldItem) != GadgetCopyPaste.ToolMode.COPY) {
            class_243 cameraView = context.camera().method_19326();
            class_4587 stack = context.matrixStack();
            stack.method_22903();
            stack.method_22904(-cameraView.method_10216(), -cameraView.method_10214(), -cameraView.method_10215());
            this.renderPaste(stack, cameraView, player, heldItem);
            stack.method_22909();
        }
    }

    private void renderCopy(class_4587 matrix, Region region) {
        class_2338 startPos = region.getMin();
        class_2338 endPos = region.getMax();
        class_2338 blankPos = class_2338.field_10980;
        if (startPos.equals((Object)blankPos) || endPos.equals((Object)blankPos)) {
            return;
        }
        int R = 255;
        int G = 223;
        int B = 127;
        class_4597.class_4598 buffer = class_310.method_1551().method_22940().method_23000();
        class_761.method_22982((class_4587)matrix, (class_4588)buffer.getBuffer(OurRenderTypes.CopyGadgetLines), (class_238)new class_238(region.getMin(), region.getMax().method_10069(1, 1, 1)), (float)((float)R / 255.0f), (float)((float)G / 255.0f), (float)((float)B / 255.0f), (float)1.0f);
    }

    private void renderPaste(class_4587 matrices, class_243 cameraView, class_1657 player, class_1799 heldItem) {
        class_1937 world = player.field_6002;
        BGComponent.TEMPLATE_PROVIDER_COMPONENT.maybeGet((Object)world).ifPresent(provider -> BGComponent.TEMPLATE_KEY_COMPONENT.maybeGet((Object)heldItem).ifPresent(key -> GadgetCopyPaste.getActivePos(player, heldItem).ifPresent(startPos -> {
            MockDelegationWorld fakeWorld = new MockDelegationWorld((class_1936)world);
            BuildContext context = BuildContext.builder().player(player).stack(heldItem).build(fakeWorld);
            IBuildView view = provider.getTemplateForKey((ITemplateKey)key).createViewInContext(context);
            ArrayList<PlacementTarget> targets = new ArrayList<PlacementTarget>();
            for (PlacementTarget target : view) {
                if (!target.placeIn(context)) continue;
                targets.add(target);
            }
            UUID id = provider.getId((ITemplateKey)key);
            if (!id.equals(this.lastRendered)) {
                this.renderBuffer = null;
                System.gc();
            }
            this.renderTargets(matrices, cameraView, context, (List<PlacementTarget>)targets, (class_2338)startPos);
            this.lastRendered = id;
        })));
    }

    private void renderTargets(class_4587 matrix, class_243 projectedView, BuildContext context, List<PlacementTarget> targets, class_2338 startPos) {
        ++this.tickTrack;
        if (this.renderBuffer != null && this.tickTrack < 300) {
            if (this.tickTrack % 30 == 0) {
                // empty if block
            }
            matrix.method_22904((double)startPos.method_10263(), (double)startPos.method_10264(), (double)startPos.method_10260());
            this.renderBuffer.render(matrix.method_23760().method_23761());
            return;
        }
        this.tickTrack = 0;
        if (this.renderBuffer != null) {
            this.renderBuffer.close();
        }
        this.renderBuffer = MultiVBORenderer.of(buffer -> {
            OurRenderTypes.MultiplyAlphaRenderTypeBuffer mutatedBuffer = new OurRenderTypes.MultiplyAlphaRenderTypeBuffer((class_4597)buffer, 0.7f);
            class_776 dispatcher = CopyPasteRender.getMc().method_1541();
            class_4587 stack = new class_4587();
            stack.method_22903();
            for (PlacementTarget target : targets) {
                class_2338 targetPos = target.getPos();
                class_2680 state = context.getWorld().method_8320(target.getPos());
                stack.method_22903();
                stack.method_22904((double)targetPos.method_10263(), (double)targetPos.method_10264(), (double)targetPos.method_10260());
                try {
                    if (state.method_26217() == class_2464.field_11458) {
                        dispatcher.method_3353(state, stack, (class_4597)mutatedBuffer, 0xF000F0, class_4608.field_21444);
                    }
                }
                catch (Exception e) {
                    BuildingGadgets.LOG.trace("Caught exception whilst rendering {}.", (Object)state, (Object)e);
                }
                stack.method_22909();
            }
            stack.method_22909();
        });
        matrix.method_22904((double)startPos.method_10263(), (double)startPos.method_10264(), (double)startPos.method_10260());
        this.renderBuffer.render(matrix.method_23760().method_23761());
    }

    @Override
    public boolean isLinkable() {
        return true;
    }

    public static class MultiVBORenderer
    implements Closeable {
        private static final int BUFFER_SIZE = 0x600000;
        private final ImmutableMap<class_1921, class_291> buffers;

        public static MultiVBORenderer of(Consumer<class_4597> vertexProducer) {
            HashMap builders = Maps.newHashMap();
            vertexProducer.accept(rt -> (class_4588)builders.computeIfAbsent(rt, _rt -> {
                class_287 builder = new class_287(0x600000);
                builder.method_1328(_rt.method_23033(), _rt.method_23031());
                return builder;
            }));
            Map buffers = Maps.transformEntries((Map)builders, (rt, builder) -> {
                Objects.requireNonNull(rt);
                Objects.requireNonNull(builder);
                class_291 vbo = new class_291();
                vbo.method_1353();
                vbo.method_1352(builder.method_1326());
                return vbo;
            });
            return new MultiVBORenderer(buffers);
        }

        protected MultiVBORenderer(Map<class_1921, class_291> buffers) {
            this.buffers = ImmutableMap.copyOf(buffers);
        }

        public void sort(float x, float y, float z) {
        }

        public void render(class_1159 modelViewMatrix) {
            RenderSystem.setShader(class_757::method_35764);
            this.buffers.forEach((rt, vbo) -> {
                rt.method_23516();
                vbo.method_1353();
                vbo.method_34427(modelViewMatrix, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
                rt.method_23518();
            });
        }

        @Override
        public void close() {
            for (class_291 value : this.buffers.values()) {
                value.close();
            }
        }
    }
}

