/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen;

import com.direwolf20.buildinggadgets.client.KeyBindings;
import com.direwolf20.buildinggadgets.client.OurSounds;
import com.direwolf20.buildinggadgets.client.screen.CopyGUI;
import com.direwolf20.buildinggadgets.client.screen.MaterialListGUI;
import com.direwolf20.buildinggadgets.client.screen.PasteGUI;
import com.direwolf20.buildinggadgets.client.screen.components.GuiIconActionable;
import com.direwolf20.buildinggadgets.client.screen.components.GuiSliderInt;
import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.items.GadgetExchanger;
import com.direwolf20.buildinggadgets.common.items.modes.BuildingModes;
import com.direwolf20.buildinggadgets.common.items.modes.ExchangingModes;
import com.direwolf20.buildinggadgets.common.network.C2S.PacketAnchor;
import com.direwolf20.buildinggadgets.common.network.C2S.PacketChangeRange;
import com.direwolf20.buildinggadgets.common.network.C2S.PacketRotateMirror;
import com.direwolf20.buildinggadgets.common.network.C2S.PacketToggleBlockPlacement;
import com.direwolf20.buildinggadgets.common.network.C2S.PacketToggleConnectedArea;
import com.direwolf20.buildinggadgets.common.network.C2S.PacketToggleFluidOnly;
import com.direwolf20.buildinggadgets.common.network.C2S.PacketToggleFuzzy;
import com.direwolf20.buildinggadgets.common.network.C2S.PacketToggleMode;
import com.direwolf20.buildinggadgets.common.network.C2S.PacketToggleRayTraceFluid;
import com.direwolf20.buildinggadgets.common.network.C2S.PacketUndo;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.lang.GuiTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.RadialTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;

public class ModeRadialMenu
extends class_437 {
    private static final ImmutableList<class_2960> signsCopyPaste = ImmutableList.of((Object)new class_2960("buildinggadgets", "textures/gui/mode/copy.png"), (Object)new class_2960("buildinggadgets", "textures/gui/mode/paste.png"));
    private int timeIn = 0;
    private int slotSelected = -1;
    private int segments;
    private final List<class_4185> conditionalButtons = new ArrayList<class_4185>();

    public ModeRadialMenu(class_1799 stack) {
        super((class_2561)class_2561.method_43470((String)""));
        if (stack.method_7909() instanceof AbstractGadget) {
            this.setSocketable(stack);
        }
    }

    public void setSocketable(class_1799 stack) {
        if (stack.method_7909() instanceof GadgetBuilding) {
            this.segments = BuildingModes.values().length;
        } else if (stack.method_7909() instanceof GadgetExchanger) {
            this.segments = ExchangingModes.values().length;
        } else if (stack.method_7909() instanceof GadgetCopyPaste) {
            this.segments = GadgetCopyPaste.ToolMode.values().length;
        }
    }

    public void method_25426() {
        ScreenPosition left;
        this.conditionalButtons.clear();
        class_1799 tool = this.getGadget();
        boolean isDestruction = tool.method_7909() instanceof GadgetDestruction;
        ScreenPosition right = isDestruction ? ScreenPosition.TOP : ScreenPosition.RIGHT;
        ScreenPosition screenPosition = left = isDestruction ? ScreenPosition.BOTTOM : ScreenPosition.LEFT;
        if (isDestruction) {
            this.method_37063((class_364)new PositionedIconActionable(RadialTranslation.DESTRUCTION_OVERLAY, "destroy_overlay", right, send -> {
                if (send.booleanValue()) {
                    PacketChangeRange.send();
                }
                return GadgetDestruction.getOverlay(this.getGadget());
            }));
            this.method_37063((class_364)new PositionedIconActionable(RadialTranslation.FLUID_ONLY, "fluid_only", right, send -> {
                if (send.booleanValue()) {
                    PacketToggleFluidOnly.send();
                }
                return GadgetDestruction.getIsFluidOnly(this.getGadget());
            }));
        } else {
            this.method_37063((class_364)new PositionedIconActionable(RadialTranslation.ROTATE, "rotate", left, false, send -> {
                if (send.booleanValue()) {
                    PacketRotateMirror.send(PacketRotateMirror.Operation.ROTATE);
                }
                return false;
            }));
            this.method_37063((class_364)new PositionedIconActionable(RadialTranslation.MIRROR, "mirror", left, false, send -> {
                if (send.booleanValue()) {
                    PacketRotateMirror.send(PacketRotateMirror.Operation.MIRROR);
                }
                return false;
            }));
        }
        if (!(tool.method_7909() instanceof GadgetCopyPaste)) {
            PositionedIconActionable button;
            if (!isDestruction || BuildingGadgets.getConfig().gadgets.gadgetDestruction.nonFuzzyEnabled) {
                button = new PositionedIconActionable(RadialTranslation.FUZZY, "fuzzy", right, send -> {
                    if (send.booleanValue()) {
                        PacketToggleFuzzy.send();
                    }
                    return AbstractGadget.getFuzzy(this.getGadget());
                });
                this.method_37063((class_364)button);
                this.conditionalButtons.add(button);
            }
            if (!isDestruction) {
                button = new PositionedIconActionable(RadialTranslation.CONNECTED_SURFACE, "connected_area", right, send -> {
                    if (send.booleanValue()) {
                        PacketToggleConnectedArea.send();
                    }
                    return AbstractGadget.getConnectedArea(this.getGadget());
                });
                this.method_37063((class_364)button);
                this.conditionalButtons.add(button);
            }
            if (!isDestruction) {
                int widthSlider = 82;
                GuiSliderInt sliderRange = new GuiSliderInt(this.field_22789 / 2 - widthSlider / 2, this.field_22790 / 2 + 72, widthSlider, 14, (class_2561)GuiTranslation.SINGLE_RANGE.componentTranslation(new Object[0]).method_10852((class_2561)class_2561.method_43470((String)": ")), 1, BuildingGadgets.getConfig().gadgets.maxRange, GadgetUtils.getToolRange(tool), Color.DARK_GRAY, (slider, integer) -> slider.setValueInt(class_3532.method_15340((int)(slider.getValueInt() + integer), (int)1, (int)BuildingGadgets.getConfig().gadgets.maxRange)));
                sliderRange.getComponents().forEach(x$0 -> {
                    class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
                });
            }
        } else {
            this.method_37063((class_364)new PositionedIconActionable(RadialTranslation.OPEN_GUI, "copypaste_opengui", right, send -> {
                if (!send.booleanValue()) {
                    return false;
                }
                assert (class_310.method_1551().field_1724 != null);
                class_310.method_1551().field_1724.method_7346();
                if (GadgetCopyPaste.getToolMode(tool) == GadgetCopyPaste.ToolMode.COPY) {
                    class_310.method_1551().method_1507((class_437)new CopyGUI(tool));
                } else {
                    class_310.method_1551().method_1507((class_437)new PasteGUI(tool));
                }
                return true;
            }));
            this.method_37063((class_364)new PositionedIconActionable(RadialTranslation.OPEN_MATERIAL_LIST, "copypaste_materiallist", right, send -> {
                if (!send.booleanValue()) {
                    return false;
                }
                assert (class_310.method_1551().field_1724 != null);
                class_310.method_1551().field_1724.method_7346();
                class_310.method_1551().method_1507((class_437)new MaterialListGUI(tool));
                return true;
            }));
        }
        this.method_37063((class_364)new PositionedIconActionable(RadialTranslation.RAYTRACE_FLUID, "raytrace_fluid", right, send -> {
            if (send.booleanValue()) {
                PacketToggleRayTraceFluid.send();
            }
            return AbstractGadget.shouldRayTraceFluid(this.getGadget());
        }));
        if (tool.method_7909() instanceof GadgetBuilding) {
            this.method_37063((class_364)new PositionedIconActionable(RadialTranslation.PLACE_ON_TOP, "building_place_atop", right, send -> {
                if (send.booleanValue()) {
                    PacketToggleBlockPlacement.send();
                }
                return GadgetBuilding.shouldPlaceAtop(this.getGadget());
            }));
        }
        this.method_37063((class_364)new PositionedIconActionable(RadialTranslation.ANCHOR, "anchor", left, send -> {
            class_1799 stack;
            if (send.booleanValue()) {
                PacketAnchor.send();
            }
            if ((stack = this.getGadget()).method_7909() instanceof GadgetCopyPaste || stack.method_7909() instanceof GadgetDestruction) {
                return ((AbstractGadget)stack.method_7909()).getAnchor(stack) != null;
            }
            return GadgetUtils.getAnchor(stack).isPresent();
        }));
        if (!(tool.method_7909() instanceof GadgetExchanger)) {
            this.method_37063((class_364)new PositionedIconActionable(RadialTranslation.UNDO, "undo", left, false, send -> {
                if (send.booleanValue()) {
                    PacketUndo.send();
                }
                return false;
            }));
        }
        this.updateButtons(tool);
    }

    private void updateButtons(class_1799 tool) {
        PositionedIconActionable button;
        int posRight = 0;
        int posLeft = 0;
        int dim = 24;
        int padding = 10;
        boolean isDestruction = tool.method_7909() instanceof GadgetDestruction;
        ScreenPosition right = isDestruction ? ScreenPosition.BOTTOM : ScreenPosition.RIGHT;
        for (class_364 widget : this.method_25396()) {
            int offset;
            boolean isRight;
            if (!(widget instanceof PositionedIconActionable)) continue;
            button = (PositionedIconActionable)widget;
            if (!button.field_22764) continue;
            boolean bl = isRight = button.position == right;
            if (isRight) {
                posRight += dim + padding;
                offset = 70;
            } else {
                posLeft += dim + padding;
                offset = -70 - dim;
            }
            button.method_25358(dim);
            if (isDestruction) {
                button.field_22761 = this.field_22790 / 2 + (isRight ? 10 : -button.method_25364() - 10);
                continue;
            }
            button.field_22760 = this.field_22789 / 2 + offset;
        }
        posRight = this.resetPos(tool, padding, posRight);
        posLeft = this.resetPos(tool, padding, posLeft);
        for (class_364 widget : this.method_25396()) {
            int pos;
            if (!(widget instanceof PositionedIconActionable)) continue;
            button = (PositionedIconActionable)widget;
            if (!button.field_22764) continue;
            boolean isRight = button.position == right;
            int n = pos = isRight ? posRight : posLeft;
            if (isDestruction) {
                button.field_22760 = pos;
            } else {
                button.field_22761 = pos;
            }
            if (isRight) {
                posRight += dim + padding;
                continue;
            }
            posLeft += dim + padding;
        }
    }

    private int resetPos(class_1799 tool, int padding, int pos) {
        return tool.method_7909() instanceof GadgetDestruction ? this.field_22789 / 2 - (pos - padding) / 2 : this.field_22790 / 2 - (pos - padding) / 2;
    }

    private class_1799 getGadget() {
        assert (class_310.method_1551().field_1724 != null);
        return AbstractGadget.getGadget((class_1657)class_310.method_1551().field_1724);
    }

    public void method_25394(class_4587 matrices, int mx, int my, float partialTicks) {
        Object signs;
        int modeIndex;
        float stime = 5.0f;
        float fract = Math.min(stime, (float)this.timeIn + partialTicks) / stime;
        int x = this.field_22789 / 2;
        int y = this.field_22790 / 2;
        int radiusMin = 26;
        int radiusMax = 60;
        double dist = new class_243((double)x, (double)y, 0.0).method_1022(new class_243((double)mx, (double)my, 0.0));
        boolean inRange = false;
        if (this.segments != 0) {
            inRange = dist > (double)radiusMin && dist < (double)radiusMax;
            for (class_364 button : this.method_25396()) {
                if (!(button instanceof PositionedIconActionable)) continue;
                ((PositionedIconActionable)button).setFaded(inRange);
            }
        }
        matrices.method_22903();
        matrices.method_22904((double)((1.0f - fract) * (float)x), (double)((1.0f - fract) * (float)y), 0.0);
        matrices.method_22905(fract, fract, fract);
        super.method_25394(matrices, mx, my, partialTicks);
        matrices.method_22909();
        if (this.segments == 0) {
            return;
        }
        RenderSystem.disableTexture();
        float angle = ModeRadialMenu.mouseAngle(x, y, mx, my);
        RenderSystem.enableBlend();
        float totalDeg = 0.0f;
        float degPer = 360.0f / (float)this.segments;
        ArrayList<NameDisplayData> nameData = new ArrayList<NameDisplayData>();
        class_1799 tool = this.getGadget();
        if (tool.method_7960()) {
            return;
        }
        this.slotSelected = -1;
        if (tool.method_7909() instanceof GadgetBuilding) {
            modeIndex = GadgetBuilding.getToolMode(tool).ordinal();
            signs = Arrays.stream(BuildingModes.values()).map(e -> new class_2960("buildinggadgets", e.getIcon())).collect(Collectors.toList());
        } else if (tool.method_7909() instanceof GadgetExchanger) {
            modeIndex = GadgetExchanger.getToolMode(tool).ordinal();
            signs = Arrays.stream(ExchangingModes.values()).map(e -> new class_2960("buildinggadgets", e.getIcon())).collect(Collectors.toList());
        } else {
            modeIndex = GadgetCopyPaste.getToolMode(tool).ordinal();
            signs = signsCopyPaste;
        }
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferBuilder.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
        boolean shouldCenter = (this.segments + 2) % 4 == 0;
        int indexBottom = this.segments / 4;
        int indexTop = indexBottom + this.segments / 2;
        for (int seg = 0; seg < this.segments; ++seg) {
            boolean mouseInSector = this.isCursorInSlice(angle, totalDeg, degPer, inRange);
            float radius = Math.max(0.0f, Math.min(((float)this.timeIn + partialTicks - (float)seg * 6.0f / (float)this.segments) * 40.0f, (float)radiusMax));
            float gs = 0.25f;
            if (seg % 2 == 0) {
                gs += 0.1f;
            }
            float r = gs;
            float g = gs + (seg == modeIndex ? 1.0f : 0.0f);
            float b = gs;
            float a = 0.4f;
            if (mouseInSector) {
                this.slotSelected = seg;
                b = 1.0f;
                g = 1.0f;
                r = 1.0f;
            }
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
            for (float i = degPer; i >= 0.0f; i -= 1.0f) {
                float rad = (float)((double)((i + totalDeg) / 180.0f) * Math.PI);
                double xp = (double)x + Math.cos(rad) * (double)radius;
                double yp = (double)y + Math.sin(rad) * (double)radius;
                if ((int)i == (int)(degPer / 2.0f)) {
                    nameData.add(new NameDisplayData((int)xp, (int)yp, mouseInSector, shouldCenter && (seg == indexBottom || seg == indexTop)));
                }
                bufferBuilder.method_22912((double)x + Math.cos(rad) * (double)radius / (double)2.3f, (double)y + Math.sin(rad) * (double)radius / (double)2.3f, 0.0).method_22915(r, g, b, a).method_1344();
                bufferBuilder.method_22912(xp, yp, 0.0).method_22915(r, g, b, a).method_1344();
            }
            totalDeg += degPer;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        tessellator.method_1350();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        for (int i = 0; i < nameData.size(); ++i) {
            Color color;
            matrices.method_22903();
            NameDisplayData data = (NameDisplayData)nameData.get(i);
            int xp = data.getX();
            int yp = data.getY();
            String name = tool.method_7909() instanceof GadgetBuilding ? class_1074.method_4662((String)BuildingModes.values()[i].getTranslationKey(), (Object[])new Object[0]) : (tool.method_7909() instanceof GadgetExchanger ? class_1074.method_4662((String)ExchangingModes.values()[i].getTranslationKey(), (Object[])new Object[0]) : GadgetCopyPaste.ToolMode.values()[i].getTranslation().format(new Object[0]));
            int xsp = xp - 4;
            int ysp = yp;
            int width = this.field_22793.method_1727(name);
            if (xsp < x) {
                xsp -= width - 8;
            }
            if (ysp < y) {
                ysp -= 9;
            }
            Color color2 = color = i == modeIndex ? Color.GREEN : Color.WHITE;
            if (data.isSelected()) {
                this.field_22793.method_1720(matrices, name, (float)xsp + (data.isCentralized() ? (float)width / 2.0f - 4.0f : 0.0f), (float)ysp, color.getRGB());
            }
            double mod = 0.7;
            int xdp = (int)((double)(xp - x) * mod + (double)x);
            int ydp = (int)((double)(yp - y) * mod + (double)y);
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)((class_2960)signs.get(i)));
            ModeRadialMenu.method_25290((class_4587)matrices, (int)(xdp - 8), (int)(ydp - 8), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            matrices.method_22909();
        }
        float s = 2.25f * fract;
        class_4587 stack = RenderSystem.getModelViewStack();
        stack.method_22903();
        stack.method_22905(s, s, s);
        stack.method_22904((double)((float)x / s) - (tool.method_7909() instanceof GadgetCopyPaste ? 8.0 : 8.5), (double)((float)y / s - 8.0f), 0.0);
        this.field_22788.method_4023(tool, 0, 0);
        stack.method_22909();
    }

    private boolean isCursorInSlice(float angle, float totalDeg, float degPer, boolean inRange) {
        return inRange && angle > totalDeg && angle < totalDeg + degPer;
    }

    private void changeMode() {
        if (this.slotSelected >= 0) {
            class_1792 gadget = this.getGadget().method_7909();
            String mode = gadget instanceof GadgetBuilding ? class_1074.method_4662((String)BuildingModes.values()[this.slotSelected].getTranslationKey(), (Object[])new Object[0]) : (gadget instanceof GadgetExchanger ? class_1074.method_4662((String)ExchangingModes.values()[this.slotSelected].getTranslationKey(), (Object[])new Object[0]) : GadgetCopyPaste.ToolMode.values()[this.slotSelected].getTranslation().format(new Object[0]));
            assert (class_310.method_1551().field_1724 != null);
            class_310.method_1551().field_1724.method_7353((class_2561)MessageTranslation.MODE_SET.componentTranslation(mode).method_10862(Styles.AQUA), true);
            PacketToggleMode.send(this.slotSelected);
            OurSounds.BEEP.playSound();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        this.changeMode();
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public void method_25393() {
        if (!class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)KeyBindingHelper.getBoundKeyOf((class_304)KeyBindings.menuSettings).method_1444())) {
            this.method_25419();
            this.changeMode();
        }
        ImmutableSet set = ImmutableSet.of((Object)class_310.method_1551().field_1690.field_1894, (Object)class_310.method_1551().field_1690.field_1913, (Object)class_310.method_1551().field_1690.field_1881, (Object)class_310.method_1551().field_1690.field_1849, (Object)class_310.method_1551().field_1690.field_1832, (Object)class_310.method_1551().field_1690.field_1867, (Object[])new class_304[]{class_310.method_1551().field_1690.field_1903});
        for (class_304 k : set) {
            class_304.method_1416((class_3675.class_306)KeyBindingHelper.getBoundKeyOf((class_304)k), (boolean)k.method_1434());
        }
        ++this.timeIn;
        class_1799 tool = this.getGadget();
        boolean builder = tool.method_7909() instanceof GadgetBuilding;
        if (!builder && !(tool.method_7909() instanceof GadgetExchanger)) {
            return;
        }
        boolean changed = false;
        for (int i = 0; i < this.conditionalButtons.size(); ++i) {
            boolean current;
            class_4185 button = this.conditionalButtons.get(i);
            if (builder) {
                current = GadgetBuilding.getToolMode(tool) == BuildingModes.SURFACE;
            } else {
                boolean bl = current = i == 0 || GadgetExchanger.getToolMode(tool) == ExchangingModes.SURFACE;
            }
            if (button.field_22764 == current) continue;
            button.field_22764 = current;
            changed = true;
        }
        if (changed) {
            this.updateButtons(tool);
        }
    }

    public boolean method_25421() {
        return false;
    }

    private static float mouseAngle(int x, int y, int mx, int my) {
        Vector2f baseVec = new Vector2f(1.0f, 0.0f);
        Vector2f mouseVec = new Vector2f(mx - x, my - y);
        float ang = (float)(Math.acos(baseVec.dot(mouseVec) / (baseVec.length() * mouseVec.length())) * 57.29577951308232);
        return my < y ? 360.0f - ang : ang;
    }

    private void sendRangeUpdate(int valueNew) {
        if (valueNew != GadgetUtils.getToolRange(this.getGadget())) {
            PacketChangeRange.send(valueNew);
        }
    }

    public static enum ScreenPosition {
        RIGHT,
        LEFT,
        BOTTOM,
        TOP;

    }

    private static class PositionedIconActionable
    extends GuiIconActionable {
        private final ScreenPosition position;

        PositionedIconActionable(RadialTranslation message, String icon, ScreenPosition position, boolean isSelectable, Predicate<Boolean> action) {
            super(0, 0, icon, (class_2561)message.componentTranslation(new Object[0]), isSelectable, action);
            this.position = position;
        }

        PositionedIconActionable(RadialTranslation message, String icon, ScreenPosition position, Predicate<Boolean> action) {
            this(message, icon, position, true, action);
        }
    }

    private record NameDisplayData(int x, int y, boolean selected, boolean centralize) {
        private int getX() {
            return this.x();
        }

        private int getY() {
            return this.y();
        }

        private boolean isSelected() {
            return this.selected();
        }

        private boolean isCentralized() {
            return this.centralize();
        }
    }

    private static class Vector2f {
        public final float x;
        public final float y;

        public Vector2f(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public final float dot(Vector2f v1) {
            return this.x * v1.x + this.y * v1.y;
        }

        public final float length() {
            return (float)Math.sqrt(this.x * this.x + this.y * this.y);
        }
    }
}

