/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.commands.ForceUnloadedCommand;
import com.direwolf20.buildinggadgets.common.compat.FLANCompat;
import com.direwolf20.buildinggadgets.common.compat.FTBChunksCompat;
import com.direwolf20.buildinggadgets.common.compat.GOMLCompat;
import com.direwolf20.buildinggadgets.common.component.BGComponent;
import com.direwolf20.buildinggadgets.common.component.UndoService;
import com.direwolf20.buildinggadgets.common.items.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.items.modes.AbstractMode;
import com.direwolf20.buildinggadgets.common.items.modes.GridMode;
import com.direwolf20.buildinggadgets.common.items.modes.HorizontalColumnMode;
import com.direwolf20.buildinggadgets.common.items.modes.StairMode;
import com.direwolf20.buildinggadgets.common.items.modes.VerticalColumnMode;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.concurrent.UndoScheduler;
import com.direwolf20.buildinggadgets.common.tainted.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.tainted.save.Undo;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.google.common.collect.ImmutableSortedSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBlockTags;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.base.SimpleBatteryItem;

public abstract class AbstractGadget
extends class_1792
implements SimpleBatteryItem {
    private final class_6862<class_2248> whiteList;
    private final class_6862<class_2248> blackList;

    public AbstractGadget(class_1792.class_1793 builder, class_2960 whiteListTag, class_2960 blackListTag) {
        super(builder.method_7898(0));
        this.whiteList = class_6862.method_40092((class_5321)class_2378.field_25105, (class_2960)whiteListTag);
        this.blackList = class_6862.method_40092((class_5321)class_2378.field_25105, (class_2960)blackListTag);
    }

    public abstract long getEnergyCapacity();

    public abstract long getEnergyCost(class_1799 var1);

    public int method_31571(class_1799 itemStack) {
        float f = (float)this.method_31569(itemStack) / 13.0f;
        return class_3532.method_15369((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean method_31567(class_1799 itemStack) {
        if (this.getEnergyCapacity() <= 0L) {
            return false;
        }
        return this.getEnergyCapacity() != this.getStoredEnergy(itemStack);
    }

    public int method_31569(class_1799 itemStack) {
        return (int)(13.0f - ((float)this.getEnergyCapacity() - (float)this.getStoredEnergy(itemStack)) * 13.0f / (float)this.getEnergyCapacity());
    }

    public long getEnergyMaxInput() {
        return 10000L;
    }

    public long getEnergyMaxOutput() {
        return 0L;
    }

    public class_6862<class_2248> getWhiteList() {
        return this.whiteList;
    }

    public class_6862<class_2248> getBlackList() {
        return this.blackList;
    }

    public void method_7850(class_1761 group, class_2371<class_1799> items) {
        super.method_7850(group, items);
        if (!this.method_7877(group)) {
            return;
        }
        class_1799 charged = new class_1799((class_1935)this);
        charged.method_7948().method_10549("energy", (double)this.getEnergyCapacity());
        items.add((Object)charged);
    }

    public boolean method_7878(class_1799 toRepair, class_1799 repair) {
        return repair.method_7909() instanceof AbstractGadget && repair.method_7909() == class_1802.field_8477;
    }

    public boolean isAllowedBlock(class_2248 block) {
        if (block.method_9564().method_26164(ConventionalBlockTags.MOVEMENT_RESTRICTED)) {
            return false;
        }
        if (!class_2378.field_11146.method_40286(this.getWhiteList()).iterator().hasNext()) {
            return !block.method_9564().method_26164(this.getBlackList());
        }
        return block.method_9564().method_26164(this.getWhiteList());
    }

    public static class_1799 getGadget(class_1657 player) {
        class_1799 heldItem = player.method_6047();
        if (!(heldItem.method_7909() instanceof AbstractGadget) && !((heldItem = player.method_6079()).method_7909() instanceof AbstractGadget)) {
            return class_1799.field_8037;
        }
        return heldItem;
    }

    public boolean canUse(class_1799 tool, class_1657 player) {
        if (player.method_7337() || this.getEnergyCapacity() == 0L) {
            return true;
        }
        return this.getEnergyCost(tool) <= SimpleBatteryItem.getStoredEnergyUnchecked((class_1799)tool);
    }

    public boolean useEnergy(class_1799 tool, class_3222 player) {
        if (player.method_7337() || this.getEnergyCapacity() == 0L) {
            return true;
        }
        return ((AbstractGadget)tool.method_7909()).tryUseEnergy(tool, this.getEnergyCost(tool));
    }

    protected void addEnergyInformation(List<class_2561> tooltip, class_1799 stack) {
        if (this.getEnergyCapacity() == 0L) {
            return;
        }
        if (stack.method_7909() instanceof SimpleBatteryItem) {
            tooltip.add((class_2561)TooltipTranslation.GADGET_ENERGY.componentTranslation(GadgetUtils.withSuffix((int)this.getStoredEnergy(stack)), GadgetUtils.withSuffix((int)this.getEnergyCapacity())).method_10862(Styles.GRAY));
        }
    }

    public final void onRotate(class_1799 stack, class_1657 player) {
        if (this.performRotate(stack, player)) {
            player.method_7353((class_2561)MessageTranslation.ROTATED.componentTranslation(new Object[0]).method_10862(Styles.AQUA), true);
        }
    }

    protected boolean performRotate(class_1799 stack, class_1657 player) {
        return false;
    }

    public final void onMirror(class_1799 stack, class_1657 player) {
        if (this.performMirror(stack, player)) {
            player.method_7353((class_2561)MessageTranslation.MIRRORED.componentTranslation(new Object[0]).method_10862(Styles.AQUA), true);
        }
    }

    protected boolean performMirror(class_1799 stack, class_1657 player) {
        return false;
    }

    public final void onAnchor(class_1799 stack, class_1657 player) {
        if (this.getAnchor(stack) == null) {
            class_3965 lookingAt = VectorHelper.getLookingAt(player, stack);
            if (player.field_6002.method_22347(lookingAt.method_17777())) {
                return;
            }
            this.onAnchorSet(stack, player, lookingAt);
            player.method_7353((class_2561)MessageTranslation.ANCHOR_SET.componentTranslation(new Object[0]).method_10862(Styles.AQUA), true);
        } else {
            this.onAnchorRemoved(stack, player);
            player.method_7353((class_2561)MessageTranslation.ANCHOR_REMOVED.componentTranslation(new Object[0]).method_10862(Styles.AQUA), true);
        }
    }

    protected void onAnchorSet(class_1799 stack, class_1657 player, class_3965 lookingAt) {
        GadgetUtils.writePOSToNBT(stack, lookingAt.method_17777(), "anchor");
    }

    protected void onAnchorRemoved(class_1799 stack, class_1657 player) {
        stack.method_7948().method_10551("anchor");
    }

    @Nullable
    public class_2338 getAnchor(class_1799 stack) {
        return GadgetUtils.getPOSFromNBT(stack, "anchor");
    }

    public static boolean getFuzzy(class_1799 stack) {
        return stack.method_7948().method_10577("fuzzy");
    }

    public static void toggleFuzzy(class_1657 player, class_1799 stack) {
        stack.method_7948().method_10556("fuzzy", !AbstractGadget.getFuzzy(stack));
        player.method_7353((class_2561)MessageTranslation.FUZZY_MODE.componentTranslation(AbstractGadget.getFuzzy(stack)).method_10862(Styles.AQUA), true);
    }

    public static boolean getConnectedArea(class_1799 stack) {
        return !stack.method_7948().method_10577("unconnected_area");
    }

    public static void toggleConnectedArea(class_1657 player, class_1799 stack) {
        stack.method_7948().method_10556("unconnected_area", AbstractGadget.getConnectedArea(stack));
        player.method_7353((class_2561)(stack.method_7909() instanceof GadgetDestruction ? MessageTranslation.CONNECTED_AREA : MessageTranslation.CONNECTED_SURFACE).componentTranslation(AbstractGadget.getConnectedArea(stack)).method_10862(Styles.AQUA), true);
    }

    public static boolean shouldRayTraceFluid(class_1799 stack) {
        return stack.method_7948().method_10577("raytrace_fluid");
    }

    public static void toggleRayTraceFluid(class_3222 player, class_1799 stack) {
        stack.method_7948().method_10556("raytrace_fluid", !AbstractGadget.shouldRayTraceFluid(stack));
        player.method_7353((class_2561)MessageTranslation.RAYTRACE_FLUID.componentTranslation(AbstractGadget.shouldRayTraceFluid(stack)).method_10862(Styles.AQUA), true);
    }

    public static void addInformationRayTraceFluid(List<class_2561> tooltip, class_1799 stack) {
        tooltip.add((class_2561)TooltipTranslation.GADGET_RAYTRACE_FLUID.componentTranslation(String.valueOf(AbstractGadget.shouldRayTraceFluid(stack))).method_10862(Styles.BLUE));
    }

    public UUID getUUID(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (nbt.method_25928("uuid")) {
            return nbt.method_25926("uuid");
        }
        UUID newId = UUID.randomUUID();
        nbt.method_25927("uuid", newId);
        return newId;
    }

    public static int getRangeInBlocks(int range, AbstractMode mode) {
        if (mode instanceof StairMode || mode instanceof VerticalColumnMode || mode instanceof HorizontalColumnMode) {
            return range;
        }
        if (mode instanceof GridMode) {
            return range < 7 ? 9 : (range < 13 ? 121 : 361);
        }
        return range == 1 ? 1 : (range + 1) * (range + 1);
    }

    protected void pushUndo(class_1799 stack, Undo undo, class_1937 world) {
        if (undo.getUndoData().isEmpty()) {
            return;
        }
        ((UndoService)BGComponent.UNDO_COMPONENT.get((Object)world.method_8401())).insertUndo(this.getUUID(stack), undo);
    }

    public void undo(class_1937 world, class_1657 player, class_1799 stack) {
        Optional<Undo> undoOptional = ((UndoService)BGComponent.UNDO_COMPONENT.get((Object)world.method_8401())).getUndo(this.getUUID(stack));
        if (undoOptional.isPresent()) {
            ImmutableSortedSet<class_1923> unloadedChunks;
            Undo undo = undoOptional.get();
            IItemIndex index = InventoryHelper.index(stack, player);
            if (!ForceUnloadedCommand.mayForceUnloadedChunks(player) && !(unloadedChunks = undo.getBoundingBox().getUnloadedChunks((class_4538)world)).isEmpty()) {
                this.pushUndo(stack, undo, world);
                player.method_7353((class_2561)MessageTranslation.UNDO_UNLOADED.componentTranslation(new Object[0]).method_10862(Styles.RED), true);
                BuildingGadgets.LOG.error("Player attempted to undo a Region missing {} unloaded chunks. Denied undo!", (Object)unloadedChunks.size());
                BuildingGadgets.LOG.trace("The following chunks were detected as unloaded {}.", unloadedChunks);
                return;
            }
            BuildContext buildContext = BuildContext.builder().player(player).stack(stack).build((class_1936)world);
            UndoScheduler.scheduleUndo(undo, index, buildContext, BuildingGadgets.getConfig().gadgets.placeSteps);
        } else {
            player.method_7353((class_2561)MessageTranslation.NOTHING_TO_UNDO.componentTranslation(new Object[0]).method_10862(Styles.RED), true);
        }
    }

    protected static boolean mayInteract(class_3222 player, class_2338 pos) {
        return player.method_36971(player.field_6002, pos) && GOMLCompat.canUse(player, pos) && FLANCompat.canUse(player, pos) && FTBChunksCompat.canUse(player, pos);
    }
}

