/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items;

import com.direwolf20.buildinggadgets.client.renders.BaseRenderer;
import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.blocks.OurBlocks;
import com.direwolf20.buildinggadgets.common.enchants.GadgetSilkTouch;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.modes.AbstractMode;
import com.direwolf20.buildinggadgets.common.items.modes.ExchangingModes;
import com.direwolf20.buildinggadgets.common.network.C2S.PacketBindTool;
import com.direwolf20.buildinggadgets.common.network.C2S.PacketRotateMirror;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileEntityData;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.tainted.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.LangUtil;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.direwolf20.buildinggadgets.common.util.ref.Reference;
import com.direwolf20.buildinggadgets.common.world.MockBuilderWorld;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.PeekingIterator;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class GadgetExchanger
extends AbstractGadget {
    private static final MockBuilderWorld fakeWorld = new MockBuilderWorld();

    public GadgetExchanger(class_1792.class_1793 builder) {
        super(builder, Reference.TagReference.WHITELIST_EXCHANGING, Reference.TagReference.BLACKLIST_EXCHANGING);
    }

    @Override
    public long getEnergyCapacity() {
        return BuildingGadgets.getConfig().gadgets.gadgetExchanger.maxEnergy;
    }

    @Override
    public long getEnergyCost(class_1799 tool) {
        return BuildingGadgets.getConfig().gadgets.gadgetExchanger.energyCost;
    }

    public int method_7837() {
        return 3;
    }

    public boolean method_7870(class_1799 stack) {
        return true;
    }

    private static void setToolMode(class_1799 tool, ExchangingModes mode) {
        class_2487 tagCompound = tool.method_7948();
        tagCompound.method_10582("mode", mode.toString());
        tool.method_7980(tagCompound);
    }

    public static ExchangingModes getToolMode(class_1799 tool) {
        class_2487 tagCompound = tool.method_7948();
        return ExchangingModes.getFromName(tagCompound.method_10558("mode"));
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 flag) {
        super.method_7851(stack, world, tooltip, flag);
        this.addEnergyInformation(tooltip, stack);
        ExchangingModes mode = GadgetExchanger.getToolMode(stack);
        tooltip.add((class_2561)TooltipTranslation.GADGET_MODE.componentTranslation(mode == ExchangingModes.SURFACE && GadgetExchanger.getConnectedArea(stack) ? TooltipTranslation.GADGET_CONNECTED.format(class_2561.method_43471((String)mode.getTranslationKey()).getString()) : class_2561.method_43471((String)mode.getTranslationKey())).method_10862(Styles.AQUA));
        tooltip.add((class_2561)TooltipTranslation.GADGET_BLOCK.componentTranslation(LangUtil.getFormattedBlockName(GadgetUtils.getToolBlock(stack).getState())).method_10862(Styles.DK_GREEN));
        int range = GadgetUtils.getToolRange(stack);
        tooltip.add((class_2561)TooltipTranslation.GADGET_RANGE.componentTranslation(range, GadgetExchanger.getRangeInBlocks(range, mode.getMode())).method_10862(Styles.LT_PURPLE));
        tooltip.add((class_2561)TooltipTranslation.GADGET_FUZZY.componentTranslation(String.valueOf(GadgetExchanger.getFuzzy(stack))).method_10862(Styles.GOLD));
        GadgetExchanger.addInformationRayTraceFluid(tooltip, stack);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        player.method_6019(hand);
        if (!world.field_9236) {
            if (player.method_5715()) {
                class_1271<class_2248> result = GadgetUtils.selectBlock(itemstack, player);
                if (!result.method_5467().method_23665()) {
                    player.method_7353((class_2561)MessageTranslation.INVALID_BLOCK.componentTranslation(class_2378.field_11146.method_10221((Object)((class_2248)result.method_5466()))).method_10862(Styles.AQUA), true);
                    return super.method_7836(world, player, hand);
                }
            } else if (player instanceof class_3222) {
                try (Transaction transaction = Transaction.openOuter();){
                    this.exchange((class_3222)player, itemstack, (TransactionContext)transaction);
                    transaction.commit();
                }
            }
        } else if (!player.method_5715()) {
            BaseRenderer.updateInventoryCache();
        } else if (class_437.method_25441()) {
            PacketBindTool.send();
        }
        return new class_1271(class_1269.field_5812, (Object)itemstack);
    }

    public void setMode(class_1799 heldItem, int modeInt) {
        ExchangingModes mode = ExchangingModes.values()[modeInt];
        GadgetExchanger.setToolMode(heldItem, mode);
    }

    public static void rangeChange(class_1657 player, class_1799 heldItem) {
        int changeAmount;
        int range = GadgetUtils.getToolRange(heldItem);
        int n = changeAmount = GadgetExchanger.getToolMode(heldItem) == ExchangingModes.GRID || range % 2 == 0 ? 1 : 2;
        range = player.method_5715() ? (range <= 1 ? BuildingGadgets.getConfig().gadgets.maxRange : range - changeAmount) : (range >= BuildingGadgets.getConfig().gadgets.maxRange ? 1 : range + changeAmount);
        GadgetUtils.setToolRange(heldItem, range);
        player.method_7353((class_2561)MessageTranslation.RANGE_SET.componentTranslation(range).method_10862(Styles.AQUA), true);
    }

    private void exchange(class_3222 player, class_1799 stack, TransactionContext transactionContext) {
        class_3218 world = player.method_14220();
        class_1799 heldItem = GadgetExchanger.getGadget((class_1657)player);
        if (heldItem.method_7960()) {
            return;
        }
        BlockData blockData = GadgetUtils.getToolBlock(heldItem);
        class_3965 lookingAt = VectorHelper.getLookingAt((class_1657)player, stack);
        class_2586 tileEntity = world.method_8321(lookingAt.method_17777());
        class_2680 lookingAtState = player.field_6002.method_8320(lookingAt.method_17777());
        class_2248 lookAtBlock = lookingAtState.method_26204();
        if (blockData.getState() == class_2246.field_10124.method_9564() || lookAtBlock == OurBlocks.EFFECT_BLOCK || blockData.getState() == lookingAtState || tileEntity != null) {
            return;
        }
        Optional<List<class_2338>> anchor = GadgetUtils.getAnchor(stack);
        List coords = anchor.orElseGet(() -> GadgetExchanger.getToolMode(stack).getMode().getCollection(new AbstractMode.UseContext((class_1937)world, blockData.getState(), lookingAt.method_17777(), heldItem, lookingAt.method_17780(), GadgetExchanger.getConnectedArea(heldItem)), (class_1657)player));
        if (anchor.isPresent()) {
            GadgetUtils.setAnchor(stack);
        }
        IItemIndex index = InventoryHelper.index(stack, (class_1657)player);
        fakeWorld.setWorldAndState(player.field_6002, blockData.getState(), coords);
        for (class_2338 coordinate : coords) {
            this.exchangeBlock(world, player, index, coordinate, blockData, transactionContext);
        }
    }

    private void exchangeBlock(class_3218 world, class_3222 player, IItemIndex index, class_2338 pos, BlockData setBlock, TransactionContext transaction) {
        class_2680 currentBlock = world.method_8320(pos);
        ITileEntityData data = TileSupport.createTileData((class_1922)world, pos);
        class_1799 tool = GadgetExchanger.getGadget((class_1657)player);
        if (tool.method_7960() || !this.canUse(tool, (class_1657)player) || !GadgetExchanger.mayInteract(player, pos)) {
            return;
        }
        BuildContext buildContext = BuildContext.builder().stack(tool).player((class_1657)player).build((class_1936)world);
        MaterialList requiredItems = setBlock.getRequiredItems(buildContext, null, pos);
        MatchResult match = index.match(requiredItems, transaction);
        if (!match.isSuccess()) {
            return;
        }
        if (!player.method_7294() || !world.method_8505((class_1657)player, pos)) {
            return;
        }
        if (this.useEnergy(tool, player)) {
            MaterialList materials = data.getRequiredItems(buildContext, currentBlock, (class_239)world.method_17742(new class_3959(player.method_19538(), class_243.method_24954((class_2382)pos), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player)), pos);
            PeekingIterator<ImmutableMultiset<ItemVariant>> it = materials.iterator();
            LinkedHashMultiset producedItems = LinkedHashMultiset.create();
            if (buildContext.getStack().method_7942() && class_1890.method_8225((class_1887)GadgetSilkTouch.GADGET_SILKTOUCH, (class_1799)buildContext.getStack()) > 0) {
                producedItems = it.hasNext() ? (Multiset)it.next() : ImmutableMultiset.of();
            } else {
                List drops = class_2248.method_9562((class_2680)currentBlock, (class_3218)((class_3218)buildContext.getWorld()), (class_2338)pos, (class_2586)buildContext.getWorld().method_8321(pos));
                producedItems.addAll((Collection)drops.stream().map(ItemVariant::of).collect(Collectors.toList()));
            }
            index.insert((Multiset<ItemVariant>)producedItems, transaction);
            EffectBlock.spawnEffectBlock((class_1936)world, pos, setBlock, EffectBlock.Mode.REPLACE);
        }
    }

    public static class_1799 getGadget(class_1657 player) {
        class_1799 stack = AbstractGadget.getGadget(player);
        if (!(stack.method_7909() instanceof GadgetExchanger)) {
            return class_1799.field_8037;
        }
        return stack;
    }

    public int method_7881(class_1799 stack) {
        return 20;
    }

    @Override
    public boolean performRotate(class_1799 stack, class_1657 player) {
        GadgetUtils.rotateOrMirrorToolBlock(stack, player, PacketRotateMirror.Operation.ROTATE);
        return true;
    }

    @Override
    public boolean performMirror(class_1799 stack, class_1657 player) {
        GadgetUtils.rotateOrMirrorToolBlock(stack, player, PacketRotateMirror.Operation.MIRROR);
        return true;
    }
}

