/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.modes;

import com.direwolf20.buildinggadgets.common.items.modes.AbstractMode;
import com.direwolf20.buildinggadgets.common.items.modes.BuildToMeMode;
import com.direwolf20.buildinggadgets.common.items.modes.GridMode;
import com.direwolf20.buildinggadgets.common.items.modes.HorizontalColumnMode;
import com.direwolf20.buildinggadgets.common.items.modes.HorizontalWallMode;
import com.direwolf20.buildinggadgets.common.items.modes.StairMode;
import com.direwolf20.buildinggadgets.common.items.modes.SurfaceMode;
import com.direwolf20.buildinggadgets.common.items.modes.VerticalColumnMode;
import com.direwolf20.buildinggadgets.common.items.modes.VerticalWallMode;
import java.util.Arrays;

public enum BuildingModes {
    BUILD_TO_ME(new BuildToMeMode(), "build_to_me"),
    VERTICAL_COLUMN(new VerticalColumnMode(false), "vertical_column"),
    HORIZONTAL_COLUMN(new HorizontalColumnMode(false), "horizontal_column"),
    VERTICAL_WALL(new VerticalWallMode(), "vertical_wall"),
    HORIZONTAL_WALL(new HorizontalWallMode(), "horizontal_wall"),
    STAIR(new StairMode(), "stairs"),
    GRID(new GridMode(false), "grid"),
    SURFACE(new SurfaceMode(false), "surface");

    final AbstractMode mode;
    final String name;

    private BuildingModes(AbstractMode mode, String name) {
        this.mode = mode;
        this.name = name;
    }

    public AbstractMode getMode() {
        return this.mode;
    }

    public String getName() {
        return this.name;
    }

    public String getTranslationKey() {
        return "buildinggadgets.modes." + this.name;
    }

    public String getIcon() {
        return "textures/gui/mode/" + this.name + ".png";
    }

    public static BuildingModes getFromName(String name) {
        return Arrays.stream(BuildingModes.values()).filter(e -> e.toString().equals(name)).findFirst().orElse(BUILD_TO_ME);
    }
}

