/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.bidirection;

import com.direwolf20.buildinggadgets.client.BuildingGadgetsClient;
import com.direwolf20.buildinggadgets.common.component.BGComponent;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.Target;
import com.direwolf20.buildinggadgets.common.tainted.template.Template;
import com.direwolf20.buildinggadgets.common.tainted.template.TemplateIO;
import com.direwolf20.buildinggadgets.common.tainted.template.TemplateKey;
import com.direwolf20.buildinggadgets.common.util.exceptions.TemplateReadException;
import com.direwolf20.buildinggadgets.common.util.exceptions.TemplateWriteException;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2598;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;

public class SplitPacketUpdateTemplate {
    public static final int PAYLOAD_LIMIT = Short.MAX_VALUE;

    public static void sendToTarget(Target target, UUID id, Template template) {
        if (target.flow() == class_2598.field_11942) {
            Server.send(id, template, target.player());
        } else {
            Client.send(id, template);
        }
    }

    private static Template readTemplate(class_2540 buf) throws TemplateReadException {
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        return TemplateIO.readTemplate(new ByteArrayInputStream(bytes), null);
    }

    private static void write(class_2540 buf, UUID id, Template template) {
        buf.method_10797(id);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            TemplateIO.writeTemplate(template, stream);
            buf.writeBytes(stream.toByteArray());
        }
        catch (TemplateWriteException e) {
            e.printStackTrace();
        }
    }

    public static class Server
    implements ServerPlayNetworking.PlayChannelHandler {
        private final Map<class_3222, class_2540> buffers = new WeakHashMap<class_3222, class_2540>();

        public static void send(UUID id, Template template, class_3222 player) {
            class_2540 buf = PacketByteBufs.create();
            SplitPacketUpdateTemplate.write(buf, id, template);
            while (buf.isReadable(Short.MAX_VALUE)) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)PacketHandler.SplitPacketUpdateTemplate, (class_2540)PacketByteBufs.readBytes((ByteBuf)buf, (int)Short.MAX_VALUE));
            }
            if (buf.isReadable()) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)PacketHandler.SplitPacketUpdateTemplate, (class_2540)buf);
            }
            ServerPlayNetworking.send((class_3222)player, (class_2960)PacketHandler.SplitPacketUpdateTemplate, (class_2540)PacketByteBufs.empty());
        }

        public void receive(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
            class_2540 accumulator = this.buffers.computeIfAbsent(player, $ -> PacketByteBufs.create());
            if (buf.isReadable()) {
                accumulator.writeBytes((ByteBuf)buf);
                return;
            }
            UUID id = accumulator.method_10790();
            try {
                Template template = SplitPacketUpdateTemplate.readTemplate(accumulator);
                server.execute(() -> BGComponent.TEMPLATE_PROVIDER_COMPONENT.maybeGet((Object)player.field_6002).ifPresent(provider -> provider.setTemplate(new TemplateKey(id), template)));
            }
            catch (TemplateReadException e) {
                e.printStackTrace();
            }
            this.buffers.remove(player).release();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Client
    implements ClientPlayNetworking.PlayChannelHandler {
        private class_2540 accumulator;

        public static void send(UUID id, Template template) {
            class_2540 buf = PacketByteBufs.create();
            SplitPacketUpdateTemplate.write(buf, id, template);
            while (buf.isReadable(Short.MAX_VALUE)) {
                ClientPlayNetworking.send((class_2960)PacketHandler.SplitPacketUpdateTemplate, (class_2540)PacketByteBufs.readBytes((ByteBuf)buf, (int)Short.MAX_VALUE));
            }
            if (buf.isReadable()) {
                ClientPlayNetworking.send((class_2960)PacketHandler.SplitPacketUpdateTemplate, (class_2540)buf);
            }
            ClientPlayNetworking.send((class_2960)PacketHandler.SplitPacketUpdateTemplate, (class_2540)PacketByteBufs.empty());
        }

        public void receive(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
            if (this.accumulator == null) {
                this.accumulator = PacketByteBufs.create();
            }
            if (buf.isReadable()) {
                this.accumulator.writeBytes((ByteBuf)buf);
                return;
            }
            UUID id = this.accumulator.method_10790();
            try {
                Template template = SplitPacketUpdateTemplate.readTemplate(this.accumulator);
                client.execute(() -> BuildingGadgetsClient.CACHE_TEMPLATE_PROVIDER.setTemplate(new TemplateKey(id), template));
            }
            catch (TemplateReadException e) {
                e.printStackTrace();
            }
            this.accumulator.release();
            this.accumulator = null;
        }
    }
}

