/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.building.placement;

import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.google.common.collect.AbstractIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectedSurface
implements Iterable<class_2338> {
    private final class_1922 world;
    private final Region searchingRegion;
    private final Function<class_2338, class_2338> searching2referenceMapper;
    private final class_2338 searchingCenter;
    @Nullable
    private final class_2350 side;
    private final BiPredicate<class_2680, class_2338> predicate;

    public static ConnectedSurface create(Region searchingRegion, class_1922 world, class_2338 searchingCenter, class_2350 side, int range, boolean fuzzy) {
        return ConnectedSurface.create(searchingRegion, world, pos -> pos.method_10093(side), searchingCenter, side, range, fuzzy);
    }

    public static ConnectedSurface create(Region searchingRegion, class_1922 world, Function<class_2338, class_2338> searching2referenceMapper, class_2338 searchingCenter, class_2350 side, int range, boolean fuzzy) {
        return ConnectedSurface.create(world, searchingRegion, searching2referenceMapper, searchingCenter, side, fuzzy);
    }

    public static ConnectedSurface create(class_1922 world, Region searchingRegion, Function<class_2338, class_2338> searching2referenceMapper, class_2338 searchingCenter, @Nullable class_2350 side, boolean fuzzy) {
        return new ConnectedSurface(world, searchingRegion, searching2referenceMapper, searchingCenter, side, fuzzy);
    }

    public static ConnectedSurface create(class_1922 world, Region searchingRegion, Function<class_2338, class_2338> searching2referenceMapper, class_2338 searchingCenter, @Nullable class_2350 side, BiPredicate<class_2680, class_2338> predicate) {
        return new ConnectedSurface(world, searchingRegion, searching2referenceMapper, searchingCenter, side, predicate);
    }

    ConnectedSurface(class_1922 world, Region searchingRegion, Function<class_2338, class_2338> searching2referenceMapper, class_2338 searchingCenter, @Nullable class_2350 side, boolean fuzzy) {
        this(world, searchingRegion, searching2referenceMapper, searchingCenter, side, (filter, pos) -> {
            class_2680 reference = world.method_8320((class_2338)searching2referenceMapper.apply((class_2338)pos));
            boolean isAir = reference.method_26215();
            return !isAir && (fuzzy || filter == reference);
        });
    }

    ConnectedSurface(class_1922 world, Region searchingRegion, Function<class_2338, class_2338> searching2referenceMapper, class_2338 searchingCenter, @Nullable class_2350 side, BiPredicate<class_2680, class_2338> predicate) {
        this.world = world;
        this.searchingRegion = searchingRegion;
        this.searching2referenceMapper = searching2referenceMapper;
        this.searchingCenter = searchingCenter;
        this.side = side;
        this.predicate = predicate;
    }

    public Region getBoundingBox() {
        return this.searchingRegion;
    }

    @Override
    @NotNull
    public Iterator<class_2338> iterator() {
        final class_2680 selectedBlock = this.getReferenceFor(this.searchingCenter);
        return new AbstractIterator<class_2338>(){
            private final Queue<class_2338> queue = new LinkedList<class_2338>();
            private final Set<class_2338> searched;
            {
                this.searched = new HashSet<class_2338>(ConnectedSurface.this.searchingRegion.size());
                if (this.isValid(ConnectedSurface.this.searchingCenter)) {
                    this.queue.add(ConnectedSurface.this.searchingCenter);
                    this.searched.add(ConnectedSurface.this.searchingCenter);
                }
            }

            protected class_2338 computeNext() {
                if (this.queue.isEmpty()) {
                    return (class_2338)this.endOfData();
                }
                class_2338 current = this.queue.remove();
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        if (ConnectedSurface.this.side != null) {
                            class_2338 neighbor = ConnectedSurface.this.perpendicularSurfaceOffset(current, ConnectedSurface.this.side.method_10166(), i, j);
                            this.addNeighbour(neighbor);
                            continue;
                        }
                        for (int k = -1; k <= 1; ++k) {
                            class_2338 neighbor = current.method_10069(i, j, k);
                            this.addNeighbour(neighbor);
                        }
                    }
                }
                return current;
            }

            private void addNeighbour(class_2338 neighbor) {
                boolean isSearched;
                boolean bl = isSearched = !this.searched.add(neighbor);
                if (isSearched || !this.isValid(neighbor)) {
                    return;
                }
                this.queue.add(neighbor);
            }

            private boolean isValid(class_2338 pos) {
                return ConnectedSurface.this.searchingRegion.contains((class_2382)pos) && ConnectedSurface.this.predicate.test(selectedBlock, pos);
            }
        };
    }

    private class_2680 getReferenceFor(class_2338 pos) {
        return this.world.method_8320(this.searching2referenceMapper.apply(pos));
    }

    public class_2338 perpendicularSurfaceOffset(class_2338 pos, class_2350.class_2351 intersector, int i, int j) {
        return switch (intersector) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> pos.method_10069(0, i, j);
            case class_2350.class_2351.field_11052 -> pos.method_10069(i, 0, j);
            case class_2350.class_2351.field_11051 -> pos.method_10069(i, j, 0);
        };
    }
}

