/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.building.view;

import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.PlacementTarget;
import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.building.view.IBuildView;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WorldBuildView
implements IBuildView {
    private final BuildContext context;
    private final Region region;
    private final BiFunction<BuildContext, class_2338, Optional<BlockData>> dataFactory;
    private class_2338 translation;

    public static WorldBuildView create(BuildContext context, Region region) {
        return WorldBuildView.create(context, region, null);
    }

    public static WorldBuildView create(BuildContext context, Region region, @Nullable BiFunction<BuildContext, class_2338, Optional<BlockData>> dataFactory) {
        return new WorldBuildView(Objects.requireNonNull(context, "Cannot create WorldBuildView without an BuildContext!"), Objects.requireNonNull(region, "Cannot create WorldBuildView without an Region!"), dataFactory != null ? dataFactory : (c, p) -> Optional.of(TileSupport.createBlockData((class_1922)c.getWorld(), p)));
    }

    private WorldBuildView(BuildContext context, Region region, BiFunction<BuildContext, class_2338, Optional<BlockData>> dataFactory) {
        this.context = context;
        this.region = region;
        this.dataFactory = dataFactory;
        this.translation = class_2338.field_10980;
    }

    @Override
    @NotNull
    public Iterator<PlacementTarget> iterator() {
        return this.getBoundingBox().stream().map(pos -> this.dataFactory.apply(this.context, (class_2338)pos).map(data -> new PlacementTarget(pos.method_10081((class_2382)this.translation), (BlockData)data)).orElse(null)).filter(Objects::nonNull).iterator();
    }

    @Override
    public WorldBuildView translateTo(class_2338 pos) {
        this.translation = pos;
        return this;
    }

    @Override
    public WorldBuildView copy() {
        return new WorldBuildView(this.getContext(), this.getBoundingBox(), this.dataFactory);
    }

    @Override
    public BuildContext getContext() {
        return this.context;
    }

    @Override
    public Region getBoundingBox() {
        return this.region;
    }
}

