/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.concurrent;

import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.PlacementChecker;
import com.direwolf20.buildinggadgets.common.tainted.building.PlacementTarget;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.building.view.IBuildView;
import com.direwolf20.buildinggadgets.common.tainted.concurrent.ServerTickingScheduler;
import com.direwolf20.buildinggadgets.common.tainted.concurrent.SteppedScheduler;
import com.direwolf20.buildinggadgets.common.tainted.save.Undo;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multiset;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1922;
import net.minecraft.class_2323;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;

public final class PlacementScheduler
extends SteppedScheduler {
    private final IBuildView view;
    private final Iterator<PlacementTarget> iterator;
    private final PlacementChecker checker;
    private Consumer<PlacementScheduler> finisher;
    private final Undo.Builder undoBuilder;

    public static PlacementScheduler schedulePlacement(IBuildView view, PlacementChecker checker, int steps) {
        Preconditions.checkArgument((steps > 0 ? 1 : 0) != 0);
        PlacementScheduler res = new PlacementScheduler(Objects.requireNonNull(view), Objects.requireNonNull(checker), steps);
        ServerTickingScheduler.runTicked(res);
        return res;
    }

    private PlacementScheduler(IBuildView view, PlacementChecker checker, int steps) {
        super(steps);
        this.checker = checker;
        this.view = view;
        this.iterator = view.iterator();
        this.undoBuilder = Undo.builder();
        this.finisher = p -> {};
    }

    @Override
    protected void onFinish() {
        this.finisher.accept(this);
    }

    @Override
    protected boolean advance() {
        if (this.iterator.hasNext()) {
            return this.checkTarget(this.iterator.next());
        }
        return false;
    }

    public Undo.Builder getUndoBuilder() {
        return this.undoBuilder;
    }

    public PlacementScheduler withFinisher(Consumer<PlacementScheduler> runnable) {
        this.finisher = Objects.requireNonNull(runnable);
        return this;
    }

    private boolean checkTarget(PlacementTarget target) {
        try (Transaction transaction = Transaction.openOuter();){
            PlacementChecker.CheckResult res = this.checker.checkPositionWithResult(this.view.getContext(), target, false, (TransactionContext)transaction);
            if (res.isSuccess()) {
                this.undoBuilder.record((class_1922)this.view.getContext().getWorld(), target.getPos(), target.getData(), (Multiset<ItemVariant>)res.getMatch().getChosenOption(), res.getInsertedItems());
                EffectBlock.spawnEffectBlock(this.view.getContext(), target, EffectBlock.Mode.PLACE);
                BuildContext context = this.view.getContext();
                BlockData targetBlock = target.getData();
                if (target.getData().getState().method_26204() instanceof class_2323 && targetBlock.getState().method_11654((class_2769)class_2741.field_12533) == class_2756.field_12607 && context.getWorld().method_22347(target.getPos().method_10084())) {
                    EffectBlock.spawnEffectBlock(context.getWorld(), target.getPos().method_10084(), new BlockData((class_2680)targetBlock.getState().method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609), TileSupport.dummyTileEntityData()), EffectBlock.Mode.PLACE);
                }
                transaction.commit();
            }
        }
        return true;
    }
}

