/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.inventory;

import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tainted.inventory.CreativeItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryLinker;
import com.direwolf20.buildinggadgets.common.tainted.inventory.PlayerItemIndex;
import com.direwolf20.buildinggadgets.common.util.CommonUtils;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2302;
import net.minecraft.class_2320;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;

public class InventoryHelper {
    private static final Set<class_2769<?>> UNSAFE_PROPERTIES = ImmutableSet.builder().add((Object)class_2741.field_12540).add((Object)class_2741.field_12487).add((Object)class_2741.field_12527).add((Object)class_2741.field_12489).add((Object)class_2741.field_12519).add((Object)class_2741.field_12546).build();
    private static final Set<class_2769<?>> BASE_UNSAFE_PROPERTIES = ImmutableSet.builder().add((Object)class_2302.field_10835).add((Object)class_2320.field_10929).add((Object)class_2741.field_12508).build();
    public static final CreativeItemIndex CREATIVE_INDEX = new CreativeItemIndex();

    public static IItemIndex index(class_1799 tool, class_1657 player) {
        if (player.method_7337()) {
            return CREATIVE_INDEX;
        }
        return new PlayerItemIndex(tool, player);
    }

    static Storage<ItemVariant> getHandlers(class_1799 stack, class_1657 player) {
        ArrayList<PlayerInventoryStorage> handlers = new ArrayList<PlayerInventoryStorage>();
        InventoryLinker.getLinkedInventory(player.field_6002, stack).ifPresent(handlers::add);
        handlers.add(PlayerInventoryStorage.of((class_1657)player));
        return new CombinedStorage(handlers);
    }

    public static Optional<BlockData> getSafeBlockData(class_1657 player, class_2338 pos, class_1268 hand) {
        class_1750 blockItemUseContext = new class_1750(new class_1838(player, hand, CommonUtils.fakeRayTrace(player.method_19538(), pos)));
        return InventoryHelper.getSafeBlockData(player, pos, blockItemUseContext);
    }

    public static Optional<BlockData> getSafeBlockData(class_1657 player, class_2338 pos, class_1750 useContext) {
        class_1937 world = player.field_6002;
        boolean isCopyPasteGadget = AbstractGadget.getGadget(player).method_7909() instanceof GadgetCopyPaste;
        class_2680 state = world.method_8320(pos);
        if (state.method_26204() instanceof class_2404) {
            return Optional.empty();
        }
        if (state.method_26204() instanceof class_2323 && state.method_11654((class_2769)class_2741.field_12533) == class_2756.field_12609) {
            return Optional.empty();
        }
        class_2680 placeState = state.method_26204().method_9564();
        for (class_2769 prop : placeState.method_28501()) {
            if (BASE_UNSAFE_PROPERTIES.contains(prop) || !isCopyPasteGadget && UNSAFE_PROPERTIES.contains(prop)) continue;
            placeState = InventoryHelper.applyProperty(placeState, state, prop);
        }
        return Optional.of(new BlockData(placeState, TileSupport.createTileData((class_1922)world, pos)));
    }

    private static <T extends Comparable<T>> class_2680 applyProperty(class_2680 state, class_2680 from, class_2769<T> prop) {
        return (class_2680)state.method_11657(prop, from.method_11654(prop));
    }
}

