/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.inventory;

import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class InventoryLinker {
    public static Result linkInventory(class_1937 world, class_1799 stack, class_3965 trace) {
        Storage storage = (Storage)ItemStorage.SIDED.find(world, trace.method_17777(), (Object)trace.method_17780());
        if (storage == null) {
            return Result.fail(MessageTranslation.INVALID_BOUND_TILE);
        }
        boolean removed = InventoryLinker.getLinkedInventory(world, stack).map(e -> InventoryLinker.removeIfSame(stack, trace.method_17777())).orElse(false);
        if (removed) {
            return Result.removed();
        }
        class_2487 compound = stack.method_7948();
        compound.method_10582("bound_be_dim", world.method_27983().method_29177().toString());
        compound.method_10566("bound_be_pos", (class_2520)class_2512.method_10692((class_2338)trace.method_17777()));
        compound.method_10582("bound_be_face", trace.method_17780().name());
        return Result.success();
    }

    public static Optional<Storage<ItemVariant>> getLinkedInventory(class_1937 world, InventoryLink link, @Nullable class_1799 stack) {
        if (!world.method_27983().equals(link.level())) {
            return Optional.empty();
        }
        Storage storage = (Storage)ItemStorage.SIDED.find(world, link.blockPos, (Object)link.face);
        if (storage == null) {
            if (stack != null) {
                InventoryLinker.removeDataFromStack(stack);
            }
            return Optional.empty();
        }
        return Optional.ofNullable(storage);
    }

    public static Optional<Storage<ItemVariant>> getLinkedInventory(class_1937 world, class_1799 stack) {
        InventoryLink dataFromStack = InventoryLinker.getDataFromStack(stack);
        if (dataFromStack == null) {
            return Optional.empty();
        }
        return InventoryLinker.getLinkedInventory(world, dataFromStack, stack);
    }

    private static boolean removeIfSame(class_1799 stack, class_2338 pos) {
        InventoryLink dataFromStack = InventoryLinker.getDataFromStack(stack);
        if (dataFromStack == null) {
            return false;
        }
        if (dataFromStack.blockPos().equals((Object)pos)) {
            InventoryLinker.removeDataFromStack(stack);
            return true;
        }
        return false;
    }

    public static void removeDataFromStack(class_1799 stack) {
        class_2487 compound = stack.method_7948();
        compound.method_10551("bound_be_pos");
        compound.method_10551("bound_be_dim");
        compound.method_10551("bound_be_face");
    }

    @Nullable
    public static InventoryLink getDataFromStack(class_1799 stack) {
        class_2350 face;
        class_2487 compound = stack.method_7948();
        if (!(compound.method_10545("bound_be_pos") && compound.method_10545("bound_be_dim") && compound.method_10545("bound_be_face"))) {
            return null;
        }
        class_5321 dimKey = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(compound.method_10558("bound_be_dim")));
        try {
            face = class_2350.valueOf((String)compound.method_10558("bound_be_face"));
        }
        catch (Throwable ignored) {
            return null;
        }
        return new InventoryLink((class_5321<class_1937>)dimKey, class_2512.method_10691((class_2487)compound.method_10562("bound_be_pos")), face);
    }

    public record Result(MessageTranslation i18n, boolean successful) {
        public static Result fail(MessageTranslation i18n) {
            return new Result(i18n, false);
        }

        public static Result success() {
            return new Result(MessageTranslation.BOUND_TO_TILE, true);
        }

        public static Result removed() {
            return new Result(MessageTranslation.UNBOUND_TO_TILE, true);
        }
    }

    public record InventoryLink(class_5321<class_1937> level, class_2338 blockPos, class_2350 face) {
    }
}

