/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.save;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileDataSerializer;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileEntityData;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.NBTTileEntityData;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tainted.registry.Registries;
import com.direwolf20.buildinggadgets.common.util.compression.DataCompressor;
import com.direwolf20.buildinggadgets.common.util.compression.DataDecompressor;
import com.direwolf20.buildinggadgets.common.util.helpers.NBTHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_5321;

public record Undo(class_5321<class_1937> dim, Map<class_2338, BlockInfo> dataMap, Region boundingBox) {
    public static Undo deserialize(class_2487 nbt) {
        Preconditions.checkArgument((nbt.method_10573("dim", 8) && nbt.method_10573("block_list", 9) && nbt.method_10573("data_list", 9) && nbt.method_10573("data_serializer_list", 9) ? 1 : 0) != 0);
        DataDecompressor<ITileDataSerializer> serializerReverseObjectIncrementer = new DataDecompressor<ITileDataSerializer>((class_2499)nbt.method_10580("data_serializer_list"), inbt -> {
            String s = inbt.method_10714();
            ITileDataSerializer serializer = (ITileDataSerializer)Registries.getTileDataSerializers().method_10223(new class_2960(s));
            if (serializer == null) {
                BuildingGadgets.LOG.warn("Found unknown serializer {}. Replacing with dummy!", (Object)s);
                serializer = TileSupport.dummyTileEntityData().getSerializer();
            }
            return serializer;
        }, value -> {
            BuildingGadgets.LOG.warn("Attempted to query unknown serializer {}. Replacing with dummy!", (Object)value);
            return TileSupport.dummyTileEntityData().getSerializer();
        });
        DataDecompressor<BlockData> dataReverseObjectIncrementer = new DataDecompressor<BlockData>((class_2499)nbt.method_10580("data_list"), inbt -> BlockData.deserialize((class_2487)inbt, serializerReverseObjectIncrementer, true), value -> BlockData.AIR);
        DataDecompressor<Multiset> itemSetReverseObjectIncrementer = new DataDecompressor<Multiset>((class_2499)nbt.method_10580("items_list"), inbt -> NBTHelper.deserializeMultisetEntries((class_2499)inbt, HashMultiset.create(), Undo::readEntry), value -> HashMultiset.create());
        Map<class_2338, BlockInfo> map = NBTHelper.deserializeMap((class_2499)nbt.method_10580("block_list"), new HashMap(), inbt -> class_2512.method_10691((class_2487)((class_2487)inbt)), inbt -> BlockInfo.deserialize((class_2487)inbt, dataReverseObjectIncrementer, itemSetReverseObjectIncrementer));
        class_5321 dim = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(nbt.method_10558("dim")));
        Region bounds = Region.deserializeFrom(nbt.method_10562("bounding_box"));
        return new Undo((class_5321<class_1937>)dim, map, bounds);
    }

    private static class_3545<ItemVariant, Integer> readEntry(class_2520 inbt) {
        class_2487 nbt = (class_2487)inbt;
        int count = nbt.method_10550("count");
        ItemVariant item = ItemVariant.fromNbt((class_2487)nbt.method_10562("item"));
        return new class_3545((Object)item, (Object)count);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Region getBoundingBox() {
        return this.boundingBox;
    }

    public Map<class_2338, BlockInfo> getUndoData() {
        return Collections.unmodifiableMap(this.dataMap);
    }

    public class_2487 serialize() {
        DataCompressor<BlockData> dataObjectIncrementer = new DataCompressor<BlockData>();
        DataCompressor<Multiset> itemObjectIncrementer = new DataCompressor<Multiset>();
        DataCompressor<ITileDataSerializer> serializerObjectIncrementer = new DataCompressor<ITileDataSerializer>();
        class_2487 res = new class_2487();
        class_2499 infoList = NBTHelper.serializeMap(this.dataMap, class_2512::method_10692, i -> i.serialize(dataObjectIncrementer, itemObjectIncrementer));
        class_2499 dataList = dataObjectIncrementer.write(d -> d.serialize(serializerObjectIncrementer, true));
        class_2499 itemSetList = itemObjectIncrementer.write(ms -> NBTHelper.writeIterable(ms.entrySet(), this::writeEntry));
        class_2499 dataSerializerList = serializerObjectIncrementer.write(ts -> class_2519.method_23256((String)Registries.getTileDataSerializers().method_10221(ts).toString()));
        res.method_10582("dim", this.dim.method_29177().toString());
        res.method_10566("block_list", (class_2520)infoList);
        res.method_10566("data_list", (class_2520)dataList);
        res.method_10566("data_serializer_list", (class_2520)dataSerializerList);
        res.method_10566("items_list", (class_2520)itemSetList);
        res.method_10566("bounding_box", (class_2520)this.boundingBox.serialize());
        return res;
    }

    private class_2487 writeEntry(Multiset.Entry<ItemVariant> entry) {
        class_2487 res = new class_2487();
        res.method_10566("item", (class_2520)((ItemVariant)entry.getElement()).toNbt());
        res.method_10569("count", entry.getCount());
        return res;
    }

    public static final class Builder {
        private final ImmutableMap.Builder<class_2338, BlockInfo> mapBuilder = ImmutableMap.builder();
        private Region.Builder regionBuilder = null;

        private Builder() {
        }

        public Builder record(class_1922 reader, class_2338 pos, BlockData placeData, Multiset<ItemVariant> requiredItems, Multiset<ItemVariant> producedItems) {
            class_2680 state = reader.method_8320(pos);
            class_2586 be = reader.method_8321(pos);
            ITileEntityData data = be != null ? NBTTileEntityData.ofTile(be) : TileSupport.dummyTileEntityData();
            return this.record(pos, new BlockData(state, data), placeData, requiredItems, producedItems);
        }

        private Builder record(class_2338 pos, BlockData recordedData, BlockData placedData, Multiset<ItemVariant> requiredItems, Multiset<ItemVariant> producedItems) {
            this.mapBuilder.put((Object)pos, (Object)new BlockInfo(recordedData, placedData, requiredItems, producedItems));
            if (this.regionBuilder == null) {
                this.regionBuilder = Region.enclosingBuilder();
            }
            this.regionBuilder.enclose((class_2382)pos);
            return this;
        }

        public Undo build(class_1937 dim) {
            return new Undo((class_5321<class_1937>)dim.method_27983(), (Map<class_2338, BlockInfo>)this.mapBuilder.build(), this.regionBuilder != null ? this.regionBuilder.build() : Region.singleZero());
        }
    }

    public record BlockInfo(BlockData recordedData, BlockData placedData, Multiset<ItemVariant> usedItems, Multiset<ItemVariant> producedItems) {
        private static BlockInfo deserialize(class_2487 nbt, IntFunction<BlockData> dataSupplier, IntFunction<Multiset<ItemVariant>> itemSetSupplier) {
            BlockData data = dataSupplier.apply(nbt.method_10550("recorded_data"));
            BlockData placedData = dataSupplier.apply(nbt.method_10550("placed_data"));
            Multiset<ItemVariant> usedItems = itemSetSupplier.apply(nbt.method_10550("used_items"));
            Multiset<ItemVariant> producedItems = itemSetSupplier.apply(nbt.method_10550("produced_items"));
            return new BlockInfo(data, placedData, usedItems, producedItems);
        }

        private class_2487 serialize(ToIntFunction<BlockData> dataIdSupplier, ToIntFunction<Multiset<ItemVariant>> itemIdSupplier) {
            class_2487 res = new class_2487();
            res.method_10569("recorded_data", dataIdSupplier.applyAsInt(this.recordedData));
            res.method_10569("placed_data", dataIdSupplier.applyAsInt(this.placedData));
            res.method_10569("used_items", itemIdSupplier.applyAsInt(this.usedItems));
            res.method_10569("produced_items", itemIdSupplier.applyAsInt(this.producedItems));
            return res;
        }

        public BlockData getRecordedData() {
            return this.recordedData;
        }

        public BlockData getPlacedData() {
            return this.placedData;
        }

        public Multiset<ItemVariant> getUsedItems() {
            return Multisets.unmodifiableMultiset(this.usedItems);
        }

        public Multiset<ItemVariant> getProducedItems() {
            return Multisets.unmodifiableMultiset(this.producedItems);
        }
    }
}

