/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.template;

import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileDataSerializer;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileEntityData;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.NBTTileEntityData;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.google.common.base.Preconditions;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public final class SerialisationSupport {
    private static final ITileDataSerializer DUMMY_TILE_DATA_SERIALIZER = new DummyTileDataSerializer();
    private static final ITileDataSerializer NBT_TILE_DATA_SERIALIZER = new NBTTileEntityDataSerializer();

    private SerialisationSupport() {
    }

    public static ITileDataSerializer dummyDataSerializer() {
        return DUMMY_TILE_DATA_SERIALIZER;
    }

    public static ITileDataSerializer nbtTileDataSerializer() {
        return NBT_TILE_DATA_SERIALIZER;
    }

    private static final class DummyTileDataSerializer
    implements ITileDataSerializer {
        private DummyTileDataSerializer() {
        }

        @Override
        public class_2487 serialize(ITileEntityData data, boolean persisted) {
            return new class_2487();
        }

        @Override
        public ITileEntityData deserialize(class_2487 tagCompound, boolean persisted) {
            return TileSupport.dummyTileEntityData();
        }
    }

    private static final class NBTTileEntityDataSerializer
    implements ITileDataSerializer {
        private NBTTileEntityDataSerializer() {
        }

        @Override
        public class_2487 serialize(ITileEntityData data, boolean persisted) {
            Preconditions.checkArgument((boolean)(data instanceof NBTTileEntityData));
            NBTTileEntityData nbtData = (NBTTileEntityData)data;
            class_2487 res = new class_2487();
            res.method_10566("data", (class_2520)nbtData.getNBT());
            if (nbtData.getRequiredMaterials() != null) {
                res.method_10566("materials", (class_2520)nbtData.getRequiredMaterials().serialize(persisted));
            }
            return res;
        }

        @Override
        public ITileEntityData deserialize(class_2487 tagCompound, boolean persisted) {
            class_2487 data = tagCompound.method_10562("data");
            MaterialList materialList = null;
            if (tagCompound.method_10573("materials", 10)) {
                materialList = MaterialList.deserialize(tagCompound.method_10562("materials"), persisted);
            }
            return new NBTTileEntityData(data, materialList);
        }
    }
}

