/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.template;

import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.tainted.template.Template;
import com.direwolf20.buildinggadgets.common.util.exceptions.TemplateParseException;
import com.direwolf20.buildinggadgets.common.util.tools.JsonBiDiSerializer;
import com.google.common.base.Preconditions;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.Objects;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3797;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.util.VersionNumber;

public record TemplateHeader(@Nullable String name, @Nullable String author, @Nullable MaterialList requiredItems, @NotNull Region boundingBox) {
    public static final String VERSION = "2.1.0";
    public static final String HIGHEST_MC_VERSION = class_3797.method_16672().getName();
    public static final String LOWEST_MC_VERSION = "1.14.4";
    private static final VersionNumber COMP_VERSION = VersionNumber.parse((String)"2.1.0");
    private static final VersionNumber HIGHEST_MC_COMP = VersionNumber.parse((String)HIGHEST_MC_VERSION);
    private static final VersionNumber LOWEST_MC_COMP = VersionNumber.parse((String)"1.14.4");
    private static final JsonBiDiSerializer<TemplateHeader> BI_DI_SERIALIZER = new JsonBiDiSerializer<TemplateHeader>(){

        public TemplateHeader deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject data = json.getAsJsonObject();
            String mcVersion = data.getAsJsonPrimitive("mc_version").getAsString();
            VersionNumber templateMcVersion = VersionNumber.parse((String)mcVersion);
            if (templateMcVersion.compareTo(LOWEST_MC_COMP) < 0 || templateMcVersion.compareTo(HIGHEST_MC_COMP) > 0) {
                throw new TemplateParseException.IllegalMinecraftVersionException(mcVersion);
            }
            String version = data.getAsJsonPrimitive("version").getAsString();
            if (VersionNumber.parse((String)version).compareTo(COMP_VERSION) > 0) {
                throw new TemplateParseException.UnknownTemplateVersionException(version);
            }
            Builder builder = data.has("bounding_box") ? TemplateHeader.builder((Region)context.deserialize(data.get("bounding_box"), Region.class)) : TemplateHeader.builder(Region.singleZero());
            if (data.has("name")) {
                builder.name((String)context.deserialize(data.get("name"), String.class));
            }
            if (data.has("author")) {
                builder.author((String)context.deserialize(data.get("author"), String.class));
            }
            if (data.has("material_list")) {
                builder.requiredItems((MaterialList)context.deserialize(data.get("material_list"), MaterialList.class));
            }
            return builder.build();
        }

        public JsonElement serialize(TemplateHeader src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("version", TemplateHeader.VERSION);
            object.addProperty("mc_version", HIGHEST_MC_VERSION);
            if (src.getName() != null) {
                object.addProperty("name", src.getName());
            }
            if (src.getAuthor() != null) {
                object.addProperty("author", src.getAuthor());
            }
            object.add("bounding_box", context.serialize((Object)src.getBoundingBox(), Region.class));
            if (src.getRequiredItems() != null) {
                object.add("material_list", context.serialize((Object)src.getRequiredItems(), MaterialList.class));
            }
            return object;
        }
    };

    public TemplateHeader(@Nullable String name, @Nullable String author, @Nullable MaterialList requiredItems, @NotNull Region boundingBox) {
        this.name = name;
        this.author = author;
        this.requiredItems = requiredItems;
        this.boundingBox = Objects.requireNonNull(boundingBox);
    }

    public static Builder builder(Region boundingBox) {
        return new Builder(boundingBox);
    }

    public static Builder builderOf(TemplateHeader header) {
        return TemplateHeader.builderOf(header, header.getBoundingBox());
    }

    public static Builder builderOf(TemplateHeader header, Region boundingBox) {
        return TemplateHeader.builder(boundingBox).author(header.getAuthor()).name(header.getName()).requiredItems(header.getRequiredItems());
    }

    public static Builder builderFromNBT(class_2487 nbt, boolean persisted) {
        Preconditions.checkArgument((boolean)nbt.method_10573("bounds", 10), (Object)"Cannot construct a TemplateHeader without 'bounds'!");
        Region region = Region.deserializeFrom(nbt.method_10562("bounds"));
        Builder builder = TemplateHeader.builder(region);
        if (nbt.method_10573("name", 8)) {
            builder.name(nbt.method_10558("name"));
        }
        if (nbt.method_10573("author", 8)) {
            builder.author(nbt.method_10558("author"));
        }
        if (nbt.method_10573("materials", 10)) {
            builder.requiredItems(MaterialList.deserialize(nbt.method_10562("materials"), persisted));
        }
        return builder;
    }

    public static Builder builderFromNBT(class_2487 nbt) {
        return TemplateHeader.builderFromNBT(nbt, true);
    }

    public static TemplateHeader fromNBT(class_2487 nbt) {
        return TemplateHeader.builderFromNBT(nbt).build();
    }

    public static GsonBuilder appendHeaderSpecification(GsonBuilder builder, boolean printName, boolean extended) {
        return builder.setPrettyPrinting().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).registerTypeAdapter(MaterialList.class, (Object)new MaterialList.JsonSerializer()).registerTypeAdapter(TemplateHeader.class, BI_DI_SERIALIZER);
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getAuthor() {
        return this.author;
    }

    @Nullable
    public MaterialList getRequiredItems() {
        return this.requiredItems;
    }

    public Region getBoundingBox() {
        return this.boundingBox;
    }

    public class_2487 toNBT(boolean persisted) {
        class_2487 nbt = new class_2487();
        nbt.method_10566("bounds", (class_2520)this.getBoundingBox().serialize());
        if (this.getName() != null) {
            nbt.method_10582("name", this.getName());
        }
        if (this.getAuthor() != null) {
            nbt.method_10582("author", this.getAuthor());
        }
        if (!persisted && this.getRequiredItems() != null) {
            nbt.method_10566("materials", (class_2520)this.getRequiredItems().serialize(persisted));
        }
        return nbt;
    }

    public String toJson(boolean printName, boolean extended) {
        return TemplateHeader.appendHeaderSpecification(new GsonBuilder(), printName, extended).create().toJson((Object)this);
    }

    public static final class Builder {
        @Nullable
        private String name;
        @Nullable
        private String author;
        @Nullable
        private MaterialList requiredItems;
        @NotNull
        private Region boundingBox;

        private Builder(Region boundingBox) {
            this.boundingBox = Objects.requireNonNull(boundingBox);
        }

        public Builder bounds(Region boundingBox) {
            this.boundingBox = Objects.requireNonNull(boundingBox);
            return this;
        }

        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public Builder author(@Nullable String author) {
            this.author = author;
            return this;
        }

        public Builder requiredItems(@Nullable MaterialList requiredItems) {
            this.requiredItems = requiredItems;
            return this;
        }

        public TemplateHeader build() {
            return new TemplateHeader(this.name, this.author, this.requiredItems, this.boundingBox);
        }
    }

    public static class TemplateHeaderJsonRepresentation {
        TemplateHeader header;

        public TemplateHeaderJsonRepresentation(Template template, BuildContext context) {
            this.header = template.getHeaderAndForceMaterials(context);
        }
    }
}

