/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.item;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.impl.item.group.ItemGroupExtensions;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2561;

public final class CreativeItemGroup
extends class_1761 {
    private final String identifier;
    private final class_2561 displayName;
    private final Supplier<class_1799> icon;
    private Consumer<Consumer<class_1799>> filler;
    private Comparator<class_1799> sorter;

    public static CreativeItemGroup create(String modid, String name, Supplier<class_1799> icon) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Item group name '" + name + "' must only contain characters [a-z0-9_.-]!");
        }
        ((ItemGroupExtensions)class_1761.field_7931).fabric_expandArray();
        String identifier = modid + "." + name;
        String translationKey = modid + ".item_group." + name;
        return new CreativeItemGroup(identifier, translationKey, icon);
    }

    public static CreativeItemGroup create(String modid, String name, class_1935 icon) {
        return CreativeItemGroup.create(modid, name, () -> icon.method_8389().method_7854());
    }

    public static CreativeItemGroup create(String modid, Supplier<class_1799> icon) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        ((ItemGroupExtensions)class_1761.field_7931).fabric_expandArray();
        String translationKey = modid + ".item_group";
        return new CreativeItemGroup(modid, translationKey, icon);
    }

    public static CreativeItemGroup create(String modid, class_1935 icon) {
        return CreativeItemGroup.create(modid, () -> icon.method_8389().method_7854());
    }

    public static class_1761 getBuildingBlocks() {
        return class_1761.field_7931;
    }

    public static class_1761 getDecoration() {
        return class_1761.field_7928;
    }

    public static class_1761 getRedstone() {
        return class_1761.field_7914;
    }

    public static class_1761 getTransportation() {
        return class_1761.field_7923;
    }

    public static class_1761 getMisc() {
        return class_1761.field_7932;
    }

    public static class_1761 getSearch() {
        return class_1761.field_7915;
    }

    public static class_1761 getFood() {
        return class_1761.field_7922;
    }

    public static class_1761 getTools() {
        return class_1761.field_7930;
    }

    public static class_1761 getCombat() {
        return class_1761.field_7916;
    }

    public static class_1761 getBrewing() {
        return class_1761.field_7924;
    }

    private CreativeItemGroup(String identifier, String translationKey, Supplier<class_1799> icon) {
        super(class_1761.field_7921.length - 1, identifier);
        this.identifier = identifier;
        this.displayName = TextComponents.translation(translationKey).get();
        this.icon = icon;
    }

    public CreativeItemGroup filler(Consumer<Consumer<class_1799>> filler) {
        this.filler = filler;
        return this;
    }

    public CreativeItemGroup sorter(Comparator<class_1799> sorter) {
        this.sorter = sorter;
        return this;
    }

    public CreativeItemGroup sortAlphabetically() {
        return this.sorter(Comparator.comparing(stack -> TextComponents.itemStack(stack).format()));
    }

    public class_1799 method_7750() {
        class_1799 stack = this.icon.get();
        if (stack == null || stack.method_7960()) {
            throw new RuntimeException("Item group '" + this.identifier + "'s icon stack must not be empty!");
        }
        return stack;
    }

    public class_2561 method_7737() {
        return this.displayName;
    }

    public String method_7751() {
        return this.identifier;
    }

    public void method_7738(class_2371<class_1799> items) {
        if (this.filler == null) {
            super.method_7738(items);
        } else {
            this.filler.accept(arg_0 -> items.add(arg_0));
        }
        if (this.sorter != null) {
            items.sort(this.sorter);
        }
    }
}

