/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.mixin;

import com.google.common.base.Stopwatch;
import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.extensions.CoreLibDataGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_6489;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_2403.class})
public class DataGeneratorMixin
implements CoreLibDataGenerator {
    @Shadow
    @Final
    private static Logger field_11275;
    @Unique
    private GeneratorRegistrationHandler handler;
    @Unique
    private ResourceCache resourceCache;
    @Shadow
    @Final
    private List<class_2405> field_38909;
    @Shadow
    @Final
    private boolean field_38911;
    @Shadow
    @Final
    private class_6489 field_38910;
    @Shadow
    @Final
    private List<class_2405> field_11273;
    @Shadow
    @Final
    private Path field_11274;

    @Inject(method={"run()V"}, at={@At(value="INVOKE", target="Lcom/google/common/base/Stopwatch;createStarted()Lcom/google/common/base/Stopwatch;", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void runHead(CallbackInfo ci, class_2408 hashCache) {
        if (this.handler != null && this instanceof FabricDataGenerator) {
            Path manualFolder;
            FabricDataGenerator dataGenerator = (FabricDataGenerator)this;
            String manualFolderProperty = System.getProperty("fabric-api.datagen.manual-dir");
            Path outputFolder = dataGenerator.method_10313();
            Path path = manualFolder = manualFolderProperty == null || manualFolderProperty.isBlank() ? null : Paths.get(manualFolderProperty, new String[0]);
            if (manualFolder == null) {
                CoreLib.LOGGER.warn("Property 'fabric-api.datagen.manual-dir' has not been set! Manually created files may not be recognised!");
            }
            this.resourceCache = ResourceCache.wrap(hashCache, outputFolder, manualFolder);
            ((ResourceCache.HashCacheWrapper)this.resourceCache).allowWrites(false);
            this.handler.registerProviders(dataGenerator, this.resourceCache);
            for (class_2405 provider : this.field_11273) {
                Path cachePath = hashCache.method_43353(provider);
                hashCache.field_38917.add(cachePath);
                class_2408.class_7405 providerCache = class_2408.method_43348((Path)outputFolder, (Path)cachePath);
                hashCache.field_38915.put(provider, providerCache);
                hashCache.field_38918 += providerCache.method_43356();
            }
        }
        if (this.resourceCache != null) {
            ((ResourceCache.HashCacheWrapper)this.resourceCache).readHashCache();
        }
    }

    @Inject(method={"run()V"}, at={@At(value="INVOKE", target="Lcom/google/common/base/Stopwatch;createUnstarted()Lcom/google/common/base/Stopwatch;", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void runBeforeGenerators(CallbackInfo ci, class_2408 hashCache) {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        for (class_2405 provider : this.field_38909) {
            if (!this.field_38911 && !hashCache.method_43347(provider)) {
                field_11275.debug("Generator {} already run for version {}", (Object)provider.method_10321(), (Object)this.field_38910.getName());
                return;
            }
            if (!(provider instanceof ResourceGenerator.DataProviderInstance)) continue;
            field_11275.info("Running generator: {}", (Object)provider.method_10321());
            stopwatch.start();
            ((ResourceGenerator.DataProviderInstance)provider).generate();
            stopwatch.stop();
            field_11275.info("{} finished after {} ms", (Object)provider.method_10321(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            stopwatch.reset();
        }
        if (this.resourceCache != null) {
            ((ResourceCache.HashCacheWrapper)this.resourceCache).allowWrites(true);
        }
    }

    @Inject(method={"run()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/data/HashCache;purgeStaleAndWrite()V", shift=At.Shift.BEFORE)})
    private void runTail(CallbackInfo ci) {
        if (this.resourceCache != null) {
            ((ResourceCache.HashCacheWrapper)this.resourceCache).finish();
        }
    }

    @Override
    public void setGeneratorRegistrationHandler(GeneratorRegistrationHandler handler) {
        this.handler = handler;
    }

    @Override
    public GeneratorRegistrationHandler getGeneratorRegistrationHandler() {
        return this.handler;
    }
}

