/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.network;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.ClientPacketHandler;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.core.network.ServerPacketHandler;
import com.supermartijn642.core.registry.RegistryUtil;
import io.netty.util.collection.IntObjectHashMap;
import java.util.HashMap;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class PacketChannel {
    private final String modid;
    private final String name;
    private final class_2960 channelName;
    private int index = 0;
    private final HashMap<Class<? extends BasePacket>, Integer> packet_to_index = new HashMap();
    private final IntObjectHashMap<Supplier<? extends BasePacket>> index_to_packet = new IntObjectHashMap();
    private final HashMap<Class<? extends BasePacket>, Boolean> packet_to_queued = new HashMap();

    public static PacketChannel create(String modid, String channelName) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidNamespace(channelName)) {
            throw new IllegalArgumentException("Channel name '" + channelName + "' must only contain characters [a-z0-9_.-]!");
        }
        if (modid.equals("minecraft")) {
            CoreLib.LOGGER.warn("Mod is requesting registration helper for modid '" + modid + "'!");
        } else {
            ModContainer container = FabricLoader.getInstance().getModContainer(modid).orElse(null);
            if (container == null) {
                CoreLib.LOGGER.warn("Mod is requesting registration helper for unknown modid '" + modid + "'!");
            }
        }
        return new PacketChannel(modid, channelName);
    }

    public static PacketChannel create(String modid) {
        return PacketChannel.create(modid, "main");
    }

    private PacketChannel(String modid, String name) {
        this.modid = modid;
        this.name = name;
        this.channelName = new class_2960(modid, name);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientPacketHandler.registerReceiver(this.channelName, this);
        }
        ServerPacketHandler.registerReceiver(this.channelName, this);
    }

    public <T extends BasePacket> void registerMessage(Class<T> packetClass, Supplier<T> packetSupplier, boolean shouldBeQueued) {
        if (this.packet_to_index.containsKey(packetClass)) {
            throw new IllegalArgumentException("Class '" + String.valueOf(packetClass) + "' has already been registered!");
        }
        int index = this.index++;
        this.packet_to_index.put(packetClass, index);
        this.index_to_packet.put(index, packetSupplier);
        this.packet_to_queued.put(packetClass, shouldBeQueued);
    }

    public void sendToServer(BasePacket packet) {
        this.checkRegistration(packet);
        ClientPacketHandler.sendPacket(this.channelName, this, packet);
    }

    public void sendToPlayer(class_1657 player, BasePacket packet) {
        if (!(player instanceof class_3222)) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.checkRegistration(packet);
        ServerPacketHandler.sendPacket(this.channelName, this, packet, (class_3222)player);
    }

    public void sendToAllPlayers(BasePacket packet) {
        this.checkRegistration(packet);
        PlayerLookup.all((MinecraftServer)CommonUtils.getServer()).forEach(player -> this.sendToPlayer((class_1657)player, packet));
    }

    public void sendToDimension(class_5321<class_1937> dimension, BasePacket packet) {
        this.sendToDimension(CommonUtils.getLevel(dimension), packet);
    }

    public void sendToDimension(class_1937 world, BasePacket packet) {
        if (!(world instanceof class_3218)) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.checkRegistration(packet);
        PlayerLookup.world((class_3218)((class_3218)world)).forEach(player -> this.sendToPlayer((class_1657)player, packet));
    }

    public void sendToAllTrackingEntity(class_1297 entity, BasePacket packet) {
        if (entity.field_6002.field_9236) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.checkRegistration(packet);
        PlayerLookup.tracking((class_1297)entity).forEach(player -> this.sendToPlayer((class_1657)player, packet));
    }

    public void sendToAllNear(class_5321<class_1937> world, double x, double y, double z, double radius, BasePacket packet) {
        this.sendToAllNear(CommonUtils.getLevel(world), x, y, z, radius, packet);
    }

    public void sendToAllNear(class_5321<class_1937> world, class_2338 pos, double radius, BasePacket packet) {
        this.sendToAllNear(CommonUtils.getLevel(world), pos, radius, packet);
    }

    public void sendToAllNear(class_1937 world, double x, double y, double z, double radius, BasePacket packet) {
        if (!(world instanceof class_3218)) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.checkRegistration(packet);
        PlayerLookup.around((class_3218)((class_3218)world), (class_243)new class_243(x, y, z), (double)radius).forEach(player -> this.sendToPlayer((class_1657)player, packet));
    }

    public void sendToAllNear(class_1937 world, class_2338 pos, double radius, BasePacket packet) {
        if (world.field_9236) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.sendToAllNear(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, radius, packet);
    }

    private void checkRegistration(BasePacket packet) {
        if (!this.packet_to_index.containsKey(packet.getClass())) {
            throw new IllegalArgumentException("Tried to send unregistered packet '" + String.valueOf(packet.getClass()) + "' on channel '" + this.modid + ":" + this.name + "'!");
        }
    }

    void write(BasePacket packet, class_2540 buffer) {
        int index = this.packet_to_index.get(packet.getClass());
        buffer.writeInt(index);
        packet.write(buffer);
    }

    BasePacket read(class_2540 buffer) {
        int index = buffer.readInt();
        if (!this.index_to_packet.containsKey(index)) {
            throw new RuntimeException("Received an unregistered packet with index '" + index + "' on channel '" + this.modid + ":" + this.name + "'!");
        }
        BasePacket packet = (BasePacket)((Supplier)this.index_to_packet.get(index)).get();
        packet.read(buffer);
        return packet;
    }

    void handle(BasePacket packet, PacketContext context) {
        if (packet.verify(context)) {
            if (this.packet_to_queued.get(packet.getClass()).booleanValue()) {
                context.queueTask(() -> packet.handle(context));
            } else {
                packet.handle(context);
            }
        }
    }
}

