/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.JarBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.common.block.blocks.WallLanternBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.GlobeBlockTile;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.Nullable;

public class WallLanternTexturesManager
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Map<class_2248, class_2960> SPECIAL_TEXTURES = new IdentityHashMap<class_2248, class_2960>();
    protected static final Set<class_2248> POSSIBLE_LANTERNS = new HashSet<class_2248>();
    private static boolean initialized = false;
    public static final WallLanternTexturesManager RELOAD_INSTANCE = new WallLanternTexturesManager();

    private WallLanternTexturesManager() {
        super(GSON, "textures/blocks/wall_lanterns");
    }

    protected void apply(Map<class_2960, JsonElement> pObject, class_3300 manager, class_3695 pProfiler) {
        WallLanternTexturesManager.reloadTextures(manager);
    }

    public static void reloadTextures(class_3300 manager) {
        if (!initialized) {
            WallLanternTexturesManager.initialize();
            initialized = true;
        }
        SPECIAL_TEXTURES.clear();
        for (class_2248 i : POSSIBLE_LANTERNS) {
            class_2960 reg = Utils.getID((class_2248)i);
            Object namespace = reg.method_12836().equals("minecraft") || reg.method_12836().equals("supplementaries") ? "" : reg.method_12836() + "/";
            String s = "textures/blocks/wall_lanterns/" + (String)namespace + reg.method_12832() + ".json";
            class_2960 fullPath = Supplementaries.res(s);
            Optional resource = manager.method_14486(fullPath);
            if (!resource.isPresent()) continue;
            try {
                InputStream stream = ((class_3298)resource.get()).method_14482();
                try {
                    JsonObject bsElement = RPUtils.deserializeJson((InputStream)stream);
                    String texture = RPUtils.findFirstResourceInJsonRecursive((JsonElement)bsElement);
                    if (texture.isEmpty()) continue;
                    SPECIAL_TEXTURES.put(i, new class_2960(texture));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception exception) {}
        }
        class_2960 fullPath = Supplementaries.res("textures/blocks/jar_fluid.json");
        Optional resource = manager.method_14486(fullPath);
        if (resource.isPresent()) {
            try (InputStream stream = ((class_3298)resource.get()).method_14482();){
                JsonObject bsElement = RPUtils.deserializeJson((InputStream)stream);
                float width = class_3518.method_15259((JsonObject)bsElement, (String)"width") / 16.0f;
                float height = class_3518.method_15259((JsonObject)bsElement, (String)"height") / 16.0f;
                float y0 = class_3518.method_15259((JsonObject)bsElement, (String)"y") / 16.0f;
                JarBlockTileRenderer.LIQUID_DIMENSIONS.method_4949(width, height, y0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GlobeBlockTile.GlobeType.recomputeCache();
    }

    private static void initialize() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (class_2248 i : class_2378.field_11146) {
            if (!WallLanternBlock.isValidBlock(i)) continue;
            builder.add((Object)i);
        }
        POSSIBLE_LANTERNS.clear();
        POSSIBLE_LANTERNS.addAll((Collection<class_2248>)builder.build());
    }

    @Nullable
    public static class_1058 getTextureForLantern(class_2248 block) {
        class_2960 res = SPECIAL_TEXTURES.get(block);
        if (res == null) {
            return null;
        }
        return (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(res);
    }
}

