/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.class_1011;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_757;

public class BlackBoardButton
extends class_332
implements class_4068,
class_364,
class_6379 {
    public final int u;
    public final int v;
    public final int x;
    public final int y;
    public static final int WIDTH = 6;
    protected boolean isHovered;
    protected byte color = 0;
    protected boolean focused;
    private final IDraggable onDragged;
    private final IPressable onPress;

    public BlackBoardButton(int centerX, int centerY, int u, int v, IPressable pressedAction, IDraggable dragAction) {
        this.x = centerX - (8 - u) * 6;
        this.y = centerY - -v * 6;
        this.u = u;
        this.v = v;
        this.onPress = pressedAction;
        this.onDragged = dragAction;
    }

    public void setColor(byte color) {
        this.color = color;
    }

    public byte getColor() {
        return this.color;
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.isHovered = this.method_25405(mouseX, mouseY);
        this.renderButton(matrixStack);
    }

    public void renderButton(class_4587 matrixStack) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)ModTextures.BLACKBOARD_GUI_TEXTURE);
        int offset = this.color > 0 ? 16 : 0;
        int rgb = BlackboardBlock.colorFromByte(this.color);
        float b = (float)class_1011.method_24033((int)rgb) / 255.0f;
        float g = (float)class_1011.method_24034((int)rgb) / 255.0f;
        float r = (float)class_1011.method_24035((int)rgb) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        BlackBoardButton.method_25290((class_4587)matrixStack, (int)this.x, (int)this.y, (float)((float)(this.u + offset) * 6.0f), (float)((float)this.v * 6.0f), (int)6, (int)6, (int)192, (int)96);
    }

    public void renderTooltip(class_4587 matrixStack) {
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        BlackBoardButton.method_25290((class_4587)matrixStack, (int)(this.x - 1), (int)(this.y - 1), (float)96.0f, (float)0.0f, (int)8, (int)8, (int)192, (int)96);
        this.renderButton(matrixStack);
    }

    public void onClick(double mouseX, double mouseY) {
        this.color = (byte)(this.color == 0 ? 1 : 0);
        this.onPress.onPress(this.u, this.v, this.color != 0);
    }

    public void onRelease(double mouseX, double mouseY) {
    }

    public void onDrag(double mouseX, double mouseY, boolean on) {
        this.color = (byte)(on ? 1 : 0);
        this.onPress.onPress(this.u, this.v, this.color != 0);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean flag;
        if (this.isValidClickButton(button) && (flag = this.method_25405(mouseX, mouseY))) {
            this.playDownSound(class_310.method_1551().method_1483());
            this.onClick(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.isValidClickButton(button)) {
            this.onRelease(mouseX, mouseY);
            return true;
        }
        return false;
    }

    protected boolean isValidClickButton(int button) {
        return button == 0;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isValidClickButton(button)) {
            this.onDragged.onDragged(mouseX, mouseY, this.color != 0);
            return true;
        }
        return false;
    }

    public boolean isHovered() {
        return this.isHovered || this.focused;
    }

    public boolean method_25407(boolean focus) {
        this.focused = !this.focused;
        return this.focused;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + 6) && mouseY < (double)(this.y + 6);
    }

    public void playDownSound(class_1144 handler) {
        handler.method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 pNarrationElementOutput) {
    }

    public static interface IPressable {
        public void onPress(int var1, int var2, boolean var3);
    }

    public static interface IDraggable {
        public void onDragged(double var1, double var3, boolean var5);
    }
}

