/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.TurnTableBlockTile;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1451;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class TurnTableBlock
extends class_2248
implements class_2343 {
    public static final class_2753 FACING = class_2741.field_12525;
    public static final class_2758 POWER = class_2741.field_12511;
    public static final class_2746 INVERTED = class_2741.field_12501;
    public static final class_2746 ROTATING = ModBlockProperties.ROTATING;

    public TurnTableBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11036)).method_11657((class_2769)POWER, (Comparable)Integer.valueOf(0))).method_11657((class_2769)INVERTED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)ROTATING, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, POWER, INVERTED, ROTATING});
    }

    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rot.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirrorIn) {
        return state.method_26186(mirrorIn.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_7715().method_10153());
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        if (this.updatePower(state, world, pos) && (Integer)world.method_8320(pos).method_11654((class_2769)POWER) != 0) {
            this.tryRotate(world, pos);
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 player, class_1268 handIn, class_3965 hit) {
        class_2350 myDir;
        class_2350 face = hit.method_17780();
        if (face != (myDir = (class_2350)state.method_11654((class_2769)FACING)) && face != myDir.method_10153()) {
            if (!Utils.mayBuild((class_1657)player, (class_2338)hit.method_17777())) {
                return class_1269.field_5811;
            }
            float f = (Boolean)(state = (class_2680)state.method_28493((class_2769)INVERTED)).method_11654((class_2769)INVERTED) != false ? 0.55f : 0.5f;
            worldIn.method_8396(player, pos, class_3417.field_14762, class_3419.field_15245, 0.3f, f);
            worldIn.method_8652(pos, state, 6);
            return class_1269.method_29236((boolean)worldIn.field_9236);
        }
        return class_1269.field_5811;
    }

    public boolean updatePower(class_2680 state, class_1937 world, class_2338 pos) {
        int currentPower;
        int bestNeighborSignal = world.method_8482(pos);
        if (bestNeighborSignal != (currentPower = ((Integer)state.method_11654((class_2769)POWER)).intValue())) {
            world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)POWER, (Comparable)Integer.valueOf(bestNeighborSignal))).method_11657((class_2769)ROTATING, (Comparable)Boolean.valueOf(bestNeighborSignal != 0)), 6);
            return true;
        }
        return false;
    }

    private void tryRotate(class_1937 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof TurnTableBlockTile) {
            TurnTableBlockTile te = (TurnTableBlockTile)class_25862;
            te.tryRotate();
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 neighborBlock, class_2338 fromPos, boolean moving) {
        super.method_9612(state, world, pos, neighborBlock, fromPos, moving);
        boolean powerChanged = this.updatePower(state, world, pos);
        if ((Integer)world.method_8320(pos).method_11654((class_2769)POWER) != 0 && (powerChanged || fromPos.equals((Object)pos.method_10093((class_2350)state.method_11654((class_2769)FACING))))) {
            this.tryRotate(world, pos);
        }
    }

    private static class_243 rotateY(class_243 vec, double deg) {
        if (deg == 0.0) {
            return vec;
        }
        if (vec == class_243.field_1353) {
            return vec;
        }
        double x = vec.field_1352;
        double y = vec.field_1351;
        double z = vec.field_1350;
        float angle = (float)(deg / 180.0 * Math.PI);
        double s = Math.sin(angle);
        double c = Math.cos(angle);
        return new class_243(x * c + z * s, y, z * c - x * s);
    }

    public static int getPeriod(class_2680 state) {
        return 60 - (Integer)state.method_11654((class_2769)POWER) * 4 + 4;
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 e) {
        super.method_9591(world, pos, state, e);
        if (!CommonConfigs.Redstone.TURN_TABLE_ROTATE_ENTITIES.get().booleanValue()) {
            return;
        }
        if (!e.method_24828()) {
            return;
        }
        if ((Integer)state.method_11654((class_2769)POWER) != 0 && state.method_11654((class_2769)FACING) == class_2350.field_11036) {
            float period = TurnTableBlock.getPeriod(state) + 1;
            float angleIncrement = 90.0f / period;
            float increment = (Boolean)state.method_11654((class_2769)INVERTED) != false ? angleIncrement : -1.0f * angleIncrement;
            class_243 origin = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5);
            class_243 oldPos = e.method_19538();
            class_243 oldOffset = oldPos.method_1020(origin);
            class_243 newOffset = TurnTableBlock.rotateY(oldOffset, increment);
            class_243 posDiff = origin.method_1019(newOffset).method_1020(oldPos);
            e.method_5784(class_1313.field_6306, posDiff);
            e.field_6037 = true;
            if (e instanceof class_1309) {
                TurnTableBlockTile tile;
                int catTimer;
                class_2586 class_25862;
                class_1451 cat;
                class_1309 entity = (class_1309)e;
                if (e instanceof class_3222) {
                    class_3222 player = (class_3222)e;
                    class_161 advancement = world.method_8503().method_3851().method_12896(Supplementaries.res("husbandry/turn_table"));
                    if (advancement != null && !player.method_14236().method_12882(advancement).method_740()) {
                        player.method_14236().method_12878(advancement, "unlock");
                    }
                }
                e.method_24830(false);
                float diff = e.method_5791() - increment;
                e.method_5636(diff);
                e.method_5847(diff);
                entity.field_6259 = ((class_1309)e).field_6241;
                entity.method_16826(20);
                if (e instanceof class_1451 && (cat = (class_1451)e).method_24345() && !world.field_9236 && (class_25862 = world.method_8321(pos)) instanceof TurnTableBlockTile && (catTimer = (tile = (TurnTableBlockTile)class_25862).getCatTimer()) == 0) {
                    tile.setCat();
                    world.method_43128(null, (double)pos.method_10263() + 0.5, (double)((float)pos.method_10264() + 1.0f), (double)pos.method_10260() + 0.5, ModSounds.TOM.get(), class_3419.field_15245, 0.85f, 1.0f);
                }
            }
            e.field_5982 = e.method_36454();
            e.method_36456(e.method_36454() - increment);
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pPos, class_2680 pState) {
        return new TurnTableBlockTile(pPos, pState);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 pLevel, class_2680 pState, class_2591<T> pBlockEntityType) {
        return Utils.getTicker(pBlockEntityType, ModRegistry.TURN_TABLE_TILE.get(), (class_5558)(!pLevel.field_9236 ? TurnTableBlockTile::tick : null));
    }

    public boolean method_9592(class_2680 state, class_1937 world, class_2338 pos, int eventID, int eventParam) {
        if (eventID == 0) {
            if (world.field_9236 && ClientConfigs.Blocks.TURN_TABLE_PARTICLES.get().booleanValue()) {
                class_2350 dir = (class_2350)state.method_11654((class_2769)FACING);
                class_2338 front = pos.method_10093(dir);
                world.method_8406((class_2394)ModParticles.ROTATION_TRAIL_EMITTER.get(), (double)front.method_10263() + 0.5, (double)front.method_10264() + 0.5, (double)front.method_10260() + 0.5, (double)dir.method_10146(), 0.71, (double)((Boolean)state.method_11654((class_2769)INVERTED) != false ? 1 : -1));
            }
            return true;
        }
        return super.method_9592(state, world, pos, eventID, eventParam);
    }
}

