/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.present;

import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.TrappedPresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.present.IPresentItemBehavior;
import net.mehvahdjukaar.supplementaries.common.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.common.items.BombItem;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendKnockbackPacket;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_156;
import net.minecraft.class_1671;
import net.minecraft.class_1676;
import net.minecraft.class_1686;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2530;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public class PresentBehaviorsManager {
    private static final IPresentItemBehavior SPAWN_EGG_BEHAVIOR = (source, stack) -> {
        class_1299 type = ((class_1826)stack.method_7909()).method_8015(stack.method_7969());
        try {
            class_3218 level = source.method_10207();
            class_2338 pos = source.method_10122();
            class_1297 e = PresentBehaviorsManager.spawnMob(type, level, source, stack);
            if (e != null) {
                stack.method_7934(1);
                level.method_33596(null, class_5712.field_28738, pos);
                return Optional.of(stack);
            }
        }
        catch (Exception exception) {
            Supplementaries.LOGGER.error("Error while dispensing spawn egg from trapped present at {}", (Object)source.method_10122(), (Object)exception);
        }
        return Optional.empty();
    };
    private static final IPresentItemBehavior TNT_BEHAVIOR = (source, stack) -> {
        class_1747 bi;
        class_2248 patt3996$temp;
        class_3218 level = source.method_10207();
        class_2338 blockpos = source.method_10122().method_10084();
        class_1792 patt3955$temp = stack.method_7909();
        if (patt3955$temp instanceof class_1747 && (patt3996$temp = (bi = (class_1747)patt3955$temp).method_7711()) instanceof class_2530) {
            class_2530 tnt = (class_2530)patt3996$temp;
            class_1927 dummyExplosion = new class_1927((class_1937)level, null, (double)blockpos.method_10263() + 0.5, (double)blockpos.method_10263() + 0.5, (double)blockpos.method_10263() + 0.5, 0.0f, false, class_1927.class_4179.field_18685);
            tnt.method_9586((class_1937)level, blockpos, dummyExplosion);
            List entities = level.method_18467(class_1541.class, new class_238(blockpos).method_989(0.0, 0.5, 0.0));
            for (class_1541 e : entities) {
                class_243 p = e.method_19538();
                e.method_33574(new class_243(p.field_1352, (double)((float)blockpos.method_10264() + 0.625f), p.field_1350));
            }
            level.method_33596(null, class_5712.field_28738, blockpos);
            stack.method_7934(1);
            return Optional.of(stack);
        }
        return Optional.empty();
    };
    private static final IPresentItemBehavior FIREWORK_BEHAVIOR = new IPresentItemBehavior(){

        @Override
        public Optional<class_1799> performSpecialAction(class_2342 source, class_1799 stack) {
            class_3218 level = source.method_10207();
            class_2374 p = IPresentItemBehavior.getDispensePosition(source);
            class_1671 fireworkrocketentity = new class_1671((class_1937)level, stack, p.method_10216(), p.method_10214(), p.method_10215(), true);
            fireworkrocketentity.method_7485(0.0, 1.0, 0.0, 0.5f, 1.0f);
            level.method_8649((class_1297)fireworkrocketentity);
            stack.method_7934(1);
            return Optional.of(stack);
        }

        @Override
        public void playAnimation(class_2342 pSource) {
            IPresentItemBehavior.super.playAnimation(pSource);
            pSource.method_10207().method_20290(1004, pSource.method_10122(), 0);
        }
    };
    private static final AbstractProjectileBehavior SPLASH_POTION_BEHAVIOR = new AbstractProjectileBehavior(){

        @Override
        protected class_1676 getProjectile(class_1937 worldIn, class_2374 position, class_1799 stackIn) {
            return (class_1676)class_156.method_654((Object)new class_1686(worldIn, position.method_10216(), position.method_10214(), position.method_10215()), potion -> potion.method_16940(stackIn));
        }

        @Override
        protected float getPower() {
            return 0.5f;
        }

        @Override
        protected float getUncertainty() {
            return 11.0f;
        }
    };
    private static final AbstractProjectileBehavior BOMB_BEHAVIOR = new AbstractProjectileBehavior(){

        @Override
        protected class_1676 getProjectile(class_1937 worldIn, class_2374 position, class_1799 stackIn) {
            return new BombEntity(worldIn, position.method_10216(), position.method_10214(), position.method_10215(), ((BombItem)stackIn.method_7909()).getType());
        }

        @Override
        protected float getUncertainty() {
            return 11.0f;
        }
    };

    public static void registerBehaviors() {
        for (class_1792 i : class_2378.field_11142) {
            class_1747 bi;
            if (i instanceof class_1747 && (bi = (class_1747)i).method_7711() instanceof class_2530) {
                TrappedPresentBlock.registerBehavior((class_1935)i, TNT_BEHAVIOR);
            }
            if (!(i instanceof class_1826)) continue;
            class_1826 sp = (class_1826)i;
            TrappedPresentBlock.registerBehavior((class_1935)sp, SPAWN_EGG_BEHAVIOR);
        }
        TrappedPresentBlock.registerBehavior((class_1935)class_1802.field_8639, FIREWORK_BEHAVIOR);
        TrappedPresentBlock.registerBehavior((class_1935)class_1802.field_8436, SPLASH_POTION_BEHAVIOR);
        TrappedPresentBlock.registerBehavior((class_1935)class_1802.field_8150, SPLASH_POTION_BEHAVIOR);
        TrappedPresentBlock.registerBehavior((class_1935)ModRegistry.BOMB_ITEM.get(), BOMB_BEHAVIOR);
        TrappedPresentBlock.registerBehavior((class_1935)ModRegistry.BOMB_ITEM_ON.get(), BOMB_BEHAVIOR);
        TrappedPresentBlock.registerBehavior((class_1935)ModRegistry.BOMB_BLUE_ITEM.get(), BOMB_BEHAVIOR);
        TrappedPresentBlock.registerBehavior((class_1935)ModRegistry.BOMB_BLUE_ITEM_ON.get(), BOMB_BEHAVIOR);
        TrappedPresentBlock.registerBehavior((class_1935)ModRegistry.BOMB_SPIKY_ITEM.get(), BOMB_BEHAVIOR);
        TrappedPresentBlock.registerBehavior((class_1935)ModRegistry.BOMB_SPIKY_ITEM_ON.get(), BOMB_BEHAVIOR);
    }

    @Nullable
    private static class_1297 spawnMob(class_1299<?> entityType, class_3218 serverLevel, class_2342 source, @Nullable class_1799 stack) {
        class_2338 pos = source.method_10122();
        class_2487 tag = stack == null ? null : stack.method_7969();
        class_2561 component = stack != null && stack.method_7938() ? stack.method_7964() : null;
        class_1297 entity = entityType.method_5883((class_1937)serverLevel);
        if (entity != null) {
            if (component != null && entity instanceof class_1309) {
                entity.method_5665(component);
            }
            class_1299.method_5881((class_1937)serverLevel, null, (class_1297)entity, (class_2487)tag);
            class_2374 p = IPresentItemBehavior.getDispensePosition(source);
            entity.method_5814(p.method_10216(), p.method_10214(), p.method_10215());
            entity.method_5808(p.method_10216(), p.method_10214(), p.method_10215(), class_3532.method_15393((float)(serverLevel.field_9229.method_43057() * 360.0f)), 0.0f);
            entity.method_18799(entity.method_18798().method_1031(0.0, 0.3, 0.0));
            if (entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                mob.field_6241 = mob.method_36454();
                mob.field_6283 = mob.method_36454();
                mob.method_5943((class_5425)serverLevel, serverLevel.method_8404(mob.method_24515()), class_3730.field_16470, null, tag);
                mob.method_5966();
            }
            serverLevel.method_30771(entity);
            NetworkHandler.CHANNEL.sendToAllClientPlayersInRange((class_1937)serverLevel, pos, 48.0, (Message)new ClientBoundSendKnockbackPacket(entity.method_18798(), entity.method_5628()));
        }
        return entity;
    }

    public static abstract class AbstractProjectileBehavior
    implements IPresentItemBehavior {
        @Override
        public Optional<class_1799> performSpecialAction(class_2342 source, class_1799 stack) {
            class_3218 level = source.method_10207();
            class_2374 position = IPresentItemBehavior.getDispensePosition(source);
            class_1676 projectile = this.getProjectile((class_1937)level, position, stack);
            projectile.method_7485(0.0, 1.0, 0.0, this.getPower(), this.getUncertainty());
            level.method_8649((class_1297)projectile);
            stack.method_7934(1);
            return Optional.of(stack);
        }

        protected abstract class_1676 getProjectile(class_1937 var1, class_2374 var2, class_1799 var3);

        protected float getUncertainty() {
            return 6.0f;
        }

        protected float getPower() {
            return 0.4f;
        }
    }
}

