/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.supplementaries.common.items.BambooSpikesTippedItem;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class BambooSpikesBlockTile
extends class_2586 {
    public class_1842 potion = class_1847.field_8984;
    public int charges = 0;
    public long lastTicked = 0L;
    public static final float POTION_MULTIPLIER = 0.1f;
    public static final int MAX_CHARGES = 16;

    public BambooSpikesBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.BAMBOO_SPIKES_TILE.get(), pos, state);
    }

    public int getColor() {
        if (this.hasPotion()) {
            return class_1844.method_8062((class_1842)this.potion);
        }
        return 0xFFFFFF;
    }

    public boolean hasPotion() {
        return this.potion != class_1847.field_8984 && this.charges != 0;
    }

    public boolean isOnCooldown(class_1937 world) {
        return world.method_8510() - this.lastTicked < 20L;
    }

    public boolean consumeCharge(class_1937 world) {
        if (CommonConfigs.Functional.ONLY_ALLOW_HARMFUL.get().booleanValue() && !((class_1293)this.potion.method_8049().get(0)).method_5579().method_5573()) {
            return false;
        }
        this.lastTicked = world.method_8510();
        --this.charges;
        this.method_5431();
        if (this.charges <= 0) {
            this.charges = 0;
            this.potion = class_1847.field_8984;
            return true;
        }
        return false;
    }

    public void setMissingCharges(int missing) {
        this.charges = Math.max(16 - missing, 0);
    }

    public boolean tryApplyPotion(class_1842 newPotion) {
        if ((this.charges == 0 || this.potion == class_1847.field_8984 || this.potion.equals(newPotion) && this.charges != 16) && BambooSpikesTippedItem.isPotionValid(newPotion)) {
            this.potion = newPotion;
            this.charges = 16;
            this.method_5431();
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
            return true;
        }
        return false;
    }

    public boolean interactWithEntity(class_1309 le, @NotNull class_1937 world) {
        if (this.hasPotion() && !this.isOnCooldown(world)) {
            boolean used = false;
            for (class_1293 effect : this.potion.method_8049()) {
                if (!le.method_6049(effect) || le.method_6059(effect.method_5579())) continue;
                if (effect.method_5579().method_5561()) {
                    float health = 0.5f;
                    effect.method_5579().method_5564(null, null, le, effect.method_5578(), (double)health);
                } else {
                    le.method_6092(new class_1293(effect.method_5579(), (int)((float)effect.method_5584() * 0.1f), effect.method_5578()));
                }
                used = true;
            }
            if (used) {
                this.makeParticle(world);
                return this.consumeCharge(world);
            }
        }
        return false;
    }

    public void makeParticle(class_1937 level) {
        int i = this.getColor();
        double d0 = (double)(i >> 16 & 0xFF) / 255.0;
        double d1 = (double)(i >> 8 & 0xFF) / 255.0;
        double d2 = (double)(i & 0xFF) / 255.0;
        class_2338 pos = this.method_11016();
        level.method_8406((class_2394)class_2398.field_11226, (double)pos.method_10263() + 0.5 + ((double)level.field_9229.method_43057() - 0.5) * 0.75, (double)pos.method_10264() + 0.5 + ((double)level.field_9229.method_43057() - 0.5) * 0.75, (double)pos.method_10260() + 0.5 + ((double)level.field_9229.method_43057() - 0.5) * 0.75, d0, d1, d2);
    }

    public class_1799 getSpikeItem() {
        if (this.hasPotion()) {
            class_1799 stack = BambooSpikesTippedItem.makeSpikeItem(this.potion);
            stack.method_7974(stack.method_7936() - this.charges);
            return stack;
        }
        return new class_1799((class_1935)ModRegistry.BAMBOO_SPIKES_ITEM.get());
    }

    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        compound.method_10569("Charges", this.charges);
        compound.method_10544("LastTicked", this.lastTicked);
        class_2960 resourcelocation = class_2378.field_11143.method_10221((Object)this.potion);
        compound.method_10582("Potion", resourcelocation.toString());
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.charges = compound.method_10550("Charges");
        this.lastTicked = compound.method_10537("LastTicked");
        this.potion = class_1844.method_8057((class_2487)compound);
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }
}

