/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.IOwnerProtected;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.supplementaries.client.screens.HangingSignScreen;
import net.mehvahdjukaar.supplementaries.common.block.IMapDisplay;
import net.mehvahdjukaar.supplementaries.common.block.ITextHolderProvider;
import net.mehvahdjukaar.supplementaries.common.block.TextHolder;
import net.mehvahdjukaar.supplementaries.common.block.blocks.HangingSignBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SwayingBlockTile;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class HangingSignBlockTile
extends SwayingBlockTile
implements IMapDisplay,
ITextHolderProvider,
IOwnerProtected {
    public static final int MAX_LINES = 7;
    public final WoodType woodType;
    private boolean fakeItem = false;
    private UUID owner = null;
    private TextHolder textHolder;
    private class_2371<class_1799> stacks = class_2371.method_10213((int)1, (Object)class_1799.field_8037);

    public HangingSignBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.HANGING_SIGN_TILE.get(), pos, state);
        this.textHolder = new TextHolder(7, 75);
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof HangingSignBlock) {
            HangingSignBlock block = (HangingSignBlock)class_22482;
            this.woodType = block.woodType;
        } else {
            this.woodType = WoodTypeRegistry.OAK_TYPE;
        }
    }

    public boolean hasFakeItem() {
        return this.fakeItem;
    }

    public void setFakeItem(boolean fakeItem) {
        this.fakeItem = fakeItem;
    }

    @Override
    public boolean isAlwaysFast() {
        return ClientConfigs.Blocks.FAST_SIGNS.get();
    }

    @Override
    public boolean isFlipped() {
        return this.method_11010().method_11654(HangingSignBlock.AXIS) != class_2350.class_2351.field_11051;
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    @Override
    public TextHolder getTextHolder() {
        return this.textHolder;
    }

    public void openScreen(class_1937 level, class_2338 pos, class_1657 player) {
        HangingSignScreen.open(this);
    }

    @Override
    public class_1799 getMapStack() {
        return this.getItem();
    }

    @Override
    public void method_5431() {
        if (this.field_11863 == null) {
            return;
        }
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        super.method_5431();
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.stacks = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)tag, this.stacks);
        this.textHolder.load(tag);
        this.loadOwner(tag);
        if (tag.method_10545("FakeItem")) {
            this.fakeItem = tag.method_10577("FakeItem");
        }
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_1262.method_5426((class_2487)tag, this.stacks);
        this.textHolder.save(tag);
        this.saveOwner(tag);
        if (this.fakeItem) {
            tag.method_10556("FakeItem", true);
        }
    }

    @Override
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public boolean isEmpty() {
        for (class_1799 itemstack : this.stacks) {
            if (itemstack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 removeItem() {
        return class_1262.method_5428(this.stacks, (int)0);
    }

    public void setItem(class_1799 item) {
        this.stacks = class_2371.method_10213((int)1, (Object)item);
    }

    public class_1799 getItem() {
        return (class_1799)this.stacks.get(0);
    }

    @Override
    public class_2382 getNormalRotationAxis(class_2680 state) {
        return state.method_11654(HangingSignBlock.AXIS) == class_2350.class_2351.field_11048 ? new class_2382(0, 0, -1) : new class_2382(1, 0, 0);
    }

    static {
        maxSwingAngle = 45.0f;
        minSwingAngle = 2.5f;
        maxPeriod = 25.0f;
        angleDamping = 150.0f;
        periodDamping = 100.0f;
    }
}

