/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.inventories;

import net.mehvahdjukaar.supplementaries.common.block.tiles.SackBlockTile;
import net.mehvahdjukaar.supplementaries.common.inventories.DelegatingSlot;
import net.mehvahdjukaar.supplementaries.common.inventories.IContainerProvider;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModMenuTypes;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2624;

public class SackContainerMenu
extends class_1703
implements IContainerProvider {
    public final class_1263 inventory;
    private static final int[][] TARGET_RATIOS = new int[][]{{1, 1}, {2, 2}, {3, 2}, {3, 3}, {4, 2}, {5, 2}, {6, 2}, {7, 2}, {8, 2}, {8, 2}, {9, 2}, {10, 2}, {7, 3}, {8, 3}, {9, 3}};

    @Override
    public class_1263 getContainer() {
        return this.inventory;
    }

    public SackContainerMenu(int id, class_1661 playerInventory, class_2540 packetBuffer) {
        this(id, playerInventory);
    }

    public SackContainerMenu(int id, class_1661 playerInventory) {
        this(id, playerInventory, (class_2624)ModRegistry.SACK_TILE.get().method_11032(class_2338.field_10980, ModRegistry.SACK.get().method_9564()));
    }

    public SackContainerMenu(int id, class_1661 playerInventory, class_2624 inventory) {
        super(ModMenuTypes.SACK.get(), id);
        int si;
        this.inventory = inventory;
        SackContainerMenu.method_17359((class_1263)inventory, (int)SackBlockTile.getUnlockedSlots());
        inventory.method_5435(playerInventory.field_7546);
        int size = CommonConfigs.Functional.SACK_SLOTS.get();
        int[] dims = SackContainerMenu.getRatio(size);
        if (dims[0] > 9) {
            dims[0] = 9;
            dims[1] = (int)Math.ceil((float)size / 9.0f);
        }
        int yp = 44 - 9 * dims[1];
        int dimx = 0;
        for (int h = 0; h < dims[1]; ++h) {
            int dimXPrev = dimx;
            dimx = Math.min(dims[0], size);
            int xp = 89 - dimx * 18 / 2;
            for (int j = 0; j < dimx; ++j) {
                this.method_7621(new DelegatingSlot(inventory, j + h * dimXPrev, xp + j * 18, yp + 18 * h));
            }
            size -= dims[0];
        }
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.method_7621(new class_1735((class_1263)playerInventory, sj + (si + 1) * 9, 8 + sj * 18, 84 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.method_7621(new class_1735((class_1263)playerInventory, si, 8 + si * 18, 142));
        }
    }

    public boolean method_7597(class_1657 playerIn) {
        return this.inventory.method_5443(playerIn);
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 item = slot.method_7677();
            itemStack = item.method_7972();
            int activeSlots = CommonConfigs.Functional.SACK_SLOTS.get();
            if (index < activeSlots ? !this.method_7616(item, activeSlots, this.field_7761.size(), true) : !this.method_7616(item, 0, activeSlots, false)) {
                return class_1799.field_8037;
            }
            if (item.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return itemStack;
    }

    protected boolean method_7616(class_1799 stack, int startIndex, int endIndex, boolean reverseDirection) {
        class_1799 itemStack;
        class_1735 slot;
        boolean bl = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.method_7946()) {
            while (!stack.method_7960() && (reverseDirection ? i >= startIndex : i < endIndex)) {
                slot = (class_1735)this.field_7761.get(i);
                itemStack = slot.method_7677();
                if (!itemStack.method_7960() && class_1799.method_31577((class_1799)stack, (class_1799)itemStack)) {
                    int j = itemStack.method_7947() + stack.method_7947();
                    if (j <= stack.method_7914()) {
                        stack.method_7939(0);
                        itemStack.method_7939(j);
                        slot.method_7668();
                        bl = true;
                    } else if (itemStack.method_7947() < stack.method_7914()) {
                        stack.method_7934(stack.method_7914() - itemStack.method_7947());
                        itemStack.method_7939(stack.method_7914());
                        slot.method_7668();
                        bl = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.method_7960()) {
            int n = i = reverseDirection ? endIndex - 1 : startIndex;
            while (reverseDirection ? i >= startIndex : i < endIndex) {
                slot = (class_1735)this.field_7761.get(i);
                itemStack = slot.method_7677();
                if (itemStack.method_7960() && slot.method_7680(stack)) {
                    if (stack.method_7947() > slot.method_7675()) {
                        slot.method_7673(stack.method_7971(slot.method_7675()));
                    } else {
                        slot.method_7673(stack.method_7971(stack.method_7947()));
                    }
                    slot.method_7668();
                    bl = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return bl;
    }

    public void method_7595(class_1657 playerIn) {
        super.method_7595(playerIn);
        this.inventory.method_5432(playerIn);
    }

    public static int[] getRatio(int maxSize) {
        int[] dims = new int[]{Math.min(maxSize, 23), Math.max(maxSize / 23, 1)};
        for (int[] testAgainst : TARGET_RATIOS) {
            if (testAgainst[0] * testAgainst[1] != maxSize) continue;
            dims = testAgainst;
            break;
        }
        return dims;
    }
}

