/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.mob_container;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.fake_player.FakePlayerManager;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1480;
import net.minecraft.class_1657;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5761;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BucketHelper {
    private static final BiMap<class_1792, class_1299<?>> BUCKET_TO_MOB_MAP = HashBiMap.create();

    @Nullable
    public static class_1299<?> getEntityTypeFromBucket(class_1792 bucket) {
        class_1299 type = (class_1299)BUCKET_TO_MOB_MAP.get((Object)bucket);
        if (type != null) {
            return type;
        }
        if (bucket instanceof class_1785) {
            class_1785 bucketItem = (class_1785)bucket;
            class_1299<?> en = SuppPlatformStuff.getFishType(bucketItem);
            if (en != null) {
                BucketHelper.associateMobToBucketIfAbsent(en, (class_1792)bucketItem);
                return en;
            }
        } else {
            class_2960 res;
            Optional opt;
            String mobId = null;
            String itemName = Utils.getID((class_1792)bucket).toString();
            if (itemName.contains("_bucket")) {
                mobId = itemName.replace("_bucket", "");
            } else if (itemName.contains("bucket_of_")) {
                mobId = itemName.replace("_bucket", "");
            } else if (itemName.contains("bucket_")) {
                mobId = itemName.replace("bucket_", "");
            }
            if (mobId != null && (opt = class_2378.field_11145.method_17966(res = new class_2960(mobId))).isPresent()) {
                class_1299 en = (class_1299)opt.get();
                BUCKET_TO_MOB_MAP.putIfAbsent((Object)bucket, (Object)en);
                return en;
            }
        }
        return null;
    }

    public static void tryAddingFromEntityId(String id) {
    }

    public static Collection<class_1792> getValidBuckets() {
        return BUCKET_TO_MOB_MAP.keySet();
    }

    public static boolean isFishBucket(class_1792 item) {
        return BucketHelper.getEntityTypeFromBucket(item) != null;
    }

    public static void associateMobToBucketIfAbsent(class_1299<?> entity, class_1792 item) {
        if (!BUCKET_TO_MOB_MAP.containsKey((Object)item) && !BUCKET_TO_MOB_MAP.inverse().containsKey(entity)) {
            BUCKET_TO_MOB_MAP.putIfAbsent((Object)item, entity);
        }
    }

    @NotNull
    public static class_1799 getBucketFromEntity(class_1297 entity) {
        class_1799 b;
        if (entity instanceof class_5761) {
            class_5761 bucketable = (class_5761)entity;
            return (class_1799)Preconditions.checkNotNull((Object)bucketable.method_6452(), (Object)("Bucketable modded entity " + Utils.getID((class_1299)entity.method_5864()) + " returned a null bucket!"));
        }
        if (entity instanceof class_1480) {
            return BucketHelper.tryGettingFishBucketHackery(entity, entity.field_6002);
        }
        if (CompatHandler.QUARK && !(b = QuarkCompat.getSlimeBucket(entity)).method_7960()) {
            return b;
        }
        return class_1799.field_8037;
    }

    private static class_1799 tryGettingFishBucketHackery(class_1297 entity, class_1937 level) {
        class_1799 bucket = class_1799.field_8037;
        class_1657 player = FakePlayerManager.getDefault((class_1937)level);
        if (player != null) {
            class_1799 filledBucket;
            player.method_6122(class_1268.field_5808, new class_1799((class_1935)class_1802.field_8705));
            class_1269 result = entity.method_5688(player, class_1268.field_5808);
            if (!result.method_23665()) {
                player.method_6122(class_1268.field_5808, new class_1799((class_1935)class_1802.field_8550));
                result = entity.method_5688(player, class_1268.field_5808);
            }
            if (result.method_23665() && !(filledBucket = player.method_5998(class_1268.field_5808)).method_7960() && !entity.method_5805()) {
                bucket = filledBucket;
            }
        }
        return bucket;
    }

    public static boolean isModdedFish(class_1297 entity) {
        return entity instanceof class_5761;
    }
}

