/*
 * Decompiled with CFR 0.152.
 */
package io.github.alkyaly.timeinabottle.item;

import io.github.alkyaly.timeinabottle.TimeInABottle;
import io.github.alkyaly.timeinabottle.entity.AcceleratorEntity;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.item.v1.FabricItem;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.apache.commons.lang3.ArrayUtils;

public class TimeInABottleItem
extends class_1792
implements FabricItem {
    private static final String DATA_KEY = "timeData";
    private static final String STORED_KEY = "storedTime";

    public TimeInABottleItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1269 method_7884(class_1838 ctx) {
        class_1937 world = ctx.method_8045();
        if (world.field_9236) {
            return class_1269.field_5811;
        }
        class_1657 player = ctx.method_8036();
        class_2338 pos = ctx.method_8037();
        class_2487 nbt = ctx.method_8041().method_7941(DATA_KEY);
        class_238 box = new class_238(pos.method_10080(0.5, 0.5, 0.5)).method_1002(0.2, 0.2, 0.2);
        List accelerators = world.method_8390(AcceleratorEntity.class, box, e -> true);
        if (accelerators.isEmpty()) {
            int timeAvailable = nbt.method_10550(STORED_KEY);
            if (timeAvailable >= 20 * TimeInABottle.config.getDuration()) {
                if (!player.method_31549().field_7477) {
                    nbt.method_10569(STORED_KEY, timeAvailable - 20 * TimeInABottle.config.getDuration());
                }
                AcceleratorEntity accelerator = new AcceleratorEntity(world, pos);
                accelerator.setTimeRate(1);
                accelerator.setRemainingTime(20 * TimeInABottle.config.getDuration());
                accelerator.method_5857(box);
                world.method_8649((class_1297)accelerator);
                TimeInABottleItem.playSound(world, pos, accelerator.getTimeRate());
                return class_1269.field_5812;
            }
        } else {
            AcceleratorEntity accelerator = (AcceleratorEntity)((Object)accelerators.get(0));
            int curRate = accelerator.getTimeRate();
            int usedUp = 20 * TimeInABottle.config.getDuration() - accelerator.getRemainingTime();
            int[] speedLevels = TimeInABottle.config.getSpeedLevels();
            if (curRate < speedLevels[speedLevels.length - 1]) {
                int curIndex = ArrayUtils.indexOf((int[])speedLevels, (int)curRate);
                int next = speedLevels[curIndex + 1];
                int timeRequired = next / 2 * 20 * TimeInABottle.config.getDuration();
                int timeAvailable = nbt.method_10550(STORED_KEY);
                if (timeAvailable >= timeRequired) {
                    int added = (next * usedUp - curRate * usedUp) / next;
                    if (!player.method_31549().field_7477) {
                        nbt.method_10569(STORED_KEY, timeAvailable - timeRequired);
                    }
                    accelerator.setTimeRate(next);
                    accelerator.setRemainingTime(accelerator.getRemainingTime() + added);
                    TimeInABottleItem.playSound(world, pos, next);
                    return class_1269.field_5812;
                }
            }
        }
        return super.method_7884(ctx);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_2487 timeData;
        super.method_7888(stack, world, entity, slot, selected);
        if (world.field_9236) {
            return;
        }
        int time = TimeInABottle.config.getTimeSecond();
        if (world.method_8510() % 20L == 0L && (long)(timeData = stack.method_7911(DATA_KEY)).method_10550(STORED_KEY) < TimeInABottle.config.getMaxTime()) {
            timeData.method_10569(STORED_KEY, timeData.method_10550(STORED_KEY) + time);
        }
        if (world.method_8510() % 60L == 0L && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                class_1799 other = player.method_31548().method_5438(i);
                if (!other.method_31574(stack.method_7909()) || other == stack) continue;
                class_2487 duplicate = other.method_7911(DATA_KEY);
                class_2487 original = stack.method_7911(DATA_KEY);
                int duplicateTime = duplicate.method_10550(STORED_KEY);
                int originalTime = original.method_10550(STORED_KEY);
                if (originalTime >= duplicateTime) continue;
                original.method_10569(STORED_KEY, 0);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        int storedTime = stack.method_7911(DATA_KEY).method_10550(STORED_KEY);
        int storedSeconds = storedTime / 20;
        int hours = storedSeconds / 3600;
        int minutes = storedSeconds % 3600 / 60;
        int seconds = storedSeconds % 60;
        tooltip.add((class_2561)class_2561.method_43469((String)"item.timeinabottle.time_in_a_bottle.tooltip", (Object[])new Object[]{hours, minutes, seconds}).method_27692(class_124.field_1075));
    }

    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }

    protected static void playSound(class_1937 world, class_2338 pos, int nextRate) {
        switch (nextRate) {
            case 1: {
                world.method_8396(null, pos, class_3417.field_15114, class_3419.field_15245, 0.5f, 0.749154f);
                break;
            }
            case 2: {
                world.method_8396(null, pos, class_3417.field_15114, class_3419.field_15245, 0.5f, 0.793701f);
                break;
            }
            case 4: 
            case 32: {
                world.method_8396(null, pos, class_3417.field_15114, class_3419.field_15245, 0.5f, 0.890899f);
                break;
            }
            case 8: {
                world.method_8396(null, pos, class_3417.field_15114, class_3419.field_15245, 0.5f, 1.059463f);
                break;
            }
            case 16: {
                world.method_8396(null, pos, class_3417.field_15114, class_3419.field_15245, 0.5f, 0.943874f);
                break;
            }
            default: {
                world.method_8396(null, pos, class_3417.field_15114, class_3419.field_15245, 0.5f, 1.0f);
            }
        }
    }
}

