/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.storagemod.gui.GuiButton;
import com.tom.storagemod.gui.InventoryLinkMenu;
import com.tom.storagemod.gui.PlatformButton;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.util.IDataReceiver;
import com.tom.storagemod.util.RemoteConnections;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_757;
import org.lwjgl.glfw.GLFW;

public class InventoryLinkScreen
extends class_465<InventoryLinkMenu>
implements IDataReceiver {
    protected static final class_2960 creativeInventoryTabs = new class_2960("textures/gui/container/creative_inventory/tabs.png");
    private static final class_2960 gui = new class_2960("toms_storage", "textures/gui/inventory_link.png");
    private static final int LINES = 7;
    private class_342 textF;
    private Map<UUID, RemoteConnections.Channel> connections = new HashMap<UUID, RemoteConnections.Channel>();
    private UUID selected;
    private int beaconLvl;
    private GuiButton createBtn;
    private GuiButton deleteBtn;
    private GuiButton publicBtn;
    private GuiButton remoteBtn;
    private List<ListEntry> listEntries = new ArrayList<ListEntry>();
    private List<UUID> sortedList = new ArrayList<UUID>();
    protected float currentScroll;
    protected boolean isScrolling;
    protected boolean wasClicking;

    public InventoryLinkScreen(InventoryLinkMenu p_97741_, class_1661 p_97742_, class_2561 p_97743_) {
        super((class_1703)p_97741_, p_97742_, p_97743_);
    }

    @Override
    public void receive(class_2487 tag) {
        class_2499 list = tag.method_10554("list", 10);
        RemoteConnections.load(list, this.connections);
        if (tag.method_10545("selected")) {
            this.selected = tag.method_25926("selected");
            RemoteConnections.Channel ch = this.connections.get(this.selected);
            this.textF.method_1852(ch.displayName);
        } else {
            this.selected = null;
        }
        this.remoteBtn.state = tag.method_10577("remote") ? 1 : 0;
        this.beaconLvl = tag.method_10550("lvl");
        Comparator<Map.Entry> cmp = Comparator.comparing(e -> ((RemoteConnections.Channel)e.getValue()).publicChannel);
        cmp = cmp.thenComparing(e -> ((RemoteConnections.Channel)e.getValue()).displayName);
        this.sortedList = this.connections.entrySet().stream().sorted(cmp).map(Map.Entry::getKey).collect(Collectors.toList());
        this.update();
    }

    protected void method_2389(class_4587 matrixStack, float partialTicks, int x, int y) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)gui);
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        this.method_25302(matrixStack, i, j, 0, 0, this.field_2792, this.field_2779);
    }

    protected void method_2388(class_4587 p_97808_, int p_97809_, int p_97810_) {
        this.field_22793.method_30883(p_97808_, this.field_22785, (float)this.field_25267, (float)this.field_25268, 0x404040);
        this.field_22793.method_1729(p_97808_, class_1074.method_4662((String)"ts.inventory_connector.beacon_level", (Object[])new Object[]{this.beaconLvl}), (float)this.field_25267, (float)(this.field_25268 + 10), 0x404040);
    }

    protected void method_25426() {
        this.method_37067();
        super.method_25426();
        this.createBtn = this.makeCompositeButton(this.field_2776 + 121, this.field_2800 + 24, 0, b -> {
            RemoteConnections.Channel chn = new RemoteConnections.Channel(null, this.publicBtn.state == 1, this.textF.method_1882());
            this.sendEdit(null, chn);
        });
        this.deleteBtn = this.makeCompositeButton(this.field_2776 + 138, this.field_2800 + 24, 1, b -> this.sendEdit(this.selected, null));
        this.publicBtn = this.makeCompositeButton(this.field_2776 + 155, this.field_2800 + 24, 2, b -> {
            if (this.selected != null && this.connections.containsKey(this.selected)) {
                RemoteConnections.Channel ch = this.connections.get(this.selected);
                if (ch.owner.equals(this.field_22787.field_1724.method_5667())) {
                    ch.publicChannel = !ch.publicChannel;
                    this.publicBtn.state = ch.publicChannel ? 1 : 0;
                    this.sendEdit(this.selected, ch);
                }
            } else {
                this.publicBtn.state = this.publicBtn.state == 0 ? 1 : 0;
            }
        });
        this.remoteBtn = this.makeCompositeButton(this.field_2776 + 155, this.field_2800 + 7, 0, b -> {
            class_2487 tag = new class_2487();
            tag.method_10556("remote", this.remoteBtn.state == 0);
            NetworkHandler.sendDataToServer(tag);
        });
        this.remoteBtn.texY = 32;
        Objects.requireNonNull(this.field_22793);
        this.textF = new class_342(this.field_22793, this.field_2776 + 13, this.field_2800 + 28, 105, 9, (class_2561)class_2561.method_43471((String)"narrator.toms_storage.inventory_link_channel"));
        this.textF.method_1880(50);
        this.textF.method_1858(false);
        this.textF.method_1862(true);
        this.textF.method_1868(0xFFFFFF);
        this.textF.method_1852("");
        this.textF.method_1863(t -> {
            this.selected = null;
            for (Map.Entry<UUID, RemoteConnections.Channel> e : this.connections.entrySet()) {
                if (!e.getValue().displayName.equals(t)) continue;
                this.selected = e.getKey();
                break;
            }
            this.update();
        });
        this.method_37063((class_364)this.textF);
        for (int i = 0; i < 7; ++i) {
            this.listEntries.add(new ListEntry(this.field_2776 + 12, this.field_2800 + 42 + i * 16, i));
        }
        this.update();
    }

    public GuiButton.CompositeButton makeCompositeButton(int x, int y, int tile, class_4185.class_4241 pressable) {
        GuiButton.CompositeButton btn = new GuiButton.CompositeButton(x, y, tile, pressable);
        btn.texX = 176;
        btn.texY = 0;
        btn.texture = gui;
        this.method_37063((class_364)btn);
        return btn;
    }

    private void sendEdit(UUID id, RemoteConnections.Channel ch) {
        class_2487 tag = new class_2487();
        if (id != null) {
            tag.method_25927("id", id);
        }
        if (ch != null) {
            ch.saveNet(tag);
        }
        NetworkHandler.sendDataToServer(tag);
    }

    private void sendSelect(UUID id) {
        class_2487 tag = new class_2487();
        tag.method_25927("id", id);
        tag.method_10556("select", true);
        NetworkHandler.sendDataToServer(tag);
    }

    private void update() {
        if (this.selected != null && this.connections.containsKey(this.selected)) {
            boolean owner;
            this.deleteBtn.field_22763 = true;
            RemoteConnections.Channel ch = this.connections.get(this.selected);
            this.publicBtn.state = ch.publicChannel ? 1 : 0;
            this.publicBtn.field_22763 = owner = ch.owner.equals(this.field_22787.field_1724.method_5667());
            this.createBtn.field_22763 = false;
        } else {
            this.deleteBtn.field_22763 = false;
            this.publicBtn.state = 0;
            this.createBtn.field_22763 = true;
        }
    }

    private boolean needsScrollBars() {
        return this.sortedList.size() > 7;
    }

    public void method_25394(class_4587 st, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(st);
        boolean flag = GLFW.glfwGetMouseButton((long)class_310.method_1551().method_22683().method_4490(), (int)0) != 0;
        int i = this.field_2776;
        int j = this.field_2800;
        int k = i + 122;
        int l = j + 42;
        int i1 = k + 14;
        int j1 = l + this.sortedList.size() * 16;
        if (!this.wasClicking && flag && mouseX >= k && mouseY >= l && mouseX < i1 && mouseY < j1) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - l) - 7.5f) / ((float)(j1 - l) - 15.0f);
            this.currentScroll = class_3532.method_15363((float)this.currentScroll, (float)0.0f, (float)1.0f);
        }
        super.method_25394(st, mouseX, mouseY, partialTicks);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)creativeInventoryTabs);
        i = k;
        j = l;
        k = j1;
        this.method_25302(st, i, j + (int)((float)(k - j - 17) * this.currentScroll), 232 + (this.needsScrollBars() ? 0 : 12), 0, 12, 15);
        this.method_2380(st, mouseX, mouseY);
        if (this.publicBtn.method_25367()) {
            this.method_25424(st, (class_2561)class_2561.method_43471((String)("tooltip.toms_storage.link_public_" + this.publicBtn.state)), mouseX, mouseY);
        }
        if (this.remoteBtn.method_25367()) {
            this.method_25424(st, (class_2561)class_2561.method_43471((String)("tooltip.toms_storage.link_remote_" + this.remoteBtn.state)), mouseX, mouseY);
        }
    }

    public boolean method_25404(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            this.method_25419();
            return true;
        }
        return !this.textF.method_25404(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) && !this.textF.method_20315() ? super.method_25404(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) : true;
    }

    public boolean method_25400(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.textF.method_25400(p_charTyped_1_, p_charTyped_2_)) {
            return true;
        }
        return super.method_25400(p_charTyped_1_, p_charTyped_2_);
    }

    public boolean method_25401(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        if (!this.needsScrollBars()) {
            return false;
        }
        int i = this.sortedList.size() - 7;
        this.currentScroll = (float)((double)this.currentScroll - p_mouseScrolled_5_ / (double)i);
        this.currentScroll = class_3532.method_15363((float)this.currentScroll, (float)0.0f, (float)1.0f);
        return true;
    }

    public class ListEntry
    extends PlatformButton {
        private int id;

        public ListEntry(int x, int y, int id) {
            super(x, y, 106, 16, null, null);
            this.id = id;
            InventoryLinkScreen.this.method_37063((class_364)this);
        }

        public void method_25359(class_4587 st, int mouseX, int mouseY, float pt) {
            UUID id;
            if (this.field_22764 && (id = this.getId()) != null) {
                int x = this.getX();
                int y = this.getY();
                RemoteConnections.Channel chn = InventoryLinkScreen.this.connections.get(id);
                RenderSystem.setShader(class_757::method_34542);
                RenderSystem.setShaderTexture((int)0, (class_2960)gui);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
                this.field_22762 = mouseX >= x && mouseY >= y && mouseX < x + this.field_22758 && mouseY < y + this.field_22759;
                int i = this.method_25356(this.method_25367());
                this.method_25302(st, x, y, id.equals(InventoryLinkScreen.this.selected) ? 106 : 0, 166 + i * 16, this.field_22758, this.field_22759);
                this.method_25302(st, x + this.field_22758 - 16, y, 208 + (chn.publicChannel ? 16 : 0), 0, 16, 16);
                int j = -1;
                ListEntry.method_25300((class_4587)st, (class_327)InventoryLinkScreen.this.field_22793, (String)chn.displayName, (int)(x + this.field_22758 / 2), (int)(y + (this.field_22759 - 8) / 2), (int)(j | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24));
            }
        }

        public void method_25306() {
            UUID id = this.getId();
            if (id != null) {
                InventoryLinkScreen.this.sendSelect(id);
            }
        }

        private UUID getId() {
            int i = InventoryLinkScreen.this.sortedList.size() - 7;
            int j = (int)((double)(InventoryLinkScreen.this.currentScroll * (float)i) + 0.5);
            if (j < 0) {
                j = 0;
            }
            if (this.id + j < InventoryLinkScreen.this.sortedList.size()) {
                return InventoryLinkScreen.this.sortedList.get(this.id + j);
            }
            return null;
        }
    }
}

