/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.storagemod.gui.AbstractFilteredScreen;
import com.tom.storagemod.gui.GuiButton;
import com.tom.storagemod.gui.PlatformButton;
import com.tom.storagemod.gui.TagItemFilterMenu;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.util.IDataReceiver;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.lwjgl.glfw.GLFW;

public class TagItemFilterScreen
extends AbstractFilteredScreen<TagItemFilterMenu>
implements IDataReceiver {
    private static final class_2960 GUI_TEXTURES = new class_2960("toms_storage", "textures/gui/tag_filter.png");
    private static final int LINES = 4;
    private GuiButton buttonAllowList;
    private GuiButton buttonAdd;
    private GuiButton buttonRemove;
    private List<String> itemTags = new ArrayList<String>();
    private List<String> filterTags = new ArrayList<String>();
    private ListHandler itemTagList;
    private ListHandler filterList;

    public TagItemFilterScreen(TagItemFilterMenu container, class_1661 playerInventory, class_2561 textComponent) {
        super(container, playerInventory, textComponent);
    }

    protected void method_25426() {
        super.method_25426();
        this.buttonAllowList = (GuiButton)this.method_37063((class_364)new GuiButton(this.field_2776 - 18, this.field_2800 + 5, 0, b -> this.click(0, this.buttonAllowList.state != 1)));
        this.itemTagList = new ListHandler(this.field_2776 + 28, this.field_2800 + 15);
        this.itemTagList.list = () -> this.itemTags;
        this.filterList = new ListHandler(this.field_2776 + 109, this.field_2800 + 15);
        this.filterList.list = () -> this.filterTags;
        this.buttonAdd = (GuiButton)this.method_37063((class_364)this.makeCompositeButton(this.field_2776 + 90, this.field_2800 + 14, 0, b -> {
            if (this.itemTagList.selected != null) {
                if (!this.filterTags.contains(this.itemTagList.selected)) {
                    this.filterTags.add(this.itemTagList.selected);
                }
                this.itemTagList.selected = null;
                this.sync();
            }
        }));
        this.buttonRemove = (GuiButton)this.method_37063((class_364)this.makeCompositeButton(this.field_2776 + 90, this.field_2800 + 32, 1, b -> {
            if (this.filterList.selected != null) {
                this.filterTags.remove(this.filterList.selected);
                this.filterList.selected = null;
                this.sync();
            }
        }));
    }

    private void sync() {
        class_2499 list = new class_2499();
        this.filterTags.forEach(t -> list.add((Object)class_2519.method_23256((String)t)));
        class_2487 tag = new class_2487();
        tag.method_10566("l", (class_2520)list);
        NetworkHandler.sendDataToServer(tag);
    }

    protected void method_37432() {
        class_1799 s = ((class_1735)((TagItemFilterMenu)this.field_2797).field_7761.get(0)).method_7677();
        List<String> tags = s.method_40133().map(t -> t.comp_327().toString()).toList();
        if (!this.itemTags.equals(tags)) {
            this.itemTags.clear();
            this.itemTags.addAll(tags);
            this.itemTagList.selected = null;
            this.itemTagList.currentScroll = 0.0f;
        }
    }

    private void click(int id, boolean val) {
        this.field_22787.field_1761.method_2900(((TagItemFilterMenu)this.field_2797).field_7763, id << 1 | (val ? 1 : 0));
    }

    public GuiButton.CompositeButton makeCompositeButton(int x, int y, int tile, class_4185.class_4241 pressable) {
        GuiButton.CompositeButton btn = new GuiButton.CompositeButton(x, y, tile, pressable);
        btn.texX = 176;
        btn.texY = 0;
        btn.texture = GUI_TEXTURES;
        return btn;
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(matrixStack);
        this.buttonAllowList.state = ((TagItemFilterMenu)this.field_2797).allowList ? 1 : 0;
        this.itemTagList.preRender(mouseX, mouseY);
        this.filterList.preRender(mouseX, mouseY);
        this.buttonAdd.field_22763 = this.itemTagList.selected != null;
        this.buttonRemove.field_22763 = this.filterList.selected != null;
        super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        this.itemTagList.render(matrixStack);
        this.filterList.render(matrixStack);
        this.method_2380(matrixStack, mouseX, mouseY);
        if (this.buttonAllowList.method_25367()) {
            this.method_25424(matrixStack, (class_2561)class_2561.method_43471((String)("tooltip.toms_storage.allowList_" + this.buttonAllowList.state)), mouseX, mouseY);
        }
        this.itemTagList.tooltip(matrixStack, mouseX, mouseY);
        this.filterList.tooltip(matrixStack, mouseX, mouseY);
    }

    protected void method_2389(class_4587 matrixStack, float partialTicks, int x, int y) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)GUI_TEXTURES);
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        this.method_25302(matrixStack, i, j, 0, 0, this.field_2792, this.field_2779);
    }

    @Override
    public void receive(class_2487 tag) {
        class_2499 list = tag.method_10554("l", 8);
        this.filterTags.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.filterTags.add(list.method_10608(i));
        }
        this.filterList.selected = null;
        this.filterList.currentScroll = 0.0f;
    }

    public boolean method_25401(double x, double y, double dir) {
        if (this.method_2378(27, 14, 61, 58, x, y) && this.itemTagList.mouseScrolled(dir)) {
            return true;
        }
        if (this.method_2378(108, 14, 61, 58, x, y) && this.filterList.mouseScrolled(dir)) {
            return true;
        }
        return super.method_25401(x, y, dir);
    }

    public class ListHandler {
        protected float currentScroll;
        protected boolean isScrolling;
        protected boolean wasClicking;
        protected Supplier<List<String>> list;
        protected String selected;
        private List<ListEntry> listEntries = new ArrayList<ListEntry>();
        private int x;
        private int y;

        public ListHandler(int x, int y) {
            for (int i = 0; i < 4; ++i) {
                this.listEntries.add(new ListEntry(x, y + i * 14, i));
            }
            this.x = x;
            this.y = y;
        }

        public void tooltip(class_4587 matrixStack, int mouseX, int mouseY) {
            this.listEntries.stream().filter(s -> s.method_25367()).findFirst().ifPresent(le -> {
                String id = le.getId();
                if (id != null) {
                    TagItemFilterScreen.this.method_25424(matrixStack, (class_2561)class_2561.method_43470((String)id), mouseX, mouseY);
                }
            });
        }

        public boolean needsScrollBars() {
            return this.list.get().size() > 4;
        }

        public void preRender(int mouseX, int mouseY) {
            boolean flag = GLFW.glfwGetMouseButton((long)class_310.method_1551().method_22683().method_4490(), (int)0) != 0;
            int k = this.x + 56;
            int l = this.y - 1;
            int i1 = k + 14;
            int j1 = l + 58;
            if (!this.wasClicking && flag && mouseX >= k && mouseY >= l && mouseX < i1 && mouseY < j1) {
                this.isScrolling = this.needsScrollBars();
            }
            if (!flag) {
                this.isScrolling = false;
            }
            this.wasClicking = flag;
            if (this.isScrolling) {
                this.currentScroll = ((float)(mouseY - l) - 4.5f) / ((float)(j1 - l) - 9.0f);
                this.currentScroll = class_3532.method_15363((float)this.currentScroll, (float)0.0f, (float)1.0f);
            }
        }

        public void render(class_4587 st) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)GUI_TEXTURES);
            int i = this.x + 55;
            int k = this.y + this.list.get().size() * 14;
            TagItemFilterScreen.this.method_25302(st, i, this.y - 1 + (int)(49.0f * this.currentScroll), 176 + (this.needsScrollBars() ? 5 : 0), 32, 5, 9);
        }

        public boolean mouseScrolled(double dir) {
            if (!this.needsScrollBars()) {
                return false;
            }
            int i = this.list.get().size() - 4;
            this.currentScroll = (float)((double)this.currentScroll - dir / (double)i);
            this.currentScroll = class_3532.method_15363((float)this.currentScroll, (float)0.0f, (float)1.0f);
            return true;
        }

        public class ListEntry
        extends PlatformButton {
            private int id;

            public ListEntry(int x, int y, int id) {
                super(x, y, 53, 14, null, null);
                this.id = id;
                TagItemFilterScreen.this.method_37063((class_364)this);
            }

            public void method_25359(class_4587 st, int mouseX, int mouseY, float pt) {
                String id;
                if (this.field_22764 && (id = this.getId()) != null) {
                    int x = this.getX();
                    int y = this.getY();
                    RenderSystem.setShader(class_757::method_34542);
                    RenderSystem.setShaderTexture((int)0, (class_2960)GUI_TEXTURES);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
                    this.field_22762 = mouseX >= x && mouseY >= y && mouseX < x + this.field_22758 && mouseY < y + this.field_22759;
                    int i = this.method_25356(this.method_25367()) - 1;
                    this.method_25302(st, x, y, 176, 41 + i * 14 + (id.equals(ListHandler.this.selected) ? 28 : 0), this.field_22758, this.field_22759);
                    int j = -1;
                    st.method_22903();
                    st.method_22904((double)(x + this.field_22758 / 2), (double)(y + (this.field_22759 - 8) / 2), 0.0);
                    float s = 0.75f;
                    int l = (int)((float)TagItemFilterScreen.this.field_22793.method_1727(id) * s);
                    st.method_22905(s, s, s);
                    int m = this.field_22758 - 4;
                    if (l > m) {
                        double d = (double)class_156.method_658() / 1000.0;
                        double e = Math.sin(1.5707963267948966 * Math.cos(d));
                        int n = l - m;
                        ListEntry.method_44379((int)(x + 2), (int)(y + 2), (int)(x + this.field_22758 - 2), (int)(y + this.field_22759 - 2));
                        float tx = (float)(-(l / 2)) / s - (float)(e * (double)n * (double)s);
                        TagItemFilterScreen.this.field_22793.method_1720(st, id, tx, 2.0f, j | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
                        ListEntry.method_44380();
                    } else {
                        ListEntry.method_25300((class_4587)st, (class_327)TagItemFilterScreen.this.field_22793, (String)id, (int)0, (int)2, (int)(j | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24));
                    }
                    st.method_22909();
                }
            }

            public void method_25306() {
                String id = this.getId();
                if (id != null) {
                    ListHandler.this.selected = id;
                }
            }

            private String getId() {
                List<String> l = ListHandler.this.list.get();
                int i = l.size() - 4;
                int j = (int)((double)(ListHandler.this.currentScroll * (float)i) + 0.5);
                if (j < 0) {
                    j = 0;
                }
                if (this.id + j < l.size()) {
                    return l.get(this.id + j);
                }
                return null;
            }
        }
    }
}

