/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.util;

import com.google.common.collect.Iterators;
import com.tom.storagemod.platform.PlatformStorage;
import com.tom.storagemod.util.IProxy;
import com.tom.storagemod.util.ItemPredicate;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.BlankVariantView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.FilteringStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.jetbrains.annotations.Nullable;

public class FilteredStorage
extends FilteringStorage<ItemVariant>
implements IProxy,
PlatformStorage {
    private BlankVariantView<ItemVariant> nullSlot = new BlankVariantView((TransferVariant)ItemVariant.blank(), 0L);
    private ItemPredicate filter;
    private boolean keepLastInSlot;

    public FilteredStorage(Storage<ItemVariant> backingStorage, ItemPredicate filter, boolean keepLastInSlot) {
        super(backingStorage);
        this.filter = filter;
        this.keepLastInSlot = keepLastInSlot;
    }

    private boolean inFilter(ItemVariant resource) {
        return this.filter.test(resource);
    }

    protected boolean canInsert(ItemVariant resource) {
        return this.inFilter(resource);
    }

    protected boolean canExtract(ItemVariant resource) {
        return this.inFilter(resource);
    }

    public Iterator<StorageView<ItemVariant>> iterator() {
        return Iterators.transform((Iterator)super.iterator(), sv -> {
            if (!this.inFilter((ItemVariant)sv.getResource())) {
                return this.nullSlot;
            }
            return this.keepLastInSlot ? new FilteringStorageView((StorageView<ItemVariant>)sv) : sv;
        });
    }

    @Override
    public Storage<ItemVariant> get() {
        return (Storage)this.backingStorage.get();
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (!this.canExtract(resource)) {
            return 0L;
        }
        if (this.keepLastInSlot) {
            long maxEx;
            StorageView sv;
            Iterator itr = super.iterator();
            long amount = 0L;
            while (itr.hasNext() && ((sv = (StorageView)itr.next()).isResourceBlank() || !((ItemVariant)sv.getResource()).equals(resource) || (amount += sv.extract((Object)resource, maxEx = Math.min(maxAmount - amount, sv.getAmount() - 1L), transaction)) != maxAmount)) {
            }
            return amount;
        }
        return ((Storage)this.backingStorage.get()).extract((Object)resource, maxAmount, transaction);
    }

    @Nullable
    public StorageView<ItemVariant> exactView(ItemVariant resource) {
        if (this.keepLastInSlot) {
            StorageView v = super.exactView((Object)resource);
            return v != null ? new FilteringStorageView((StorageView<ItemVariant>)v) : v;
        }
        return super.exactView((Object)resource);
    }

    private class FilteringStorageView
    implements StorageView<ItemVariant> {
        private StorageView<ItemVariant> delegate;

        public FilteringStorageView(StorageView<ItemVariant> delegate) {
            this.delegate = delegate;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            if (FilteredStorage.this.keepLastInSlot && (maxAmount = Math.min(this.delegate.getAmount() - 1L, maxAmount)) < 1L) {
                return 0L;
            }
            return this.delegate.extract((Object)resource, maxAmount, transaction);
        }

        public boolean isResourceBlank() {
            return this.delegate.isResourceBlank() || FilteredStorage.this.keepLastInSlot && this.delegate.getAmount() == 1L;
        }

        public ItemVariant getResource() {
            return (ItemVariant)this.delegate.getResource();
        }

        public long getAmount() {
            return FilteredStorage.this.keepLastInSlot ? this.delegate.getAmount() - 1L : this.delegate.getAmount();
        }

        public long getCapacity() {
            return FilteredStorage.this.keepLastInSlot && !this.delegate.isResourceBlank() ? this.delegate.getCapacity() - 1L : this.delegate.getCapacity();
        }

        public StorageView<ItemVariant> getUnderlyingView() {
            return this.delegate.getUnderlyingView();
        }
    }
}

