/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.config.primitives;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tristankechlo.toolleveling.ToolLeveling;
import com.tristankechlo.toolleveling.config.util.AbstractConfigValue;

public final class BooleanValue
extends AbstractConfigValue<Boolean> {
    private boolean value;
    private final boolean defaultValue;

    public BooleanValue(String identifier, boolean defaultValue) {
        super(identifier);
        this.value = defaultValue;
        this.defaultValue = defaultValue;
    }

    @Override
    public void setToDefault() {
        this.value = this.defaultValue;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public void serialize(JsonObject jsonObject) {
        jsonObject.addProperty(this.getIdentifier(), this.getValue());
    }

    @Override
    public void deserialize(JsonObject jsonObject) {
        try {
            JsonElement element = jsonObject.get(this.getIdentifier());
            if (element != null) {
                this.value = element.getAsBoolean();
            }
        }
        catch (Exception e) {
            this.value = this.defaultValue;
            ToolLeveling.LOGGER.warn("Error while loading the config value " + this.getIdentifier() + ", using defaultvalue instead");
        }
    }
}

