/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.utils;

import com.google.common.collect.ImmutableList;
import com.tristankechlo.toolleveling.client.screen.ToolLevelingTableHandledScreen;
import com.tristankechlo.toolleveling.client.screen.widgets.ButtonEntry;
import com.tristankechlo.toolleveling.config.ToolLevelingConfig;
import com.tristankechlo.toolleveling.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public final class ButtonHelper {
    public static boolean shouldButtonBeActive(ButtonEntry entry) {
        ButtonStatus status = entry.getStatus();
        if (status == ButtonStatus.NORMAL) {
            return true;
        }
        if (status == ButtonStatus.USELESS) {
            return ToolLevelingConfig.allowLevelingUselessEnchantments.getValue();
        }
        if (status == ButtonStatus.BREAK) {
            return ToolLevelingConfig.allowLevelingBreakingEnchantments.getValue();
        }
        if (status == ButtonStatus.NOT_WHITELISTED || status == ButtonStatus.BLACKLISTED || status == ButtonStatus.CAPPED || status == ButtonStatus.MAX_LEVEL || status == ButtonStatus.MIN_LEVEL) {
            return false;
        }
        return false;
    }

    public static ButtonEntry getButtonEntry(ToolLevelingTableHandledScreen parent, class_1887 enchantment, int level) {
        ImmutableList<class_1887> whitelist = ToolLevelingConfig.whitelist.getValue();
        ImmutableList<class_1887> blacklist = ToolLevelingConfig.blacklist.getValue();
        ButtonEntry buttonEntry = new ButtonEntry(parent, enchantment, level);
        if (!whitelist.isEmpty() && !whitelist.contains(enchantment)) {
            buttonEntry.setStatus(ButtonStatus.NOT_WHITELISTED);
            return buttonEntry;
        }
        if (whitelist.isEmpty() && blacklist.contains(enchantment)) {
            buttonEntry.setStatus(ButtonStatus.BLACKLISTED);
            return buttonEntry;
        }
        if (level >= Short.MAX_VALUE) {
            buttonEntry.setStatus(ButtonStatus.MAX_LEVEL);
            return buttonEntry;
        }
        if (Utils.isEnchantmentAtCap(enchantment, level)) {
            buttonEntry.setStatus(ButtonStatus.CAPPED);
            return buttonEntry;
        }
        if (!Utils.isEnchantmentOverMinimum(enchantment, level)) {
            buttonEntry.setStatus(ButtonStatus.MIN_LEVEL);
            return buttonEntry;
        }
        if (enchantment.method_8183() == 1) {
            buttonEntry.setStatus(ButtonStatus.USELESS);
            return buttonEntry;
        }
        if (Utils.willEnchantmentBreak(enchantment, level)) {
            buttonEntry.setStatus(ButtonStatus.BREAK);
            return buttonEntry;
        }
        return buttonEntry;
    }

    public static class_2561 getButtonText(ButtonEntry entry) {
        return class_2561.method_43471((String)entry.name).method_27692(ButtonHelper.getButtonTextFormatting(entry));
    }

    public static List<class_2561> getButtonToolTips(ButtonEntry data) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        tooltip.add((class_2561)class_2561.method_43471((String)data.name).method_27692(class_124.field_1075));
        String start = "container.toolleveling.tool_leveling_table";
        if (ButtonHelper.shouldButtonBeActive(data) || Utils.freeCreativeUpgrades((class_1657)class_310.method_1551().field_1724)) {
            tooltip.add((class_2561)class_2561.method_43469((String)"container.toolleveling.tool_leveling_table.current_level", (Object[])new Object[]{data.currentLevel}).method_27692(class_124.field_1063));
            tooltip.add((class_2561)class_2561.method_43469((String)"container.toolleveling.tool_leveling_table.next_level", (Object[])new Object[]{data.currentLevel + 1}).method_27692(class_124.field_1063));
            tooltip.add((class_2561)class_2561.method_43469((String)"container.toolleveling.tool_leveling_table.cost", (Object[])new Object[]{data.upgradeCost}).method_27692(class_124.field_1063));
        }
        if (Utils.freeCreativeUpgrades((class_1657)class_310.method_1551().field_1724)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"container.toolleveling.tool_leveling_table.free_creative").method_27692(class_124.field_1060));
        } else if (data.getStatus() != ButtonStatus.NORMAL) {
            tooltip.add((class_2561)class_2561.method_43471((String)("container.toolleveling.tool_leveling_table.error." + data.getStatus().toString().toLowerCase())).method_27692(ButtonHelper.getButtonTextFormatting(data)));
        }
        return tooltip;
    }

    public static class_124 getButtonTextFormatting(ButtonEntry entry) {
        class_124 format = class_124.field_1070;
        if (Utils.freeCreativeUpgrades((class_1657)class_310.method_1551().field_1724)) {
            return class_124.field_1070;
        }
        if (entry.getStatus() != ButtonStatus.NORMAL) {
            format = class_124.field_1079;
        }
        if (entry.getStatus() == ButtonStatus.USELESS) {
            format = class_124.field_1054;
        }
        return format;
    }

    public static enum ButtonStatus {
        NORMAL,
        NOT_WHITELISTED,
        BLACKLISTED,
        USELESS,
        BREAK,
        MAX_LEVEL,
        CAPPED,
        MIN_LEVEL;

    }
}

