/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.utils;

import com.google.common.collect.ImmutableMap;
import com.tristankechlo.toolleveling.config.ItemValueConfig;
import com.tristankechlo.toolleveling.config.ToolLevelingConfig;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1893;

public final class Utils {
    public static final Map<class_1887, Integer> BREAKING_ENCHANTMENTS = ImmutableMap.builder().put((Object)class_1893.field_9114, (Object)84).put((Object)class_1893.field_9098, (Object)5).put((Object)class_1893.field_9097, (Object)7).put((Object)class_1893.field_9100, (Object)5).build();

    public static long getEnchantmentUpgradeCost(class_1887 enchantment, int level) {
        double globalModifier = (Double)ToolLevelingConfig.globalUpgradeCostMultiplier.getValue();
        double specificModifier = (Double)ToolLevelingConfig.enchantmentUpgradeCostModifier.getValue().getOrDefault((Object)enchantment, (Object)1.0);
        long minCost = (Long)ToolLevelingConfig.minimumUpgradeCost.getValue();
        return (long)Math.max((double)minCost, (0.87 * (double)level * (double)level + (double)(300 * level)) * specificModifier * globalModifier);
    }

    public static long getItemWorth(class_1792 item) {
        if (ItemValueConfig.itemValues.getValue().containsKey((Object)item)) {
            return (Long)ItemValueConfig.itemValues.getValue().get((Object)item);
        }
        return (Long)ItemValueConfig.defaultItemWorth.getValue();
    }

    public static long getItemWorth(class_1799 stack) {
        return Utils.getItemWorth(stack.method_7909());
    }

    public static long getStackWorth(class_1799 stack) {
        return (long)stack.method_7947() * Utils.getItemWorth(stack);
    }

    public static boolean isEnchantmentAtCap(class_1887 enchantment, int level) {
        short globalEnchantmentCap = (Short)ToolLevelingConfig.globalEnchantmentCap.getValue();
        if (globalEnchantmentCap > 0) {
            short enchantmentCap;
            if (ToolLevelingConfig.enchantmentCaps.getValue().containsKey((Object)enchantment) && (enchantmentCap = ((Short)ToolLevelingConfig.enchantmentCaps.getValue().get((Object)enchantment)).shortValue()) < globalEnchantmentCap) {
                return level >= enchantmentCap;
            }
            return level >= globalEnchantmentCap;
        }
        if (ToolLevelingConfig.enchantmentCaps.getValue().containsKey((Object)enchantment)) {
            return level >= (Short)ToolLevelingConfig.enchantmentCaps.getValue().get((Object)enchantment);
        }
        return false;
    }

    public static boolean isEnchantmentOverMinimum(class_1887 enchantment, int level) {
        short globalEnchantmentMin = (Short)ToolLevelingConfig.globalMinimumEnchantmentLevel.getValue();
        if (globalEnchantmentMin > 0) {
            short enchantmentMin;
            if (ToolLevelingConfig.minimumEnchantmentLevels.getValue().containsKey((Object)enchantment) && (enchantmentMin = ((Short)ToolLevelingConfig.minimumEnchantmentLevels.getValue().get((Object)enchantment)).shortValue()) > globalEnchantmentMin) {
                return level >= enchantmentMin;
            }
            return level >= globalEnchantmentMin;
        }
        if (ToolLevelingConfig.minimumEnchantmentLevels.getValue().containsKey((Object)enchantment)) {
            return level >= (Short)ToolLevelingConfig.minimumEnchantmentLevels.getValue().get((Object)enchantment);
        }
        return level >= globalEnchantmentMin;
    }

    public static boolean willEnchantmentBreak(class_1887 enchantment, int level) {
        if (BREAKING_ENCHANTMENTS.containsKey(enchantment)) {
            return level >= BREAKING_ENCHANTMENTS.get(enchantment);
        }
        return false;
    }

    public static boolean freeCreativeUpgrades(class_1657 player) {
        return ToolLevelingConfig.freeUpgradesForCreativePlayers.getValue() != false && player.method_7337();
    }
}

