/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Clock;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.turtlematic.Turtlematic;
import site.siredvin.turtlematic.common.configuration.TurtlematicConfig;
import site.siredvin.turtlematic.util.UtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u0000 *2\u00020\u0001:\u0002*+B\u0007\u00a2\u0006\u0004\b(\u0010)J%\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ%\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J)\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0013\u0010\nJ\u0017\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0018\u0010\u000fJ\u0015\u0010\u0019\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0019\u0010\u000fJ\u0015\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001a\u0010\u001bR \u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001d0\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0018\u0010#\u001a\u0004\u0018\u00010\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010&\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'\u00a8\u0006,"}, d2={"Lsite/siredvin/turtlematic/util/ChunkManager;", "Lnet/minecraft/class_18;", "Lnet/minecraft/class_3218;", "level", "Ljava/util/UUID;", "owner", "Lnet/minecraft/class_1923;", "pos", "", "addForceChunk", "(Lnet/minecraft/class_3218;Ljava/util/UUID;Lnet/minecraft/class_1923;)Z", "Lnet/minecraft/server/MinecraftServer;", "server", "", "init", "(Lnet/minecraft/server/MinecraftServer;)V", "removeChunk", "(Ljava/util/UUID;Lnet/minecraft/class_1923;Lnet/minecraft/class_3218;)Z", "loadedChunk", "removeForceChunk", "Lnet/minecraft/class_2487;", "compoundTag", "save", "(Lnet/minecraft/class_2487;)Lnet/minecraft/class_2487;", "stop", "tick", "touch", "(Ljava/util/UUID;)V", "", "Lsite/siredvin/turtlematic/util/ChunkManager$LoadChunkRecord;", "forcedChunks", "Ljava/util/Map;", "initialized", "Z", "Ljava/lang/Thread;", "mainThread", "Ljava/lang/Thread;", "", "tickCounter", "J", "<init>", "()V", "Companion", "LoadChunkRecord", "turtlematic"})
public final class ChunkManager
extends class_18 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long tickCounter;
    @NotNull
    private final Map<UUID, LoadChunkRecord> forcedChunks = new LinkedHashMap();
    private boolean initialized;
    @Nullable
    private Thread mainThread;
    @NotNull
    private static final String DIMENSION_NAME_TAG = "dimensionName";
    @NotNull
    private static final String POS_TAG = "pos";
    @NotNull
    private static final String DATA_NAME = "turtlematic_ForcedChunks";
    @NotNull
    private static final String FORCED_CHUNKS_TAG = "forcedChunks";

    public final synchronized boolean addForceChunk(@NotNull class_3218 level, @NotNull UUID owner, @NotNull class_1923 pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)pos, (String)POS_TAG);
        if (this.forcedChunks.containsKey(owner)) {
            Turtlematic.INSTANCE.getLOGGER().debug("Chunk re-added to force loaded {} with touch", (Object)pos);
            LoadChunkRecord loadChunkRecord = this.forcedChunks.get(owner);
            if (loadChunkRecord != null) {
                loadChunkRecord.touch();
            }
            return true;
        }
        Turtlematic.INSTANCE.getLOGGER().debug("Chunk added to force loaded {}", (Object)pos);
        Map<UUID, LoadChunkRecord> map = this.forcedChunks;
        String string = level.method_27983().method_29177().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"level.dimension().location().toString()");
        LoadChunkRecord loadChunkRecord = new LoadChunkRecord(string, pos, 0L, 4, null);
        map.put(owner, loadChunkRecord);
        this.method_80();
        return level.method_17988(pos.field_9181, pos.field_9180, false);
    }

    public final synchronized void touch(@NotNull UUID owner) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            LoadChunkRecord loadChunkRecord = this.forcedChunks.get(owner);
            if (loadChunkRecord == null) break block0;
            loadChunkRecord.touch();
        }
    }

    public final synchronized boolean removeChunk(@NotNull UUID owner, @NotNull class_1923 pos, @NotNull class_3218 level) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)pos, (String)POS_TAG);
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (this.mainThread != null && Intrinsics.areEqual((Object)Thread.currentThread(), (Object)this.mainThread)) {
            Turtlematic.INSTANCE.getLOGGER().debug("Chunk removed from to force loaded {}", (Object)pos);
            return level.method_17988(pos.field_9181, pos.field_9180, true);
        }
        Turtlematic.INSTANCE.getLOGGER().debug("Market chunk to remove {}", (Object)pos);
        LoadChunkRecord loadChunkRecord = this.forcedChunks.get(owner);
        if (loadChunkRecord == null) {
            return false;
        }
        LoadChunkRecord forcedChunk = loadChunkRecord;
        forcedChunk.invalidate();
        return false;
    }

    public final synchronized boolean removeForceChunk(@NotNull class_3218 level, @NotNull UUID owner, @Nullable class_1923 loadedChunk) {
        boolean result2;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (!this.forcedChunks.containsKey(owner)) {
            return true;
        }
        LoadChunkRecord loadChunkRecord = this.forcedChunks.get(owner);
        if (loadChunkRecord == null) {
            return true;
        }
        LoadChunkRecord chunkRecord = loadChunkRecord;
        String string = level.method_27983().method_29177().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"level.dimension().location().toString()");
        String dimensionName = string;
        if (!Intrinsics.areEqual((Object)chunkRecord.getDimensionName(), (Object)dimensionName)) {
            boolean bl = false;
            Object[] objectArray = new Object[]{chunkRecord.getDimensionName(), dimensionName};
            String string2 = String.format("Incorrect dimension! Should be %s instead of %s", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(\n                \u2026mensionName\n            )");
            String string3 = string2;
            throw new IllegalArgumentException(string3.toString());
        }
        boolean bl = result2 = loadedChunk == null ? this.removeChunk(owner, chunkRecord.getPos(), level) : this.removeChunk(owner, loadedChunk, level);
        if (result2) {
            this.forcedChunks.remove(owner);
            this.method_80();
        }
        return result2;
    }

    public static /* synthetic */ boolean removeForceChunk$default(ChunkManager chunkManager, class_3218 class_32182, UUID uUID, class_1923 class_19232, int n, Object object) {
        if ((n & 4) != 0) {
            class_19232 = null;
        }
        return chunkManager.removeForceChunk(class_32182, uUID, class_19232);
    }

    public final synchronized void init(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        if (!this.initialized) {
            this.mainThread = server.method_3777();
            Iterable iterable = server.method_3738();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"server.allLevels");
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_3218 level = (class_3218)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)level.method_27983().method_29177().toString(), (String)"level.dimension().location().toString()");
                Map<UUID, LoadChunkRecord> $this$forEach$iv2 = this.forcedChunks;
                boolean $i$f$forEach2 = false;
                Iterator<Map.Entry<UUID, LoadChunkRecord>> iterator = $this$forEach$iv2.entrySet().iterator();
                while (iterator.hasNext()) {
                    String dimensionName;
                    Map.Entry<UUID, LoadChunkRecord> element$iv2;
                    Map.Entry<UUID, LoadChunkRecord> it = element$iv2 = iterator.next();
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getValue().getDimensionName(), (Object)dimensionName)) continue;
                    level.method_17988(it.getValue().getPos().field_9181, it.getValue().getPos().field_9180, false);
                }
            }
            this.initialized = true;
        }
    }

    public final synchronized void stop(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        if (this.initialized) {
            Iterable iterable = server.method_3738();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"server.allLevels");
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_3218 level = (class_3218)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)level.method_27983().method_29177().toString(), (String)"level.dimension().location().toString()");
                Iterable $this$forEach$iv2 = this.forcedChunks.entrySet();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String dimensionName;
                    Map.Entry it = (Map.Entry)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)((LoadChunkRecord)it.getValue()).getDimensionName(), (Object)dimensionName)) continue;
                    level.method_17988(((LoadChunkRecord)it.getValue()).getPos().field_9181, ((LoadChunkRecord)it.getValue()).getPos().field_9180, true);
                }
            }
            this.initialized = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void tick(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        long l = this.tickCounter;
        this.tickCounter = l + 1L;
        if (this.tickCounter % (long)20 == 0L) {
            Iterable iterable = server.method_3738();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"server.allLevels");
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapNotNullTo$iv$iv;
                class_3218 level = (class_3218)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)level.method_27983().method_29177().toString(), (String)"level.dimension().location().toString()");
                Iterable $this$mapNotNull$iv = this.forcedChunks.entrySet();
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach2 = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    UUID it$iv$iv;
                    String dimensionName;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    Map.Entry it = (Map.Entry)element$iv$iv;
                    boolean bl3 = false;
                    if ((Intrinsics.areEqual((Object)((LoadChunkRecord)it.getValue()).getDimensionName(), (Object)dimensionName) && !((LoadChunkRecord)it.getValue()).getValid() ? (UUID)it.getKey() : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List purgeList = (List)destination$iv$iv;
                Iterable $this$forEach$iv2 = purgeList;
                boolean $i$f$forEach3 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    UUID it = (UUID)element$iv2;
                    boolean bl5 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level");
                    ChunkManager.removeForceChunk$default(this, level, it, null, 4, null);
                }
            }
        }
    }

    @NotNull
    public class_2487 method_75(@NotNull class_2487 compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        Turtlematic.INSTANCE.getLOGGER().info("Saving all forces chunks " + this.forcedChunks.entrySet().size());
        class_2487 forcedChunksTag = new class_2487();
        Map<UUID, LoadChunkRecord> $this$forEach$iv = this.forcedChunks;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<UUID, LoadChunkRecord>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, LoadChunkRecord> element$iv;
            Map.Entry<UUID, LoadChunkRecord> entry = element$iv = iterator.next();
            boolean bl = false;
            UUID key = entry.getKey();
            LoadChunkRecord value = entry.getValue();
            forcedChunksTag.method_10566(key.toString(), (class_2520)value.serialize());
        }
        compoundTag.method_10566(FORCED_CHUNKS_TAG, (class_2520)forcedChunksTag);
        return compoundTag;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0011J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00128\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00128\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u00128\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lsite/siredvin/turtlematic/util/ChunkManager$Companion;", "", "Lnet/minecraft/class_3218;", "level", "Lsite/siredvin/turtlematic/util/ChunkManager;", "get", "(Lnet/minecraft/class_3218;)Lsite/siredvin/turtlematic/util/ChunkManager;", "Lnet/minecraft/class_2487;", "data", "load", "(Lnet/minecraft/class_2487;)Lsite/siredvin/turtlematic/util/ChunkManager;", "tag", "Lsite/siredvin/turtlematic/util/ChunkManager$LoadChunkRecord;", "readChunkRecord", "(Lnet/minecraft/class_2487;)Lsite/siredvin/turtlematic/util/ChunkManager$LoadChunkRecord;", "", "registerHooks", "()V", "", "DATA_NAME", "Ljava/lang/String;", "DIMENSION_NAME_TAG", "FORCED_CHUNKS_TAG", "POS_TAG", "<init>", "turtlematic"})
    public static final class Companion {
        private Companion() {
        }

        private final LoadChunkRecord readChunkRecord(class_2487 tag) {
            String string = tag.method_10558(ChunkManager.DIMENSION_NAME_TAG);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tag.getString(DIMENSION_NAME_TAG)");
            class_2487 class_24872 = tag.method_10562(ChunkManager.POS_TAG);
            Intrinsics.checkNotNullExpressionValue((Object)class_24872, (String)"tag.getCompound(POS_TAG)");
            return new LoadChunkRecord(string, UtilsKt.chunkPosFromNBT(class_24872), 0L, 4, null);
        }

        @NotNull
        public final ChunkManager load(@NotNull class_2487 data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            ChunkManager manager = new ChunkManager();
            class_2487 forcedData = data.method_10562(ChunkManager.FORCED_CHUNKS_TAG);
            for (String key : forcedData.method_10541()) {
                UUID uUID;
                Map map = manager.forcedChunks;
                Intrinsics.checkNotNullExpressionValue((Object)UUID.fromString(key), (String)"fromString(key)");
                class_2487 class_24872 = forcedData.method_10562(key);
                Intrinsics.checkNotNullExpressionValue((Object)class_24872, (String)"forcedData.getCompound(key)");
                LoadChunkRecord loadChunkRecord = this.readChunkRecord(class_24872);
                map.put(uUID, loadChunkRecord);
            }
            Turtlematic.INSTANCE.getLOGGER().info("Loaded " + manager.forcedChunks.size() + " forced chunks");
            return manager;
        }

        @NotNull
        public final ChunkManager get(@NotNull class_3218 level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            class_18 class_182 = level.method_17983().method_17924(Companion::load, Companion::get$lambda$0, ChunkManager.DATA_NAME);
            Intrinsics.checkNotNullExpressionValue((Object)class_182, (String)"level.dataStorage.comput\u2026nkManager() }, DATA_NAME)");
            return (ChunkManager)class_182;
        }

        public final void registerHooks() {
            ServerLifecycleEvents.SERVER_STARTED.register(Companion::registerHooks$lambda$1);
            ServerLifecycleEvents.SERVER_STOPPING.register(Companion::registerHooks$lambda$2);
            ServerTickEvents.END_SERVER_TICK.register(Companion::registerHooks$lambda$3);
        }

        private static final ChunkManager get$lambda$0() {
            return new ChunkManager();
        }

        private static final void registerHooks$lambda$1(MinecraftServer it) {
            class_3218 class_32182 = it.method_30002();
            Intrinsics.checkNotNullExpressionValue((Object)class_32182, (String)"it.overworld()");
            ChunkManager chunkManager = Companion.get(class_32182);
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            chunkManager.init(it);
        }

        private static final void registerHooks$lambda$2(MinecraftServer it) {
            class_3218 class_32182 = it.method_30002();
            Intrinsics.checkNotNullExpressionValue((Object)class_32182, (String)"it.overworld()");
            ChunkManager chunkManager = Companion.get(class_32182);
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            chunkManager.stop(it);
        }

        private static final void registerHooks$lambda$3(MinecraftServer it) {
            class_3218 class_32182 = it.method_30002();
            Intrinsics.checkNotNullExpressionValue((Object)class_32182, (String)"it.overworld()");
            ChunkManager chunkManager = Companion.get(class_32182);
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            chunkManager.tick(it);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0080\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\r\u001a\u00020\b\u00a2\u0006\u0004\b*\u0010+J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\t\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ.\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u000b\u001a\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u0004J\r\u0010\u001e\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001e\u0010\u0019R\u0017\u0010\u000b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u001f\u001a\u0004\b \u0010\u0004R\"\u0010\r\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010!\u001a\u0004\b\"\u0010\n\"\u0004\b#\u0010$R\u0017\u0010\f\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\f\u0010%\u001a\u0004\b&\u0010\u0007R\u0011\u0010)\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006,"}, d2={"Lsite/siredvin/turtlematic/util/ChunkManager$LoadChunkRecord;", "", "", "component1", "()Ljava/lang/String;", "Lnet/minecraft/class_1923;", "component2", "()Lnet/minecraft/class_1923;", "", "component3", "()J", "dimensionName", "pos", "lastTouch", "copy", "(Ljava/lang/String;Lnet/minecraft/class_1923;J)Lsite/siredvin/turtlematic/util/ChunkManager$LoadChunkRecord;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "invalidate", "()V", "Lnet/minecraft/class_2487;", "serialize", "()Lnet/minecraft/class_2487;", "toString", "touch", "Ljava/lang/String;", "getDimensionName", "J", "getLastTouch", "setLastTouch", "(J)V", "Lnet/minecraft/class_1923;", "getPos", "getValid", "()Z", "valid", "<init>", "(Ljava/lang/String;Lnet/minecraft/class_1923;J)V", "turtlematic"})
    public static final class LoadChunkRecord {
        @NotNull
        private final String dimensionName;
        @NotNull
        private final class_1923 pos;
        private long lastTouch;

        public LoadChunkRecord(@NotNull String dimensionName, @NotNull class_1923 pos, long lastTouch) {
            Intrinsics.checkNotNullParameter((Object)dimensionName, (String)ChunkManager.DIMENSION_NAME_TAG);
            Intrinsics.checkNotNullParameter((Object)pos, (String)ChunkManager.POS_TAG);
            this.dimensionName = dimensionName;
            this.pos = pos;
            this.lastTouch = lastTouch;
        }

        public /* synthetic */ LoadChunkRecord(String string, class_1923 class_19232, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                l = Clock.System.INSTANCE.now().toEpochMilliseconds();
            }
            this(string, class_19232, l);
        }

        @NotNull
        public final String getDimensionName() {
            return this.dimensionName;
        }

        @NotNull
        public final class_1923 getPos() {
            return this.pos;
        }

        public final long getLastTouch() {
            return this.lastTouch;
        }

        public final void setLastTouch(long l) {
            this.lastTouch = l;
        }

        public final boolean getValid() {
            long currentEpoch = Clock.System.INSTANCE.now().toEpochMilliseconds();
            return this.lastTouch + TurtlematicConfig.INSTANCE.getChunkLoadedTimeLimit() >= currentEpoch;
        }

        public final void touch() {
            this.lastTouch = Clock.System.INSTANCE.now().toEpochMilliseconds();
        }

        public final void invalidate() {
            this.lastTouch = Clock.System.INSTANCE.now().toEpochMilliseconds() - TurtlematicConfig.INSTANCE.getChunkLoadedTimeLimit() / (long)2;
        }

        @NotNull
        public final class_2487 serialize() {
            class_2487 tag = new class_2487();
            tag.method_10582(ChunkManager.DIMENSION_NAME_TAG, this.dimensionName);
            tag.method_10566(ChunkManager.POS_TAG, (class_2520)UtilsKt.toNBT(this.pos));
            return tag;
        }

        @NotNull
        public final String component1() {
            return this.dimensionName;
        }

        @NotNull
        public final class_1923 component2() {
            return this.pos;
        }

        public final long component3() {
            return this.lastTouch;
        }

        @NotNull
        public final LoadChunkRecord copy(@NotNull String dimensionName, @NotNull class_1923 pos, long lastTouch) {
            Intrinsics.checkNotNullParameter((Object)dimensionName, (String)ChunkManager.DIMENSION_NAME_TAG);
            Intrinsics.checkNotNullParameter((Object)pos, (String)ChunkManager.POS_TAG);
            return new LoadChunkRecord(dimensionName, pos, lastTouch);
        }

        public static /* synthetic */ LoadChunkRecord copy$default(LoadChunkRecord loadChunkRecord, String string, class_1923 class_19232, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = loadChunkRecord.dimensionName;
            }
            if ((n & 2) != 0) {
                class_19232 = loadChunkRecord.pos;
            }
            if ((n & 4) != 0) {
                l = loadChunkRecord.lastTouch;
            }
            return loadChunkRecord.copy(string, class_19232, l);
        }

        @NotNull
        public String toString() {
            return "LoadChunkRecord(dimensionName=" + this.dimensionName + ", pos=" + this.pos + ", lastTouch=" + this.lastTouch + ")";
        }

        public int hashCode() {
            int result2 = this.dimensionName.hashCode();
            result2 = result2 * 31 + this.pos.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.lastTouch);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LoadChunkRecord)) {
                return false;
            }
            LoadChunkRecord loadChunkRecord = (LoadChunkRecord)other;
            if (!Intrinsics.areEqual((Object)this.dimensionName, (Object)loadChunkRecord.dimensionName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pos, (Object)loadChunkRecord.pos)) {
                return false;
            }
            return this.lastTouch == loadChunkRecord.lastTouch;
        }
    }
}

