/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_1926;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5458;
import twilightforest.init.BiomeKeys;
import twilightforest.world.components.BiomeGrassColors;

public final class FoliageColorHandler {
    private static final Map<class_1959, Handler> HANDLES = new WeakHashMap<class_1959, Handler>();

    public static int get(int o, class_1959 biome, double x, double z) {
        Handler handler = HANDLES.get(biome);
        if (handler == null) {
            handler = Handler.REGISTRY.getOrDefault(class_5458.field_25933.method_10221((Object)biome), Handler.DEFAULT);
            HANDLES.put(biome, handler);
        }
        return handler.apply(o, x, z);
    }

    @FunctionalInterface
    private static interface Handler {
        public static final Map<class_2960, Handler> REGISTRY = new HashMap<class_2960, Handler>(){
            {
                this.put(BiomeKeys.SPOOKY_FOREST.method_29177(), (o, x, z) -> {
                    double noise = (class_1959.field_9335.method_16451(x * 0.0225, z * 0.0225, false) + 1.0) / 2.0;
                    return BiomeGrassColors.blendColors(16745729, 16252673, noise > 0.6 ? noise * 0.2 : noise);
                });
                this.put(BiomeKeys.ENCHANTED_FOREST.method_29177(), (o, x, z) -> (o & 0xFFFF00) + BiomeGrassColors.getEnchantedColor((int)x, (int)z));
                this.put(BiomeKeys.DARK_FOREST_CENTER.method_29177(), (o, x, z) -> {
                    double noise = (class_1959.field_9335.method_16451(x * 0.0225, z * 0.0225, false) + 1.0) / 2.0;
                    return noise < -0.1 ? 16351774 : 15289876;
                });
                this.put(BiomeKeys.DARK_FOREST.method_29177(), (o, x, z) -> ((class_1926.method_8344((double)0.7f, (double)0.8f) & 0xFEFEFE) + 1969742) / 2);
                this.put(BiomeKeys.SWAMP.method_29177(), (o, x, z) -> ((class_1926.method_8344((double)0.8f, (double)0.9f) & 0xFEFEFE) + 0x4E0E4E) / 2);
            }
        };
        public static final Handler DEFAULT = (o, x, z) -> o;

        public int apply(int var1, double var2, double var4);
    }
}

