/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.mojang.authlib.GameProfile;
import io.github.fabricators_of_create.porting_lib.block.LightEmissiveBlock;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import me.alphamode.forgetags.Tags;
import net.fabricmc.fabric.api.block.BlockPickInteractionAware;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_2464;
import net.minecraft.class_2484;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3542;
import net.minecraft.class_3965;
import net.minecraft.class_47;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.AbstractLightableBlock;
import twilightforest.block.entity.SkullCandleBlockEntity;

public abstract class AbstractSkullCandleBlock
extends AbstractLightableBlock
implements LightEmissiveBlock,
BlockPickInteractionAware {
    private final class_2484.class_2485 type;

    public AbstractSkullCandleBlock(class_2484.class_2485 type, class_4970.class_2251 properties) {
        super(properties);
        this.type = type;
    }

    public class_2484.class_2485 getType() {
        return this.type;
    }

    public int getLightEmission(class_2680 state, class_1922 getter, class_2338 pos) {
        class_2586 class_25862 = getter.method_8321(pos);
        if (class_25862 instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)class_25862;
            switch ((AbstractLightableBlock.Lighting)((Object)state.method_11654((class_2769)LIGHTING))) {
                case NONE: {
                    return 0;
                }
                case NORMAL: {
                    return 3 * sc.candleAmount;
                }
                case OMINOUS: {
                    return 2 * sc.candleAmount;
                }
            }
        }
        return 0;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SkullCandleBlockEntity(pos, state, 0, 0);
    }

    public static class_2248 candleColorToCandle(String candleName) {
        if (!candleName.equals(CandleColors.PLAIN.method_15434())) {
            return Objects.requireNonNull((class_2248)class_2378.field_11146.method_10223(new class_2960(candleName + "_candle")));
        }
        return class_2246.field_27099;
    }

    public static CandleColors candleToCandleColor(class_1792 candle) {
        if (candle != class_2246.field_27099.method_8389()) {
            return CandleColors.valueOf(class_2378.field_11142.method_10221((Object)candle).method_12832().replace("_candle", "").replace("\"", "").toUpperCase(Locale.ROOT));
        }
        return CandleColors.PLAIN;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11455;
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        super.method_9567(level, pos, state, placer, stack);
        class_2586 blockentity = level.method_8321(pos);
        if (blockentity instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockentity;
            if (stack.method_7985() && stack.method_7969() != null) {
                class_2487 tag = stack.method_7941("BlockEntityTag");
                if (tag != null) {
                    if (tag.method_10545("CandleAmount")) {
                        sc.candleAmount = tag.method_10550("CandleAmount");
                    }
                    if (tag.method_10545("CandleColor")) {
                        sc.candleColor = tag.method_10550("CandleColor");
                    }
                }
                if (this.type == class_2484.class_2486.field_11510) {
                    GameProfile gameprofile = null;
                    class_2487 compoundtag = stack.method_7969();
                    if (compoundtag.method_10573("SkullOwner", 10)) {
                        gameprofile = class_2512.method_10683((class_2487)compoundtag.method_10562("SkullOwner"));
                    } else if (compoundtag.method_10573("SkullOwner", 8) && !StringUtils.isBlank((CharSequence)compoundtag.method_10558("SkullOwner"))) {
                        gameprofile = new GameProfile(null, compoundtag.method_10558("SkullOwner"));
                    }
                    sc.method_11333(gameprofile);
                }
            }
        }
    }

    public List<class_1799> method_9560(class_2680 state, class_47.class_48 builder) {
        class_2586 blockEntity;
        List drops = super.method_9560(state, builder);
        Optional<class_1799> skullStack = drops.stream().filter(item -> item.method_31573(Tags.Items.HEADS) && !item.method_31574(this.method_8389())).findFirst();
        if (skullStack.isPresent() && (blockEntity = (class_2586)builder.method_305(class_181.field_1228)) instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockEntity;
            if (!((class_1799)builder.method_308(class_181.field_1229)).method_7960() && class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)((class_1799)builder.method_308(class_181.field_1229))) > 0) {
                class_1799 newStack = new class_1799((class_1935)this);
                class_2487 tag = new class_2487();
                tag.method_10569("CandleColor", sc.candleColor);
                tag.method_10569("CandleAmount", sc.candleAmount);
                newStack.method_7959("BlockEntityTag", (class_2520)tag);
                if (sc.method_11334() != null) {
                    newStack.method_7948().method_10566("SkullOwner", (class_2520)class_2512.method_10684((class_2487)new class_2487(), (GameProfile)sc.method_11334()));
                }
                drops.remove(skullStack.get());
                drops.add(newStack);
            } else {
                drops.add(new class_1799((class_1935)AbstractSkullCandleBlock.candleColorToCandle(CandleColors.colorFromInt(sc.candleColor).method_15434()), sc.candleAmount));
            }
        }
        return drops;
    }

    public class_1799 getPickedStack(class_2680 state, class_1922 getter, class_2338 pos, @Nullable class_1657 player, @Nullable class_239 result) {
        class_1799 newStack = new class_1799((class_1935)this);
        class_2487 tag = new class_2487();
        class_2586 class_25862 = getter.method_8321(pos);
        if (class_25862 instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)class_25862;
            if (sc.method_11334() != null) {
                newStack.method_7948().method_10566("SkullOwner", (class_2520)class_2512.method_10684((class_2487)new class_2487(), (GameProfile)sc.method_11334()));
            }
            tag.method_10569("CandleColor", sc.candleColor);
            tag.method_10569("CandleAmount", sc.candleAmount);
            newStack.method_7959("BlockEntityTag", (class_2520)tag);
        }
        return newStack;
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 result) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)class_25862;
            if (player.method_5998(hand).method_31573(class_3489.field_26989) && player.method_5998(hand).method_31574(AbstractSkullCandleBlock.candleColorToCandle(CandleColors.colorFromInt(sc.candleColor).method_15434()).method_8389()) && !player.method_5715() && sc.candleAmount < 4) {
                ++sc.candleAmount;
                level.method_8396(null, pos, class_3417.field_26958, class_3419.field_15245, 1.0f, 1.0f);
                if (!player.method_31549().field_7477) {
                    player.method_5998(hand).method_7934(1);
                }
                level.method_22336().method_15513(pos);
                return class_1269.method_29236((boolean)level.method_8608());
            }
        }
        return super.method_9534(state, level, pos, player, hand, result);
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 rand) {
        if (state.method_11654((class_2769)LIGHTING) != AbstractLightableBlock.Lighting.NONE) {
            this.getParticleOffsets(state, (class_1936)level, pos).forEach(offset -> AbstractSkullCandleBlock.addParticlesAndSound(level, offset.method_1031((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()), rand, state.method_11654((class_2769)LIGHTING) == AbstractLightableBlock.Lighting.OMINOUS));
        }
    }

    public static enum CandleColors implements class_3542
    {
        PLAIN(0),
        WHITE(1),
        LIGHT_GRAY(2),
        GRAY(3),
        BLACK(4),
        RED(5),
        ORANGE(6),
        YELLOW(7),
        GREEN(8),
        LIME(9),
        BLUE(10),
        CYAN(11),
        LIGHT_BLUE(12),
        PURPLE(13),
        MAGENTA(14),
        PINK(15),
        BROWN(16);

        private final int value;
        private static final Map<Integer, CandleColors> map;

        private CandleColors(int value) {
            this.value = value;
        }

        public static CandleColors colorFromInt(int value) {
            return map.get(value);
        }

        public int getValue() {
            return this.value;
        }

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            map = new HashMap<Integer, CandleColors>();
            for (CandleColors color : CandleColors.values()) {
                map.put(color.value, color);
            }
        }
    }
}

