/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity;

import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2398;
import net.minecraft.class_2465;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFBlocks;

public class GrowingBeanstalkBlockEntity
extends class_2586 {
    private int ticker;
    private int layer;
    private boolean isAreaClearEnough = true;
    private int nextLeafY;
    private int yOffset;
    private float cScale;
    private float rScale;
    private int maxY;
    private int blocksSkipped;

    public GrowingBeanstalkBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)TFBlockEntities.BEANSTALK_GROWER.get(), pos, state);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, GrowingBeanstalkBlockEntity te) {
        ++te.ticker;
        if (te.ticker == 1) {
            te.nextLeafY = pos.method_10264() + 10 + level.method_8409().method_43048(10);
            te.yOffset = level.method_8409().method_43048(100);
            te.cScale = level.method_8409().method_43057() * 0.25f + 0.125f;
            te.rScale = level.method_8409().method_43057() * 0.25f + 0.125f;
            te.maxY = Math.max(pos.method_10264() + 100, 175);
        }
        if (level.method_8608()) {
            if (te.ticker < 100) {
                for (int i = 0; i < 20; ++i) {
                    float x = (float)pos.method_10263() + level.method_8409().method_43057() + (float)(level.method_8409().method_43048(5) * (level.method_8409().method_43056() ? -1 : 1));
                    float z = (float)pos.method_10260() + level.method_8409().method_43057() + (float)(level.method_8409().method_43048(5) * (level.method_8409().method_43056() ? -1 : 1));
                    class_2680 underState = level.method_8320(new class_2338((double)x, (double)pos.method_10074().method_10264(), (double)z));
                    if (!underState.method_26207().method_15799()) continue;
                    level.method_8494((class_2394)new class_2388(class_2398.field_11217, underState), (double)x, (double)pos.method_10264(), (double)z, 0.0, 0.0, 0.0);
                }
            }
        } else if (te.ticker > 100 && te.ticker % 2 == 0) {
            int layerYPos = pos.method_10264() + te.layer;
            if (te.isAreaClearEnough && layerYPos < te.maxY) {
                float x = pos.method_10263();
                float z = pos.method_10260();
                float radius = 4.0f + class_3532.method_15374((float)((float)(pos.method_10264() + te.yOffset) * te.rScale)) * 3.0f;
                x -= class_3532.method_15374((float)((float)(pos.method_10264() + te.yOffset) * te.cScale)) * radius;
                z -= class_3532.method_15362((float)((float)(pos.method_10264() + te.yOffset) * te.cScale)) * radius;
                radius = 5.0f + class_3532.method_15374((float)((float)(layerYPos + te.yOffset) * te.rScale)) * 2.5f;
                float cx = x + class_3532.method_15374((float)((float)(layerYPos + te.yOffset) * te.cScale)) * radius;
                float cz = z + class_3532.method_15362((float)((float)(layerYPos + te.yOffset) * te.cScale)) * radius;
                float stalkThickness = 2.5f;
                if (te.maxY - layerYPos < 5) {
                    stalkThickness *= (float)(te.maxY - layerYPos) / 5.0f;
                }
                int minX = class_3532.method_15375((float)(x - radius - stalkThickness));
                int maxX = class_3532.method_15386((float)(x + radius + stalkThickness));
                int minZ = class_3532.method_15375((float)(z - radius - stalkThickness));
                int maxZ = class_3532.method_15386((float)(z + radius + stalkThickness));
                for (int dx = minX; dx < maxX && te.isAreaClearEnough; ++dx) {
                    for (int dz = minZ; dz < maxZ && te.isAreaClearEnough; ++dz) {
                        float circle = ((float)dx - cx) * ((float)dx - cx) + ((float)dz - cz) * ((float)dz - cz);
                        if (!(circle < stalkThickness * stalkThickness)) continue;
                        te.isAreaClearEnough = te.tryToPlaceStalk(level, new class_2338(dx, layerYPos, dz), true);
                        if (!(circle < stalkThickness)) continue;
                        te.tryToPlaceStalk(level, new class_2338(dx, layerYPos + 1, dz), false);
                        if (!(circle < stalkThickness / 2.0f)) continue;
                        te.tryToPlaceStalk(level, new class_2338(dx, layerYPos + 2, dz), false);
                    }
                }
                te.blocksSkipped = 0;
                if (layerYPos == te.nextLeafY) {
                    boolean wasAnEvenNumber = te.nextLeafY % 2 == 0;
                    float v = radius + (wasAnEvenNumber ? stalkThickness : -stalkThickness);
                    int lx = (int)(x + class_3532.method_15374((float)((float)(layerYPos + te.yOffset) * te.cScale)) * v);
                    int lz = (int)(z + class_3532.method_15362((float)((float)(layerYPos + te.yOffset) * te.cScale)) * v);
                    te.placeLeaves(level, new class_2338(lx, layerYPos, lz));
                    te.nextLeafY = layerYPos + 5 + level.method_8409().method_43048(10);
                    if (te.nextLeafY % 2 == 0 == wasAnEvenNumber) {
                        ++te.nextLeafY;
                    }
                }
                ++te.layer;
            } else {
                level.method_8501(pos, ((class_2465)TFBlocks.HUGE_STALK.get()).method_9564());
                level.method_8544(pos);
            }
        }
    }

    private void placeLeaves(class_1937 world, class_2338 pos) {
        int dz;
        int dx;
        world.method_8501(pos, ((class_2465)TFBlocks.HUGE_STALK.get()).method_9564());
        for (dx = -1; dx <= 1; ++dx) {
            for (dz = -1; dz <= 1; ++dz) {
                int distance = Math.abs(dx) + Math.abs(dz) + 1;
                this.tryToPlaceLeaves(world, pos.method_10069(dx, -1, dz), distance);
                this.tryToPlaceLeaves(world, pos.method_10069(dx, 1, dz), distance);
            }
        }
        for (dx = -2; dx <= 2; ++dx) {
            for (dz = -2; dz <= 2; ++dz) {
                if ((dx == 2 || dx == -2) && (dz == 2 || dz == -2)) continue;
                this.tryToPlaceLeaves(world, pos.method_10069(dx, 0, dz), Math.max(Math.abs(dx) + Math.abs(dz), 1));
            }
        }
    }

    private boolean tryToPlaceStalk(class_1937 level, class_2338 pos, boolean checkBlocked) {
        class_2680 state = level.method_8320(pos);
        if (state.method_26215() || state.method_26207().method_15800() && !state.method_27852((class_2248)TFBlocks.BEANSTALK_GROWER.get()) || state.method_26215() || state.method_26164(class_3481.field_15503) || state.method_26204().equals(TFBlocks.FLUFFY_CLOUD.get())) {
            level.method_8501(pos, ((class_2465)TFBlocks.HUGE_STALK.get()).method_9564());
            if (pos.method_10264() > 150) {
                for (int i = 0; i < 7; ++i) {
                    if (!level.method_8320(pos.method_10079(class_2350.field_11036, i)).method_27852((class_2248)TFBlocks.WISPY_CLOUD.get()) && !level.method_8320(pos.method_10079(class_2350.field_11036, i)).method_27852((class_2248)TFBlocks.FLUFFY_CLOUD.get())) continue;
                    level.method_8501(pos.method_10079(class_2350.field_11036, i), class_2246.field_10124.method_9564());
                }
            }
            return true;
        }
        if (!state.method_27852((class_2248)TFBlocks.HUGE_STALK.get()) && checkBlocked) {
            ++this.blocksSkipped;
        }
        return this.blocksSkipped < 15;
    }

    private void tryToPlaceLeaves(class_1937 world, class_2338 pos, int distance) {
        class_2680 state = world.method_8320(pos);
        if (state.method_26215() || state.method_26164(class_3481.field_15503)) {
            world.method_8652(pos, (class_2680)((class_2248)TFBlocks.BEANSTALK_LEAVES.get()).method_9564().method_11657((class_2769)class_2397.field_11199, (Comparable)Integer.valueOf(distance)), 2);
        }
    }

    protected void method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        compoundTag.method_10569("ticker", this.ticker);
        compoundTag.method_10569("layer", this.layer);
        compoundTag.method_10556("isAreaClearEnough", this.isAreaClearEnough);
        compoundTag.method_10569("nextLeafY", this.nextLeafY);
        compoundTag.method_10569("yOffset", this.yOffset);
        compoundTag.method_10548("cScale", this.cScale);
        compoundTag.method_10548("rScale", this.rScale);
        compoundTag.method_10569("maxY", this.maxY);
        compoundTag.method_10569("blocksSkipped", this.blocksSkipped);
    }

    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        this.ticker = compoundTag.method_10550("ticker");
        this.layer = compoundTag.method_10550("layer");
        this.isAreaClearEnough = compoundTag.method_10577("isAreaClearEnough");
        this.nextLeafY = compoundTag.method_10550("nextLeafY");
        this.yOffset = compoundTag.method_10550("yOffset");
        this.cScale = compoundTag.method_10583("cScale");
        this.rScale = compoundTag.method_10583("rScale");
        this.maxY = compoundTag.method_10550("maxY");
        this.blocksSkipped = compoundTag.method_10550("blocksSkipped");
    }

    public boolean isBeanstalkRumbling() {
        return this.ticker < 110;
    }
}

