/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import io.github.fabricators_of_create.porting_lib.event.client.CameraSetupCallback;
import io.github.fabricators_of_create.porting_lib.event.client.FieldOfViewEvents;
import io.github.fabricators_of_create.porting_lib.event.client.LivingEntityRenderEvents;
import io.github.fabricators_of_create.porting_lib.event.client.MinecraftTailCallback;
import io.github.fabricators_of_create.porting_lib.event.client.ModelsBakedCallback;
import io.github.fabricators_of_create.porting_lib.event.client.RenderTickStartCallback;
import io.github.fabricators_of_create.porting_lib.event.client.TextureStitchCallback;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.DimensionRenderingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1092;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1843;
import net.minecraft.class_1923;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2806;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3532;
import net.minecraft.class_3882;
import net.minecraft.class_457;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5250;
import net.minecraft.class_5294;
import net.minecraft.class_5498;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_746;
import net.minecraft.class_897;
import net.minecraft.class_922;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.block.entity.GrowingBeanstalkBlockEntity;
import twilightforest.client.BugModelAnimationHelper;
import twilightforest.client.EffectRenders;
import twilightforest.client.TwilightForestRenderInfo;
import twilightforest.client.model.block.doors.CastleDoorModelLoader;
import twilightforest.client.model.block.giantblock.GiantBlockModelLoader;
import twilightforest.client.model.block.patch.PatchModelLoader;
import twilightforest.client.renderer.TFSkyRenderer;
import twilightforest.client.renderer.TFWeatherRenderer;
import twilightforest.client.renderer.entity.ShieldLayer;
import twilightforest.client.renderer.tileentity.TwilightChestRenderer;
import twilightforest.compat.trinkets.TrinketsCompat;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.events.HostileMountEvents;
import twilightforest.init.TFItems;
import twilightforest.item.EnderBowItem;
import twilightforest.item.IceBowItem;
import twilightforest.item.SeekerBowItem;
import twilightforest.item.SkullCandleItem;
import twilightforest.item.TripleBowItem;
import twilightforest.item.TrophyItem;
import twilightforest.world.registration.TFGenerationSettings;

@Environment(value=EnvType.CLIENT)
public class TFClientEvents {
    public static int time = 0;
    private static int rotationTickerI = 0;
    private static int sineTickerI = 0;
    public static float rotationTicker = 0.0f;
    public static float sineTicker = 0.0f;
    public static final float PI = (float)Math.PI;
    private static final int SINE_TICKER_BOUND = 627;
    private static float intensity = 0.0f;
    private static final class_5250 WIP_TEXT_0 = class_2561.method_43471((String)"twilightforest.misc.wip0").method_10862(class_2583.field_24360.method_10977(class_124.field_1061));
    private static final class_5250 WIP_TEXT_1 = class_2561.method_43471((String)"twilightforest.misc.wip1").method_10862(class_2583.field_24360.method_10977(class_124.field_1061));
    private static final class_5250 NYI_TEXT = class_2561.method_43471((String)"twilightforest.misc.nyi").method_10862(class_2583.field_24360.method_10977(class_124.field_1061));

    public static void init() {
        ModBusEvents.registerModels();
        ModBusEvents.registerLoaders();
        MinecraftTailCallback.EVENT.register(ModBusEvents::registerDimEffects);
        WorldRenderEvents.LAST.register(TFClientEvents::renderWorldLast);
        ModelsBakedCallback.EVENT.register(ModBusEvents::modelBake);
        TextureStitchCallback.PRE.register(ModBusEvents::texStitch);
        RenderTickStartCallback.EVENT.register(TFClientEvents::renderTick);
        ClientTickEvents.END_CLIENT_TICK.register(TFClientEvents::clientTick);
        ItemTooltipCallback.EVENT.register(TFClientEvents::tooltipEvent);
        FieldOfViewEvents.MODIFY.register(TFClientEvents::FOVUpdate);
        LivingEntityRenderEvents.PRE.register(TFClientEvents::unrenderHeadWithTrophies);
        ItemTooltipCallback.EVENT.register(TFClientEvents::translateBookAuthor);
        CameraSetupCallback.EVENT.register(TFClientEvents::camera);
    }

    public static void renderWorldLast(WorldRenderContext context) {
        class_897 renderer;
        if (!((Boolean)TFConfig.CLIENT_CONFIG.firstPersonEffects.get()).booleanValue()) {
            return;
        }
        class_315 settings = class_310.method_1551().field_1690;
        if (settings.method_31044() != class_5498.field_26664 || settings.field_1842) {
            return;
        }
        class_1297 entity = class_310.method_1551().method_1560();
        if (entity instanceof class_1309 && (renderer = class_310.method_1551().method_1561().method_3953(entity)) instanceof class_922) {
            for (EffectRenders effect : EffectRenders.VALUES) {
                if (!effect.shouldRender((class_1309)entity, true)) continue;
                effect.render((class_1309)entity, (class_583<? extends class_1309>)((class_922)renderer).method_4038(), 0.0, 0.0, 0.0, context.tickDelta(), true);
            }
        }
    }

    public static void renderTick() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 != null && TFGenerationSettings.DIMENSION_KEY.equals((Object)minecraft.field_1687.method_27983()) && minecraft.field_1705 != null) {
            minecraft.field_1705.field_2013 = 0.0f;
        }
        if (minecraft.field_1724 != null && HostileMountEvents.isRidingUnfriendly((class_1309)minecraft.field_1724) && minecraft.field_1705 != null) {
            minecraft.field_1705.method_1758((class_2561)class_2561.method_43473(), false);
        }
    }

    public static void clientTick(class_310 client) {
        if (class_310.method_1551().method_1493()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        float partial = mc.method_1488();
        if (!mc.method_1493() || mc.field_1755 != null && mc.field_1755.getClass().equals(class_457.class)) {
            ++time;
            rotationTickerI = rotationTickerI >= 359 ? 0 : rotationTickerI + 1;
            sineTickerI = sineTickerI >= 627 ? 0 : sineTickerI + 1;
            rotationTicker = (float)rotationTickerI + partial;
            sineTicker += partial;
        }
        if (!mc.method_1493()) {
            BugModelAnimationHelper.animate();
            class_5294 info = DimensionRenderingRegistry.getDimensionEffects((class_2960)TwilightForestMod.prefix("renderer"));
            if (mc.field_1687 != null && info instanceof TwilightForestRenderInfo) {
                TFWeatherRenderer.tick();
            }
            if (((Boolean)TFConfig.CLIENT_CONFIG.firstPersonEffects.get()).booleanValue() && mc.field_1687 != null && mc.field_1724 != null) {
                HashSet<class_1923> chunksInRange = new HashSet<class_1923>();
                for (int x = -16; x <= 16; x += 16) {
                    for (int z = -16; z <= 16; z += 16) {
                        chunksInRange.add(new class_1923((int)(mc.field_1724.method_23317() + (double)x) >> 4, (int)(mc.field_1724.method_23321() + (double)z) >> 4));
                    }
                }
                for (class_1923 pos : chunksInRange) {
                    List beanstalksInChunk;
                    if (mc.field_1687.method_8402(pos.field_9181, pos.field_9180, class_2806.field_12803, false) == null || (beanstalksInChunk = mc.field_1687.method_8497(pos.field_9181, pos.field_9180).method_12214().values().stream().filter(blockEntity -> {
                        GrowingBeanstalkBlockEntity beanstalkBlock;
                        return blockEntity instanceof GrowingBeanstalkBlockEntity && (beanstalkBlock = (GrowingBeanstalkBlockEntity)((Object)blockEntity)).isBeanstalkRumbling();
                    }).collect(Collectors.toList())).isEmpty()) continue;
                    class_2586 beanstalk = (class_2586)beanstalksInChunk.get(0);
                    class_746 player = mc.field_1724;
                    intensity = (float)(1.0 - mc.field_1724.method_5707(class_243.method_24953((class_2382)beanstalk.method_11016())) / Math.pow(16.0, 2.0));
                    if (!(intensity > 0.0f)) continue;
                    player.method_5808(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454() + (player.method_6051().method_43057() * 2.0f - 1.0f) * intensity, player.method_36455() + (player.method_6051().method_43057() * 2.0f - 1.0f) * intensity);
                    intensity = 0.0f;
                    break;
                }
            }
        }
    }

    public static boolean camera(CameraSetupCallback.CameraInfo info) {
        if (((Boolean)TFConfig.CLIENT_CONFIG.firstPersonEffects.get()).booleanValue() && !class_310.method_1551().method_1493() && intensity > 0.0f && class_310.method_1551().field_1724 != null) {
            info.yaw = (float)class_3532.method_16436((double)info.partialTicks, (double)info.yaw, (double)(info.yaw + (class_310.method_1551().field_1724.method_6051().method_43057() * 2.0f - 1.0f) * intensity));
            info.pitch = (float)class_3532.method_16436((double)info.partialTicks, (double)info.pitch, (double)(info.pitch + (class_310.method_1551().field_1724.method_6051().method_43057() * 2.0f - 1.0f) * intensity));
            info.roll = (float)class_3532.method_16436((double)info.partialTicks, (double)info.roll, (double)(info.roll + (class_310.method_1551().field_1724.method_6051().method_43057() * 2.0f - 1.0f) * intensity));
            intensity = 0.0f;
        }
        return false;
    }

    public static void tooltipEvent(class_1799 item, class_1836 context, List<class_2561> lines) {
        if (!item.method_31573(ItemTagGenerator.WIP) && !item.method_31573(ItemTagGenerator.NYI)) {
            return;
        }
        if (item.method_31573(ItemTagGenerator.WIP)) {
            lines.add((class_2561)WIP_TEXT_0);
            lines.add((class_2561)WIP_TEXT_1);
        } else {
            lines.add((class_2561)NYI_TEXT);
        }
    }

    public static float FOVUpdate(class_1657 player, float fov) {
        class_1792 useItem;
        if (player.method_6115() && ((useItem = player.method_6030().method_7909()) instanceof TripleBowItem || useItem instanceof EnderBowItem || useItem instanceof IceBowItem || useItem instanceof SeekerBowItem)) {
            float f = (float)player.method_6048() / 20.0f;
            f = f > 1.0f ? 1.0f : f * f;
            return fov * (1.0f - f * 0.15f);
        }
        return fov;
    }

    public static boolean unrenderHeadWithTrophies(class_1309 entity, class_922<?, ?> renderer, float partialRenderTick, class_4587 matrixStack, class_4597 buffers, int light) {
        class_583 class_5832;
        boolean visible;
        class_1799 stack = entity.method_6118(class_1304.field_6169);
        boolean bl = visible = !(stack.method_7909() instanceof TrophyItem) && !(stack.method_7909() instanceof SkullCandleItem) && !TFClientEvents.areCuriosEquipped(entity);
        if (!visible && (class_5832 = renderer.method_4038()) instanceof class_3882) {
            class_3882 headedModel = (class_3882)class_5832;
            headedModel.method_2838().field_3665 = false;
            class_583 class_5833 = renderer.method_4038();
            if (class_5833 instanceof class_572) {
                class_572 humanoidModel = (class_572)class_5833;
                humanoidModel.field_3394.field_3665 = false;
            }
        }
        return false;
    }

    private static boolean areCuriosEquipped(class_1309 entity) {
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            return TrinketsCompat.isTrophyCurioEquipped(entity) || TrinketsCompat.isSkullCurioEquipped(entity);
        }
        return false;
    }

    public static void translateBookAuthor(class_1799 stack, class_1836 context, List<class_2561> lines) {
        class_2487 tag;
        if (stack.method_7909() instanceof class_1843 && stack.method_7985() && (tag = stack.method_7948()).method_10545("twilightforest:book")) {
            List<class_2561> components = lines;
            for (class_2561 component : components) {
                if (!component.toString().contains("book.byAuthor")) continue;
                components.set(components.indexOf(component), (class_2561)class_2561.method_43471((String)"book.byAuthor").method_10852((class_2561)class_2561.method_43471((String)"twilightforest.book.author")).method_27696(component.method_10866()));
            }
        }
    }

    public static class ModBusEvents {
        public static void registerLoaders() {
            ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> PatchModelLoader.INSTANCE);
            ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> GiantBlockModelLoader.INSTANCE);
            ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> CastleDoorModelLoader.INSTANCE);
        }

        public static void modelBake(class_1092 manager, Map<class_2960, class_1087> bakedModels, class_1088 loader) {
            TFItems.addItemModelProperties();
        }

        public static void texStitch(class_1059 map, Consumer<class_2960> spriteAdder) {
            if (class_4722.field_21709.equals((Object)map.method_24106())) {
                TwilightChestRenderer.MATERIALS.values().stream().flatMap(e -> e.values().stream()).map(class_4730::method_24147).forEach(spriteAdder::accept);
            }
            spriteAdder.accept(TwilightForestMod.prefix("block/mosspatch"));
        }

        public static void registerModels() {
            ModelLoadingRegistry.INSTANCE.registerModelProvider((manager, out) -> out.accept(ShieldLayer.LOC));
            ModelLoadingRegistry.INSTANCE.registerModelProvider((manager, out) -> out.accept(new class_1091(TwilightForestMod.prefix("trophy"), "inventory")));
            ModelLoadingRegistry.INSTANCE.registerModelProvider((manager, out) -> out.accept(new class_1091(TwilightForestMod.prefix("trophy_minor"), "inventory")));
            ModelLoadingRegistry.INSTANCE.registerModelProvider((manager, out) -> out.accept(new class_1091(TwilightForestMod.prefix("trophy_quest"), "inventory")));
            ModelLoadingRegistry.INSTANCE.registerModelProvider((manager, out) -> out.accept(TwilightForestMod.prefix("block/casket_obsidian")));
            ModelLoadingRegistry.INSTANCE.registerModelProvider((manager, out) -> out.accept(TwilightForestMod.prefix("block/casket_stone")));
            ModelLoadingRegistry.INSTANCE.registerModelProvider((manager, out) -> out.accept(TwilightForestMod.prefix("block/casket_basalt")));
        }

        public static void registerDimEffects(class_310 client) {
            new TFSkyRenderer();
            new TFWeatherRenderer();
            class_2960 id = TwilightForestMod.prefix("renderer");
            TwilightForestRenderInfo info = new TwilightForestRenderInfo(128.0f, false, class_5294.class_5401.field_25639, false, false);
            DimensionRenderingRegistry.registerDimensionEffects((class_2960)id, (class_5294)info);
            DimensionRenderingRegistry.registerSkyRenderer(TFGenerationSettings.DIMENSION_KEY, info::renderSky);
            DimensionRenderingRegistry.registerWeatherRenderer(TFGenerationSettings.DIMENSION_KEY, info::renderSnowAndRain);
        }
    }
}

