/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2902;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import twilightforest.TwilightForestMod;
import twilightforest.init.BiomeKeys;
import twilightforest.world.registration.TFGenerationSettings;

public class TFWeatherRenderer {
    private static final class_2960 RAIN_TEXTURES = new class_2960("textures/environment/rain.png");
    private static final class_2960 SNOW_TEXTURES = new class_2960("textures/environment/snow.png");
    private static final class_2960 SPARKLES_TEXTURE = TwilightForestMod.getEnvTexture("sparkles.png");
    private static final float[] rainxs = new float[1024];
    private static final float[] rainzs = new float[1024];
    private static int rendererUpdateCount;
    private static class_3341 protectedBox;
    private static final Random random;

    public TFWeatherRenderer() {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = class_3532.method_15355((float)(f * f + f1 * f1));
                TFWeatherRenderer.rainxs[i << 5 | j] = -f1 / f2;
                TFWeatherRenderer.rainzs[i << 5 | j] = f / f2;
            }
        }
    }

    public static void tick() {
        ++rendererUpdateCount;
    }

    public static boolean renderSnowAndRain(class_638 level, float partialTicks, class_765 lightmap, double camX, double camY, double camZ) {
        class_310 mc = class_310.method_1551();
        TFWeatherRenderer.renderNormalWeather(lightmap, level, mc, partialTicks, camX, camY, camZ);
        if (TFGenerationSettings.isProgressionEnforced((class_1937)level) && !mc.field_1724.method_7337() && !mc.field_1724.method_7325()) {
            TFWeatherRenderer.renderLockedBiome(partialTicks, level, mc, lightmap, camX, camY, camZ);
            TFWeatherRenderer.renderLockedStructure(partialTicks, mc, lightmap, camX, camY, camZ);
        }
        return true;
    }

    private static void renderNormalWeather(class_765 lightmap, class_638 world, class_310 mc, float ticks, double x, double y, double z) {
        float f = class_310.method_1551().field_1687.method_8430(ticks);
        if (!(f <= 0.0f)) {
            lightmap.method_3316();
            class_638 level = class_310.method_1551().field_1687;
            int i = class_3532.method_15357((double)x);
            int j = class_3532.method_15357((double)y);
            int k = class_3532.method_15357((double)z);
            class_289 tesselator = class_289.method_1348();
            class_287 bufferbuilder = tesselator.method_1349();
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            int l = 5;
            if (class_310.method_1517()) {
                l = 10;
            }
            RenderSystem.depthMask((boolean)class_310.method_29611());
            int i1 = -1;
            float f1 = (float)rendererUpdateCount + ticks;
            RenderSystem.setShader(class_757::method_34546);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339();
            for (int j1 = k - l; j1 <= k + l; ++j1) {
                for (int k1 = i - l; k1 <= i + l; ++k1) {
                    int l1 = (j1 - k + 16) * 32 + k1 - i + 16;
                    double d0 = (double)rainxs[l1] * 0.5;
                    double d1 = (double)rainzs[l1] * 0.5;
                    blockpos$mutableblockpos.method_10103(k1, 0, j1);
                    class_1959 biome = (class_1959)level.method_23753((class_2338)blockpos$mutableblockpos).comp_349();
                    if (biome.method_8694() == class_1959.class_1963.field_9384) continue;
                    int i2 = level.method_8598(class_2902.class_2903.field_13197, (class_2338)blockpos$mutableblockpos).method_10264();
                    int j2 = j - l;
                    int k2 = j + l;
                    if (j2 < i2) {
                        j2 = i2;
                    }
                    if (k2 < i2) {
                        k2 = i2;
                    }
                    int l2 = i2;
                    if (i2 < j) {
                        l2 = j;
                    }
                    if (j2 == k2) continue;
                    Random random = new Random((long)k1 * (long)k1 * 3121L + (long)k1 * 45238971L ^ (long)j1 * (long)j1 * 418711L + (long)j1 * 13761L);
                    blockpos$mutableblockpos.method_10103(k1, j2, j1);
                    float f2 = biome.method_21740((class_2338)blockpos$mutableblockpos);
                    if (f2 >= 0.15f) {
                        if (i1 != 0) {
                            if (i1 >= 0) {
                                tesselator.method_1350();
                            }
                            i1 = 0;
                            RenderSystem.setShaderTexture((int)0, (class_2960)RAIN_TEXTURES);
                            bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1584);
                        }
                        int i3 = rendererUpdateCount + k1 * k1 * 3121 + k1 * 45238971 + j1 * j1 * 418711 + j1 * 13761 & 0x1F;
                        float f3 = -((float)i3 + ticks) / 32.0f * (3.0f + random.nextFloat());
                        double d2 = (double)k1 + 0.5 - x;
                        double d4 = (double)j1 + 0.5 - z;
                        float f4 = (float)Math.sqrt(d2 * d2 + d4 * d4) / (float)l;
                        float f5 = ((1.0f - f4 * f4) * 0.5f + 0.5f) * f;
                        blockpos$mutableblockpos.method_10103(k1, l2, j1);
                        int j3 = class_761.method_23794((class_1920)level, (class_2338)blockpos$mutableblockpos);
                        bufferbuilder.method_22912((double)k1 - x - d0 + 0.5, (double)k2 - y, (double)j1 - z - d1 + 0.5).method_22913(0.0f, (float)j2 * 0.25f + f3).method_22915(1.0f, 1.0f, 1.0f, f5).method_22916(j3).method_1344();
                        bufferbuilder.method_22912((double)k1 - x + d0 + 0.5, (double)k2 - y, (double)j1 - z + d1 + 0.5).method_22913(1.0f, (float)j2 * 0.25f + f3).method_22915(1.0f, 1.0f, 1.0f, f5).method_22916(j3).method_1344();
                        bufferbuilder.method_22912((double)k1 - x + d0 + 0.5, (double)j2 - y, (double)j1 - z + d1 + 0.5).method_22913(1.0f, (float)k2 * 0.25f + f3).method_22915(1.0f, 1.0f, 1.0f, f5).method_22916(j3).method_1344();
                        bufferbuilder.method_22912((double)k1 - x - d0 + 0.5, (double)j2 - y, (double)j1 - z - d1 + 0.5).method_22913(0.0f, (float)k2 * 0.25f + f3).method_22915(1.0f, 1.0f, 1.0f, f5).method_22916(j3).method_1344();
                        continue;
                    }
                    if (i1 != 1) {
                        if (i1 >= 0) {
                            tesselator.method_1350();
                        }
                        i1 = 1;
                        RenderSystem.setShaderTexture((int)0, (class_2960)SNOW_TEXTURES);
                        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1584);
                    }
                    float f6 = -((float)(rendererUpdateCount & 0x1FF) + ticks) / 512.0f;
                    float f7 = (float)(random.nextDouble() + (double)f1 * 0.01 * (double)((float)random.nextGaussian()));
                    float f8 = (float)(random.nextDouble() + (double)(f1 * (float)random.nextGaussian()) * 0.001);
                    double d3 = (double)k1 + 0.5 - x;
                    double d5 = (double)j1 + 0.5 - z;
                    float f9 = (float)Math.sqrt(d3 * d3 + d5 * d5) / (float)l;
                    float f10 = ((1.0f - f9 * f9) * 0.3f + 0.5f) * f;
                    blockpos$mutableblockpos.method_10103(k1, l2, j1);
                    int k3 = class_761.method_23794((class_1920)level, (class_2338)blockpos$mutableblockpos);
                    int l3 = k3 >> 16 & 0xFFFF;
                    int i4 = k3 & 0xFFFF;
                    int j4 = (l3 * 3 + 240) / 4;
                    int k4 = (i4 * 3 + 240) / 4;
                    bufferbuilder.method_22912((double)k1 - x - d0 + 0.5, (double)k2 - y, (double)j1 - z - d1 + 0.5).method_22913(0.0f + f7, (float)j2 * 0.25f + f6 + f8).method_22915(1.0f, 1.0f, 1.0f, f10).method_22921(k4, j4).method_1344();
                    bufferbuilder.method_22912((double)k1 - x + d0 + 0.5, (double)k2 - y, (double)j1 - z + d1 + 0.5).method_22913(1.0f + f7, (float)j2 * 0.25f + f6 + f8).method_22915(1.0f, 1.0f, 1.0f, f10).method_22921(k4, j4).method_1344();
                    bufferbuilder.method_22912((double)k1 - x + d0 + 0.5, (double)j2 - y, (double)j1 - z + d1 + 0.5).method_22913(1.0f + f7, (float)k2 * 0.25f + f6 + f8).method_22915(1.0f, 1.0f, 1.0f, f10).method_22921(k4, j4).method_1344();
                    bufferbuilder.method_22912((double)k1 - x - d0 + 0.5, (double)j2 - y, (double)j1 - z - d1 + 0.5).method_22913(0.0f + f7, (float)k2 * 0.25f + f6 + f8).method_22915(1.0f, 1.0f, 1.0f, f10).method_22921(k4, j4).method_1344();
                }
            }
            if (i1 >= 0) {
                tesselator.method_1350();
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            lightmap.method_3315();
        }
    }

    private static void renderLockedBiome(float partialTicks, class_638 wc, class_310 mc, class_765 lightmap, double xIn, double yIn, double zIn) {
        if (TFWeatherRenderer.isNearLockedBiome((class_1937)wc, mc.method_1560())) {
            lightmap.method_3316();
            class_1297 entity = mc.method_1560();
            class_638 world = mc.field_1687;
            int x0 = class_3532.method_15357((double)xIn);
            int y0 = class_3532.method_15357((double)yIn);
            int z0 = class_3532.method_15357((double)zIn);
            class_289 tessellator = class_289.method_1348();
            class_287 bufferbuilder = tessellator.method_1349();
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            int range = 5;
            if (class_310.method_1517()) {
                range = 10;
            }
            RenderSystem.depthMask((boolean)class_310.method_29611());
            Enum currentType = null;
            float combinedTicks = (float)rendererUpdateCount + partialTicks;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339();
            for (int z = z0 - range; z <= z0 + range; ++z) {
                block7: for (int x = x0 - range; x <= x0 + range; ++x) {
                    int idx = (z - z0 + 16) * 32 + x - x0 + 16;
                    double rx = (double)rainxs[idx] * 0.5;
                    double ry = (double)rainzs[idx] * 0.5;
                    blockpos$mutableblockpos.method_10103(x, 0, z);
                    class_1959 biome = (class_1959)world.method_23753((class_2338)blockpos$mutableblockpos).comp_349();
                    if (TFGenerationSettings.isBiomeSafeFor(biome, entity)) continue;
                    int groundY = 0;
                    int minY = y0 - range;
                    int maxY = y0 + range;
                    if (minY < groundY) {
                        minY = groundY;
                    }
                    if (maxY < groundY) {
                        maxY = groundY;
                    }
                    int y = Math.max(groundY, y0);
                    if (minY == maxY) continue;
                    random.setSeed((long)x * (long)x * 3121L + (long)x * 45238971L ^ (long)z * (long)z * 418711L + (long)z * 13761L);
                    RenderType nextType = TFWeatherRenderer.getRenderType(biome);
                    if (nextType == null) continue;
                    if (currentType != nextType) {
                        if (currentType != null) {
                            tessellator.method_1350();
                        }
                        currentType = nextType;
                        RenderSystem._setShaderTexture((int)0, (class_2960)nextType.getTextureLocation());
                        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1584);
                    }
                    switch (1.$SwitchMap$twilightforest$client$renderer$TFWeatherRenderer$RenderType[currentType.ordinal()]) {
                        case 1: 
                        case 2: {
                            float d5 = -((float)(rendererUpdateCount + x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0x1F) + partialTicks) / 32.0f * (3.0f + random.nextFloat());
                            double d6 = (double)((float)x + 0.5f) - xIn;
                            double d7 = (double)((float)z + 0.5f) - zIn;
                            float f3 = class_3532.method_15355((float)((float)(d6 * d6 + d7 * d7))) / (float)range;
                            float f4 = (1.0f - f3 * f3) * 0.5f + 0.5f;
                            blockpos$mutableblockpos.method_10103(x, y, z);
                            int j3 = class_761.method_23794((class_1920)world, (class_2338)blockpos$mutableblockpos);
                            int k3 = j3 >> 16 & 0xFFFF;
                            int l3 = j3 & 0xFFFF;
                            bufferbuilder.method_22912((double)x - xIn - rx + 0.5, (double)maxY - yIn, (double)z - zIn - ry + 0.5).method_22913(0.0f, (float)minY * 0.25f + d5).method_22915(1.0f, 1.0f, 1.0f, f4).method_22921(k3, l3).method_1344();
                            bufferbuilder.method_22912((double)x - xIn + rx + 0.5, (double)maxY - yIn, (double)z - zIn + ry + 0.5).method_22913(1.0f, (float)minY * 0.25f + d5).method_22915(1.0f, 1.0f, 1.0f, f4).method_22921(k3, l3).method_1344();
                            bufferbuilder.method_22912((double)x - xIn + rx + 0.5, (double)minY - yIn, (double)z - zIn + ry + 0.5).method_22913(1.0f, (float)maxY * 0.25f + d5).method_22915(1.0f, 1.0f, 1.0f, f4).method_22921(k3, l3).method_1344();
                            bufferbuilder.method_22912((double)x - xIn - rx + 0.5, (double)minY - yIn, (double)z - zIn - ry + 0.5).method_22913(0.0f, (float)maxY * 0.25f + d5).method_22915(1.0f, 1.0f, 1.0f, f4).method_22921(k3, l3).method_1344();
                            continue block7;
                        }
                        case 3: {
                            float d8 = 0.0f;
                            float d9 = random.nextFloat() + combinedTicks * 0.01f * (float)random.nextGaussian();
                            float d10 = random.nextFloat() + combinedTicks * (float)random.nextGaussian() * 0.001f;
                            double d11 = (double)((float)x + 0.5f) - xIn;
                            double d12 = (double)((float)z + 0.5f) - zIn;
                            float f6 = class_3532.method_15355((float)((float)(d11 * d11 + d12 * d12))) / (float)range;
                            float r = random.nextFloat() * 0.3f;
                            float g = random.nextFloat() * 0.3f;
                            float b = random.nextFloat() * 0.3f;
                            float f5 = (1.0f - f6 * f6) * 0.3f + 0.5f;
                            int i4 = 0xF000F0;
                            int j4 = i4 >> 16 & 0xFFFF;
                            int k4 = i4 & 0xFFFF;
                            bufferbuilder.method_22912((double)x - xIn - rx + 0.5, (double)maxY - yIn, (double)z - zIn - ry + 0.5).method_22913(0.0f + d9, (float)minY * 0.25f + d8 + d10).method_22915(r, g, b, f5).method_22921(j4, k4).method_1344();
                            bufferbuilder.method_22912((double)x - xIn + rx + 0.5, (double)maxY - yIn, (double)z - zIn + ry + 0.5).method_22913(1.0f + d9, (float)minY * 0.25f + d8 + d10).method_22915(r, g, b, f5).method_22921(j4, k4).method_1344();
                            bufferbuilder.method_22912((double)x - xIn + rx + 0.5, (double)minY - yIn, (double)z - zIn + ry + 0.5).method_22913(1.0f + d9, (float)maxY * 0.25f + d8 + d10).method_22915(r, g, b, f5).method_22921(j4, k4).method_1344();
                            bufferbuilder.method_22912((double)x - xIn - rx + 0.5, (double)minY - yIn, (double)z - zIn - ry + 0.5).method_22913(0.0f + d9, (float)maxY * 0.25f + d8 + d10).method_22915(r, g, b, f5).method_22921(j4, k4).method_1344();
                            continue block7;
                        }
                        case 4: {
                            float d8 = -((float)(rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                            float d9 = random.nextFloat() + combinedTicks * 0.01f * (float)random.nextGaussian();
                            float d10 = random.nextFloat() + combinedTicks * (float)random.nextGaussian() * 0.001f;
                            double d11 = (double)((float)x + 0.5f) - xIn;
                            double d12 = (double)((float)z + 0.5f) - zIn;
                            float f6 = class_3532.method_15355((float)((float)(d11 * d11 + d12 * d12))) / (float)range;
                            float f5 = (1.0f - f6 * f6) * 0.3f + 0.5f;
                            int i4 = 0xF000F0;
                            int j4 = i4 >> 16 & 0xFFFF;
                            int k4 = i4 & 0xFFFF;
                            float color = random.nextFloat() * 0.2f + 0.8f;
                            bufferbuilder.method_22912((double)x - xIn - rx + 0.5, (double)maxY - yIn, (double)z - zIn - ry + 0.5).method_22913(0.0f + d9, (float)minY * 0.25f + d8 + d10).method_22915(color, color, color, f5).method_22921(j4, k4).method_1344();
                            bufferbuilder.method_22912((double)x - xIn + rx + 0.5, (double)maxY - yIn, (double)z - zIn + ry + 0.5).method_22913(1.0f + d9, (float)minY * 0.25f + d8 + d10).method_22915(color, color, color, f5).method_22921(j4, k4).method_1344();
                            bufferbuilder.method_22912((double)x - xIn + rx + 0.5, (double)minY - yIn, (double)z - zIn + ry + 0.5).method_22913(1.0f + d9, (float)maxY * 0.25f + d8 + d10).method_22915(color, color, color, f5).method_22921(j4, k4).method_1344();
                            bufferbuilder.method_22912((double)x - xIn - rx + 0.5, (double)minY - yIn, (double)z - zIn - ry + 0.5).method_22913(0.0f + d9, (float)maxY * 0.25f + d8 + d10).method_22915(color, color, color, f5).method_22921(j4, k4).method_1344();
                            continue block7;
                        }
                        case 5: {
                            float d8 = -((float)(rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                            float d9 = 0.0f;
                            float d10 = random.nextFloat() + combinedTicks * (float)random.nextGaussian() * 0.001f;
                            double d11 = (double)((float)x + 0.5f) - xIn;
                            double d12 = (double)((float)z + 0.5f) - zIn;
                            float f6 = class_3532.method_15355((float)((float)(d11 * d11 + d12 * d12))) / (float)range;
                            float f5 = ((1.0f - f6 * f6) * 0.3f + 0.5f) * random.nextFloat();
                            int i4 = 0xF000F0;
                            int j4 = i4 >> 16 & 0xFFFF;
                            int k4 = i4 & 0xFFFF;
                            bufferbuilder.method_22912((double)x - xIn - rx + 0.5, (double)maxY - yIn, (double)z - zIn - ry + 0.5).method_22913(0.0f + d9, (float)minY * 0.25f + d8 + d10).method_22915(1.0f, 1.0f, 1.0f, f5).method_22921(j4, k4).method_1344();
                            bufferbuilder.method_22912((double)x - xIn + rx + 0.5, (double)maxY - yIn, (double)z - zIn + ry + 0.5).method_22913(1.0f + d9, (float)minY * 0.25f + d8 + d10).method_22915(1.0f, 1.0f, 1.0f, f5).method_22921(j4, k4).method_1344();
                            bufferbuilder.method_22912((double)x - xIn + rx + 0.5, (double)minY - yIn, (double)z - zIn + ry + 0.5).method_22913(1.0f + d9, (float)maxY * 0.25f + d8 + d10).method_22915(1.0f, 1.0f, 1.0f, f5).method_22921(j4, k4).method_1344();
                            bufferbuilder.method_22912((double)x - xIn - rx + 0.5, (double)minY - yIn, (double)z - zIn - ry + 0.5).method_22913(0.0f + d9, (float)maxY * 0.25f + d8 + d10).method_22915(1.0f, 1.0f, 1.0f, f5).method_22921(j4, k4).method_1344();
                        }
                    }
                }
            }
            if (currentType != null) {
                tessellator.method_1350();
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            lightmap.method_3315();
        }
    }

    private static void renderLockedStructure(float partialTicks, class_310 mc, class_765 lightmap, double xIn, double yIn, double zIn) {
        if (TFWeatherRenderer.isNearLockedStructure(xIn, zIn)) {
            lightmap.method_3316();
            int i = class_3532.method_15357((double)xIn);
            int j = class_3532.method_15357((double)yIn);
            int k = class_3532.method_15357((double)zIn);
            class_289 tessellator = class_289.method_1348();
            class_287 bufferbuilder = tessellator.method_1349();
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            int i1 = 5;
            if (class_310.method_1517()) {
                i1 = 10;
            }
            RenderSystem.depthMask((boolean)class_310.method_29611());
            int j1 = -1;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339();
            for (int k1 = k - i1; k1 <= k + i1; ++k1) {
                for (int l1 = i - i1; l1 <= i + i1; ++l1) {
                    int i2 = (k1 - k + 16) * 32 + l1 - i + 16;
                    double d3 = (double)rainxs[i2] * 0.5;
                    double d4 = (double)rainzs[i2] * 0.5;
                    if (protectedBox == null || !protectedBox.method_14669(l1, k1, l1, k1)) continue;
                    int structureMin = protectedBox.method_35416() - 4;
                    int structureMax = protectedBox.method_35419() + 4;
                    int k2 = j - i1;
                    int l2 = j + i1 * 2;
                    if (k2 < structureMin) {
                        k2 = structureMin;
                    }
                    if (l2 < structureMin) {
                        l2 = structureMin;
                    }
                    if (k2 > structureMax) {
                        k2 = structureMax;
                    }
                    if (l2 > structureMax) {
                        l2 = structureMax;
                    }
                    if (k2 == l2) continue;
                    Random random = new Random((long)l1 * (long)l1 * 3121L + (long)l1 * 45238971L ^ (long)k1 * (long)k1 * 418711L + (long)k1 * 13761L);
                    blockpos$mutableblockpos.method_10103(l1, k2, k1);
                    if (j1 != 0) {
                        if (j1 >= 0) {
                            tessellator.method_1350();
                        }
                        j1 = 0;
                        RenderSystem._setShaderTexture((int)0, (class_2960)SPARKLES_TEXTURE);
                        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1584);
                    }
                    float d5 = -((float)(rendererUpdateCount + l1 * l1 * 3121 + l1 * 45238971 + k1 * k1 * 418711 + k1 * 13761 & 0x1F) + partialTicks) / 32.0f * (3.0f + random.nextFloat());
                    double d6 = (double)((float)l1 + 0.5f) - xIn;
                    double d7 = (double)((float)k1 + 0.5f) - zIn;
                    float f3 = class_3532.method_15355((float)((float)(d6 * d6 + d7 * d7))) / (float)i1;
                    float f = random.nextFloat();
                    float f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * f;
                    int j3 = 0xF000F0;
                    int k3 = j3 >> 16 & 0xFFFF;
                    int l3 = j3 & 0xFFFF;
                    bufferbuilder.method_22912((double)l1 - xIn - d3 + 0.5, (double)l2 - yIn, (double)k1 - zIn - d4 + 0.5).method_22913(0.0f, (float)k2 * 0.25f + d5).method_22915(1.0f, 1.0f, 1.0f, f4).method_22921(k3, l3).method_1344();
                    bufferbuilder.method_22912((double)l1 - xIn + d3 + 0.5, (double)l2 - yIn, (double)k1 - zIn + d4 + 0.5).method_22913(1.0f, (float)k2 * 0.25f + d5).method_22915(1.0f, 1.0f, 1.0f, f4).method_22921(k3, l3).method_1344();
                    bufferbuilder.method_22912((double)l1 - xIn + d3 + 0.5, (double)k2 - yIn, (double)k1 - zIn + d4 + 0.5).method_22913(1.0f, (float)l2 * 0.25f + d5).method_22915(1.0f, 1.0f, 1.0f, f4).method_22921(k3, l3).method_1344();
                    bufferbuilder.method_22912((double)l1 - xIn - d3 + 0.5, (double)k2 - yIn, (double)k1 - zIn - d4 + 0.5).method_22913(0.0f, (float)l2 * 0.25f + d5).method_22915(1.0f, 1.0f, 1.0f, f4).method_22921(k3, l3).method_1344();
                }
            }
            if (j1 >= 0) {
                tessellator.method_1350();
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            lightmap.method_3315();
        }
    }

    private static boolean isNearLockedBiome(class_1937 world, class_1297 viewEntity) {
        class_2338.class_2339 pos = new class_2338.class_2339();
        int range = 15;
        int px = class_3532.method_15357((double)viewEntity.method_23317());
        int pz = class_3532.method_15357((double)viewEntity.method_23321());
        for (int z = pz - 15; z <= pz + 15; ++z) {
            for (int x = px - 15; x <= px + 15; ++x) {
                class_1959 biome = (class_1959)world.method_23753((class_2338)pos.method_10103(x, 0, z)).comp_349();
                if (TFGenerationSettings.isBiomeSafeFor(biome, viewEntity)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isNearLockedStructure(double xIn, double zIn) {
        int range = 15;
        int px = class_3532.method_15357((double)xIn);
        int pz = class_3532.method_15357((double)zIn);
        return protectedBox != null && protectedBox.method_14669(px - 15, pz - 15, px + 15, pz + 15);
    }

    public static void setProtectedBox(class_3341 protectedBox) {
        TFWeatherRenderer.protectedBox = protectedBox;
    }

    private static RenderType getRenderType(class_1959 b) {
        if (class_310.method_1551().field_1687 == null) {
            return null;
        }
        class_2960 biome = class_310.method_1551().field_1687.method_30349().method_30530(class_2378.field_25114).method_10221((Object)b);
        if (BiomeKeys.SNOWY_FOREST.method_29177().equals((Object)biome) || BiomeKeys.GLACIER.method_29177().equals((Object)biome)) {
            return RenderType.BLIZZARD;
        }
        if (BiomeKeys.SWAMP.method_29177().equals((Object)biome)) {
            return RenderType.MOSQUITO;
        }
        if (BiomeKeys.FIRE_SWAMP.method_29177().equals((Object)biome)) {
            return RenderType.ASHES;
        }
        if (BiomeKeys.DARK_FOREST.method_29177().equals((Object)biome) || BiomeKeys.DARK_FOREST_CENTER.method_29177().equals((Object)biome)) {
            return random.nextInt(2) == 0 ? RenderType.DARK_STREAM : null;
        }
        if (BiomeKeys.HIGHLANDS.method_29177().equals((Object)biome) || BiomeKeys.THORNLANDS.method_29177().equals((Object)biome) || BiomeKeys.FINAL_PLATEAU.method_29177().equals((Object)biome)) {
            return RenderType.BIG_RAIN;
        }
        return null;
    }

    static {
        random = new Random();
    }

    private static enum RenderType {
        BLIZZARD("blizzard.png"),
        MOSQUITO("mosquitoes.png"),
        ASHES("ashes.png"),
        DARK_STREAM("darkstream.png"),
        BIG_RAIN("bigrain.png");

        private final class_2960 textureLocation;

        private RenderType(String textureName) {
            this.textureLocation = TwilightForestMod.getEnvTexture(textureName);
        }

        public class_2960 getTextureLocation() {
            return this.textureLocation;
        }
    }
}

