/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.tileentity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_5614;
import net.minecraft.class_809;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.block.AbstractTrophyBlock;
import twilightforest.block.TrophyBlock;
import twilightforest.block.TrophyWallBlock;
import twilightforest.block.entity.TrophyBlockEntity;
import twilightforest.client.model.TFModelLayers;
import twilightforest.client.model.tileentity.AlphaYetiTrophyModel;
import twilightforest.client.model.tileentity.GenericTrophyModel;
import twilightforest.client.model.tileentity.HydraTrophyModel;
import twilightforest.client.model.tileentity.KnightPhantomTrophyModel;
import twilightforest.client.model.tileentity.LichTrophyModel;
import twilightforest.client.model.tileentity.MinoshroomTrophyModel;
import twilightforest.client.model.tileentity.NagaTrophyModel;
import twilightforest.client.model.tileentity.QuestRamTrophyModel;
import twilightforest.client.model.tileentity.SnowQueenTrophyModel;
import twilightforest.client.model.tileentity.UrGhastTrophyModel;
import twilightforest.client.model.tileentity.legacy.HydraTrophyLegacyModel;
import twilightforest.client.model.tileentity.legacy.MinoshroomTrophyLegacyModel;
import twilightforest.client.model.tileentity.legacy.QuestRamTrophyLegacyModel;
import twilightforest.client.model.tileentity.legacy.SnowQueenTrophyLegacyModel;
import twilightforest.enums.BossVariant;
import twilightforest.init.TFBlocks;

public class TrophyTileEntityRenderer
implements class_827<TrophyBlockEntity> {
    private final Map<BossVariant, GenericTrophyModel> trophies;
    private static final class_2960 textureLocHydra = TwilightForestMod.getModelTexture("hydra4.png");
    private static final class_2960 textureLocNaga = TwilightForestMod.getModelTexture("nagahead.png");
    private static final class_2960 textureLocLich = TwilightForestMod.getModelTexture("twilightlich64.png");
    private static final class_2960 textureLocUrGhast = TwilightForestMod.getModelTexture("towerboss.png");
    private static final class_2960 textureLocSnowQueen = TwilightForestMod.getModelTexture("snowqueen.png");
    private static final class_2960 textureLocMinoshroom = TwilightForestMod.getModelTexture("minoshroomtaur.png");
    private static final class_2960 textureLocKnightPhantom = TwilightForestMod.getModelTexture("phantomskeleton.png");
    private static final class_2960 textureLocKnightPhantomArmor = new class_2960("twilightforest:textures/armor/phantom_1.png");
    private static final class_2960 textureLocYeti = TwilightForestMod.getModelTexture("yetialpha.png");
    private static final class_2960 textureLocQuestRam = TwilightForestMod.getModelTexture("questram.png");
    private static final class_2960 textureLocQuestRamLines = TwilightForestMod.getModelTexture("questram_lines.png");
    public static class_1799 stack = new class_1799((class_1935)TFBlocks.NAGA_TROPHY.get());

    public TrophyTileEntityRenderer(class_5614.class_5615 renderer) {
        this.trophies = TrophyTileEntityRenderer.createTrophyRenderers(renderer.method_32142());
    }

    public static Map<BossVariant, GenericTrophyModel> createTrophyRenderers(class_5599 set) {
        BooleanSupplier legacy = () -> class_310.method_1551().method_1520().method_29210().contains("builtin/twilight_forest_legacy_resources");
        ImmutableMap.Builder trophyList = ImmutableMap.builder();
        trophyList.put((Object)BossVariant.NAGA, (Object)new NagaTrophyModel(set.method_32072(TFModelLayers.NAGA_TROPHY)));
        trophyList.put((Object)BossVariant.LICH, (Object)new LichTrophyModel(set.method_32072(TFModelLayers.LICH_TROPHY)));
        trophyList.put((Object)BossVariant.MINOSHROOM, (Object)(legacy.getAsBoolean() ? new MinoshroomTrophyLegacyModel(set.method_32072(TFModelLayers.LEGACY_MINOSHROOM_TROPHY)) : new MinoshroomTrophyModel(set.method_32072(TFModelLayers.MINOSHROOM_TROPHY))));
        trophyList.put((Object)BossVariant.HYDRA, (Object)(legacy.getAsBoolean() ? new HydraTrophyLegacyModel(set.method_32072(TFModelLayers.LEGACY_HYDRA_TROPHY)) : new HydraTrophyModel(set.method_32072(TFModelLayers.HYDRA_TROPHY))));
        trophyList.put((Object)BossVariant.KNIGHT_PHANTOM, (Object)new KnightPhantomTrophyModel(set.method_32072(TFModelLayers.KNIGHT_PHANTOM_TROPHY)));
        trophyList.put((Object)BossVariant.UR_GHAST, (Object)new UrGhastTrophyModel(set.method_32072(TFModelLayers.UR_GHAST_TROPHY)));
        trophyList.put((Object)BossVariant.ALPHA_YETI, (Object)new AlphaYetiTrophyModel(set.method_32072(TFModelLayers.ALPHA_YETI_TROPHY)));
        trophyList.put((Object)BossVariant.SNOW_QUEEN, (Object)(legacy.getAsBoolean() ? new SnowQueenTrophyLegacyModel(set.method_32072(TFModelLayers.LEGACY_SNOW_QUEEN_TROPHY)) : new SnowQueenTrophyModel(set.method_32072(TFModelLayers.SNOW_QUEEN_TROPHY))));
        trophyList.put((Object)BossVariant.QUEST_RAM, (Object)(legacy.getAsBoolean() ? new QuestRamTrophyLegacyModel(set.method_32072(TFModelLayers.LEGACY_QUEST_RAM_TROPHY)) : new QuestRamTrophyModel(set.method_32072(TFModelLayers.QUEST_RAM_TROPHY))));
        return trophyList.build();
    }

    public void render(TrophyBlockEntity tileEntityIn, float partialTicks, class_4587 matrixStackIn, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float f = tileEntityIn.getAnimationProgress(partialTicks);
        class_2680 blockstate = tileEntityIn.method_11010();
        boolean flag = blockstate.method_26204() instanceof TrophyWallBlock;
        class_2350 direction = flag ? (class_2350)blockstate.method_11654((class_2769)TrophyWallBlock.FACING) : null;
        float f1 = 22.5f * (float)(flag ? (2 + direction.method_10161()) * 4 : (Integer)blockstate.method_11654((class_2769)TrophyBlock.ROTATION));
        BossVariant variant = ((AbstractTrophyBlock)blockstate.method_26204()).getVariant();
        GenericTrophyModel trophy = this.trophies.get((Object)variant);
        matrixStackIn.method_22903();
        if (variant == BossVariant.HYDRA) {
            trophy.openMouthForTrophy(flag ? 0.5f : 0.0f);
        }
        if (variant == BossVariant.UR_GHAST) {
            ((UrGhastTrophyModel)trophy).setTranslate(matrixStackIn, 0.0f, 1.0f, 0.0f);
        }
        TrophyTileEntityRenderer.render(direction, f1, trophy, variant, f, matrixStackIn, bufferIn, combinedLightIn, class_809.class_811.field_4315);
        matrixStackIn.method_22909();
    }

    public static void render(@Nullable class_2350 directionIn, float y, GenericTrophyModel trophy, BossVariant variant, float animationProgress, class_4587 matrixStackIn, class_4597 buffer, int combinedLight, class_809.class_811 camera) {
        BooleanSupplier legacy = () -> class_310.method_1551().method_1520().method_29210().contains("builtin/twilight_forest_legacy_resources");
        matrixStackIn.method_22903();
        if (directionIn == null || variant == BossVariant.UR_GHAST) {
            matrixStackIn.method_22904(0.5, 0.01, 0.5);
        } else {
            matrixStackIn.method_22904((double)(0.5f - (float)directionIn.method_10148() * 0.249f), 0.25, (double)(0.5f - (float)directionIn.method_10165() * 0.249f));
        }
        matrixStackIn.method_22905(-1.0f, -1.0f, 1.0f);
        switch (variant) {
            case HYDRA: {
                matrixStackIn.method_22905(0.25f, 0.25f, 0.25f);
                if (camera == class_809.class_811.field_4317) {
                    trophy.openMouthForTrophy(0.35f);
                }
                trophy.setRotations(animationProgress * 4.5f, y, 0.0f);
                matrixStackIn.method_22904(legacy.getAsBoolean() ? 1.0 : 0.0, legacy.getAsBoolean() ? (double)-1.15f : -1.0, 0.0);
                class_4588 hydraVertex = buffer.getBuffer(class_1921.method_23578((class_2960)textureLocHydra));
                trophy.method_2828(matrixStackIn, hydraVertex, combinedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case NAGA: {
                matrixStackIn.method_22905(0.5f, 0.5f, 0.5f);
                trophy.setRotations(animationProgress * 4.5f, y, 0.0f);
                matrixStackIn.method_22904(0.0, 0.25, 0.0);
                class_4588 nagaVertex = buffer.getBuffer(class_1921.method_23578((class_2960)textureLocNaga));
                trophy.method_2828(matrixStackIn, nagaVertex, combinedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case LICH: {
                matrixStackIn.method_22904(0.0, 0.25, 0.0);
                trophy.setRotations(animationProgress * 4.5f, y, 0.0f);
                class_4588 lichVertex = buffer.getBuffer(class_1921.method_23578((class_2960)textureLocLich));
                trophy.method_2828(matrixStackIn, lichVertex, combinedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case UR_GHAST: {
                matrixStackIn.method_22905(0.5f, 0.5f, 0.5f);
                trophy.setRotations(animationProgress * 4.5f, y, 0.0f);
                class_4588 ghastVertex = buffer.getBuffer(class_1921.method_23578((class_2960)textureLocUrGhast));
                trophy.method_2828(matrixStackIn, ghastVertex, combinedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case SNOW_QUEEN: {
                trophy.setRotations(animationProgress * 4.5f, y, 0.0f);
                matrixStackIn.method_22904(0.0, legacy.getAsBoolean() ? 0.25 : 0.0, 0.0);
                class_4588 waifuVertex = buffer.getBuffer(class_1921.method_23578((class_2960)textureLocSnowQueen));
                trophy.method_2828(matrixStackIn, waifuVertex, combinedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case MINOSHROOM: {
                trophy.setRotations(animationProgress * 4.5f, y, 0.0f);
                matrixStackIn.method_22904(0.0, legacy.getAsBoolean() ? (double)0.12f : (double)0.065f, legacy.getAsBoolean() ? (double)0.56f : 0.0);
                class_4588 minoVertex = buffer.getBuffer(class_1921.method_23578((class_2960)textureLocMinoshroom));
                trophy.method_2828(matrixStackIn, minoVertex, combinedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case KNIGHT_PHANTOM: {
                trophy.setRotations(animationProgress * 4.5f, y, 0.0f);
                matrixStackIn.method_22904(0.0, 0.25, 0.0);
                class_4588 phantomVertex = buffer.getBuffer(class_1921.method_23578((class_2960)textureLocKnightPhantom));
                trophy.method_2828(matrixStackIn, phantomVertex, combinedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                matrixStackIn.method_22905(1.1f, 1.1f, 1.1f);
                matrixStackIn.method_22904(0.0, (double)0.05f, 0.0);
                trophy.setRotations(animationProgress * 4.5f, y, 0.0f);
                class_4588 phantomArmorVertex = buffer.getBuffer(class_1921.method_23578((class_2960)textureLocKnightPhantomArmor));
                trophy.renderHelmToBuffer(matrixStackIn, phantomArmorVertex, combinedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 0.0625f);
                break;
            }
            case ALPHA_YETI: {
                matrixStackIn.method_22905(0.2f, 0.2f, 0.2f);
                trophy.setRotations(animationProgress * 4.5f, y, 0.0f);
                matrixStackIn.method_22904(0.0, -1.5, 0.0);
                class_4588 yetiVertex = buffer.getBuffer(class_1921.method_23578((class_2960)textureLocYeti));
                trophy.method_2828(matrixStackIn, yetiVertex, combinedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case QUEST_RAM: {
                matrixStackIn.method_22905(0.7f, 0.7f, 0.7f);
                trophy.setRotations(animationProgress * 4.5f, y, 0.0f);
                class_4588 ramVertex = buffer.getBuffer(class_1921.method_23578((class_2960)textureLocQuestRam));
                trophy.method_2828(matrixStackIn, ramVertex, combinedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
        }
        matrixStackIn.method_22909();
    }
}

