/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.rei.entries;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import io.github.fabricators_of_create.porting_lib.entity.MultiPartEntity;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.AbstractEntryRenderer;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1087;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_809;
import net.minecraft.class_898;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.compat.rei.entries.EntityTypeComparatorRegistryImpl;

public class EntityEntryDefinition
implements EntryDefinition<class_1297>,
EntrySerializer<class_1297> {
    public static EntryType<class_1297> ENTITY_TYPE = EntryType.deferred((class_2960)new class_2960("entity"));
    @Environment(value=EnvType.CLIENT)
    private EntryRenderer<class_1297> renderer;
    private static final ReferenceSet<class_1299<class_1297>> SEARCH_BLACKLISTED = new ReferenceOpenHashSet();

    public EntityEntryDefinition() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> Client.init(this));
    }

    public Class<class_1297> getValueType() {
        return class_1297.class;
    }

    public EntryType<class_1297> getType() {
        return ENTITY_TYPE;
    }

    @Environment(value=EnvType.CLIENT)
    public EntryRenderer<class_1297> getRenderer() {
        return this.renderer;
    }

    @Nullable
    public class_2960 getIdentifier(EntryStack<class_1297> entry, class_1297 value) {
        return class_2378.field_11145.method_10221((Object)value.method_5864());
    }

    public boolean isEmpty(EntryStack<class_1297> entry, class_1297 value) {
        return false;
    }

    public class_1297 copy(EntryStack<class_1297> entry, class_1297 value) {
        class_2487 tag = new class_2487();
        String string = value.method_5653();
        if (string != null) {
            tag.method_10582("id", string);
            value.method_5647(tag);
        }
        class_1297 entity = value.method_5864().method_5883((class_1937)class_310.method_1551().field_1687);
        entity.method_5651(tag);
        return entity;
    }

    public class_1297 normalize(EntryStack<class_1297> entry, class_1297 value) {
        return this.copy(entry, value);
    }

    public class_1297 wildcard(EntryStack<class_1297> entry, class_1297 value) {
        return value.method_5864().method_5883((class_1937)class_310.method_1551().field_1687);
    }

    public long hash(EntryStack<class_1297> entry, class_1297 value, ComparisonContext context) {
        int code = 1;
        code = 31 * code + System.identityHashCode(value.method_5864());
        code = 31 * code + Long.hashCode(EntityTypeComparatorRegistryImpl.INSTANCE.hashOf(context, value));
        return code;
    }

    public boolean equals(class_1297 o1, class_1297 o2, ComparisonContext context) {
        if (o1.method_5864() != o2.method_5864()) {
            return false;
        }
        return EntityTypeComparatorRegistryImpl.INSTANCE.hashOf(context, o1) == EntityTypeComparatorRegistryImpl.INSTANCE.hashOf(context, o2);
    }

    @Nullable
    public EntrySerializer<class_1297> getSerializer() {
        return null;
    }

    public class_2561 asFormattedText(EntryStack<class_1297> entry, class_1297 value) {
        return this.asFormattedText(entry, value, TooltipContext.of());
    }

    public class_2561 asFormattedText(EntryStack<class_1297> entry, class_1297 value, TooltipContext context) {
        if (!SEARCH_BLACKLISTED.contains((Object)value.method_5864())) {
            try {
                return value.method_5477();
            }
            catch (Throwable e) {
                if (context != null && context.isSearch()) {
                    throw e;
                }
                e.printStackTrace();
                SEARCH_BLACKLISTED.add((Object)value.method_5864());
            }
        }
        try {
            return class_2561.method_43470((String)class_1074.method_4662((String)("entity." + class_2378.field_11145.method_10221((Object)value.method_5864()).toString().replace(":", ".")), (Object[])new Object[0]));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return class_2561.method_43470((String)"ERROR");
        }
    }

    @Environment(value=EnvType.CLIENT)
    private List<class_2561> tryGetEntityToolTip(EntryStack<class_1297> entry, class_1297 value, TooltipContext context) {
        if (!SEARCH_BLACKLISTED.contains((Object)value.method_5864())) {
            try {
                return Lists.newArrayList((Object[])new class_2561[]{value.method_5477()});
            }
            catch (Throwable e) {
                if (context.isSearch()) {
                    throw e;
                }
                e.printStackTrace();
                SEARCH_BLACKLISTED.add((Object)value.method_5864());
            }
        }
        return Lists.newArrayList((Object[])new class_2561[]{this.asFormattedText(entry, value, context)});
    }

    public Stream<? extends class_6862<?>> getTagsFor(EntryStack<class_1297> entry, class_1297 value) {
        return value.method_5864().method_40124().method_40228();
    }

    public boolean supportSaving() {
        return true;
    }

    public boolean supportReading() {
        return true;
    }

    public class_2487 save(EntryStack<class_1297> entry, class_1297 value) {
        class_2487 tag = new class_2487();
        String string = value.method_5653();
        if (string != null) {
            tag.method_10582("id", string);
            value.method_5647(tag);
        }
        return tag;
    }

    public class_1297 read(class_2487 tag) {
        return (class_1297)class_1299.method_5892((class_2487)tag, (class_1937)class_310.method_1551().field_1687).get();
    }

    @Environment(value=EnvType.CLIENT)
    private static class Client {
        private Client() {
        }

        private static void init(EntityEntryDefinition definition) {
            definition.renderer = definition.new EntityEntryRenderer();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ItemEntityRender
    extends AbstractEntryRenderer<class_1297> {
        private final float bobOffs = class_5819.method_43047().method_43057() * (float)Math.PI * 2.0f;

        public void render(EntryStack<class_1297> entry, class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
            class_1799 item = ((class_1542)entry.getValue()).method_6983();
            if (!entry.isEmpty()) {
                class_638 level = class_310.method_1551().field_1687;
                matrices.method_22903();
                matrices.method_22904((double)bounds.x, (double)bounds.y, 0.0);
                if (item != null && level != null) {
                    class_4587 modelView = RenderSystem.getModelViewStack();
                    modelView.method_22903();
                    modelView.method_34425(matrices.method_23760().method_23761());
                    try {
                        this.renderItemEntity((class_1542)entry.getValue(), item, (class_1937)level, delta);
                    }
                    catch (Exception e) {
                        TwilightForestMod.LOGGER.error("Error drawing item in REI!", (Throwable)e);
                    }
                    modelView.method_22909();
                    RenderSystem.applyModelViewMatrix();
                }
                matrices.method_22909();
            }
        }

        @Nullable
        public Tooltip getTooltip(EntryStack<class_1297> entry, TooltipContext context) {
            class_1799 item = ((class_1542)entry.getValue()).method_6983();
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(item.method_7909().method_7848());
            if (context.getFlag().method_8035()) {
                tooltip.add(class_2561.method_43470((String)Objects.requireNonNull(class_2378.field_11142.method_10221((Object)item.method_7909())).toString()).method_27692(class_124.field_1063));
            }
            return Tooltip.create((Point)context.getPoint(), tooltip);
        }

        private void renderItemEntity(class_1542 item, class_1799 stack, class_1937 level, float delta) {
            class_4587 posestack = RenderSystem.getModelViewStack();
            posestack.method_22903();
            posestack.method_22904(16.0, 32.0, 1050.0);
            posestack.method_22905(1.0f, 1.0f, -1.0f);
            RenderSystem.applyModelViewMatrix();
            class_4587 posestack1 = new class_4587();
            posestack1.method_22904(0.0, 0.0, 1000.0);
            posestack1.method_22905(50.0f, 50.0f, 50.0f);
            class_1158 quaternion = class_1160.field_20707.method_23214(180.0f);
            class_1158 quaternion1 = class_1160.field_20703.method_23214(20.0f);
            quaternion.method_4925(quaternion1);
            posestack1.method_22907(quaternion);
            posestack1.method_22907(class_1160.field_20702.method_23214(35.0f));
            posestack1.method_22907(class_1160.field_20704.method_23214(145.0f));
            class_308.method_34742();
            quaternion1.method_4926();
            class_4597.class_4598 buffer = class_310.method_1551().method_22940().method_23000();
            Objects.requireNonNull(item).method_6979(stack);
            RenderSystem.runAsFancy(() -> this.render(item, delta, posestack1, (class_4597)buffer, 0xF000F0));
            buffer.method_22993();
            posestack.method_22909();
            RenderSystem.applyModelViewMatrix();
            class_308.method_24211();
        }

        public void render(class_1542 entity, float partialTicks, class_4587 stack, class_4597 buffer, int light) {
            stack.method_22903();
            class_1799 itemstack = entity.method_6983();
            class_1087 bakedmodel = class_310.method_1551().method_1480().method_4019(itemstack, entity.method_37908(), null, entity.method_5628());
            float f1 = class_3532.method_15374((float)(((float)Objects.requireNonNull(class_310.method_1551().field_1687).method_8510() + partialTicks) / 10.0f + this.bobOffs)) * 0.1f + 0.1f;
            float f2 = bakedmodel.method_4709().method_3503((class_809.class_811)class_809.class_811.field_4318).field_4285.method_4945();
            stack.method_22904(0.0, (double)(f1 + 0.25f * f2), 0.0);
            float f3 = this.getSpin(partialTicks);
            stack.method_22907(class_1160.field_20705.method_23626(f3));
            stack.method_22903();
            class_310.method_1551().method_1480().method_23179(itemstack, class_809.class_811.field_4318, false, stack, buffer, light, class_4608.field_21444, bakedmodel);
            stack.method_22909();
            stack.method_22909();
        }

        public float getSpin(float pPartialTicks) {
            return ((float)Objects.requireNonNull(class_310.method_1551().field_1687).method_8510() + pPartialTicks) / 20.0f + this.bobOffs;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class EntityEntryRenderer
    extends AbstractEntryRenderer<class_1297> {
        public int size = 32;

        public void render(EntryStack<class_1297> entry, class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
            class_1297 entity = (class_1297)entry.getValue();
            if (!entry.isEmpty()) {
                int scale = this.size / 2;
                float height = entity.method_17682();
                float width = entity.method_17681();
                if (height > 2.25f || width > 2.25f) {
                    scale = (int)(20.0f / Math.max(height, width));
                }
                matrices.method_22903();
                matrices.method_22904((double)bounds.getX(), (double)bounds.getY(), (double)entry.getZ());
                class_4587 modelView = RenderSystem.getModelViewStack();
                modelView.method_22903();
                modelView.method_34425(matrices.method_23760().method_23761());
                try {
                    this.renderTheEntity(this.size / 2, this.size - 2, scale, (class_1309)entity);
                }
                catch (Exception e) {
                    TwilightForestMod.LOGGER.error("Error drawing entity " + class_2378.field_11145.method_10221((Object)entity.method_5864()), (Throwable)e);
                }
                modelView.method_22909();
                RenderSystem.applyModelViewMatrix();
                matrices.method_22909();
            }
        }

        private void renderTheEntity(int x, int y, int scale, class_1309 entity) {
            class_4587 posestack = RenderSystem.getModelViewStack();
            posestack.method_22903();
            posestack.method_22904((double)x, (double)y, 1050.0);
            if (entity.method_5864() == class_1299.field_6107) {
                posestack.method_22904(0.0, -8.5, 0.0);
            }
            posestack.method_22905(1.0f, 1.0f, -1.0f);
            RenderSystem.applyModelViewMatrix();
            class_4587 posestack1 = new class_4587();
            posestack1.method_22904(0.0, 0.0, 1000.0);
            posestack1.method_22905((float)scale, (float)scale, (float)scale);
            class_1158 quaternion = class_1160.field_20707.method_23214(180.0f);
            class_1158 quaternion1 = class_1160.field_20703.method_23214(20.0f);
            quaternion.method_4925(quaternion1);
            posestack1.method_22907(quaternion);
            posestack1.method_22907(class_1160.field_20702.method_23214(35.0f));
            posestack1.method_22907(class_1160.field_20704.method_23214(145.0f));
            float f2 = entity.field_6283;
            float f3 = entity.method_36454();
            float f4 = entity.method_36455();
            float f5 = entity.field_6259;
            float f6 = entity.field_6241;
            entity.field_6283 = 0.0f;
            entity.method_36456(0.0f);
            entity.method_36457(0.0f);
            entity.field_6241 = entity.method_36454();
            entity.field_6259 = entity.method_36454();
            class_308.method_34742();
            class_898 entityrenderdispatcher = class_310.method_1551().method_1561();
            quaternion1.method_4926();
            entityrenderdispatcher.method_24196(quaternion1);
            entityrenderdispatcher.method_3948(false);
            class_4597.class_4598 multibuffersource$buffersource = class_310.method_1551().method_22940().method_23000();
            RenderSystem.runAsFancy(() -> {
                MultiPartEntity multiPartEntity;
                entityrenderdispatcher.method_3954((class_1297)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, posestack1, (class_4597)multibuffersource$buffersource, 0xF000F0);
                if (entity instanceof MultiPartEntity && (multiPartEntity = (MultiPartEntity)entity).isMultipartEntity()) {
                    Arrays.stream(multiPartEntity.getParts()).filter(Objects::nonNull).forEach(partEntity -> entityrenderdispatcher.method_3954((class_1297)partEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, posestack1, (class_4597)multibuffersource$buffersource, 0xF000F0));
                }
            });
            multibuffersource$buffersource.method_22993();
            entityrenderdispatcher.method_3948(true);
            entity.field_6283 = f2;
            entity.method_36456(f3);
            entity.method_36457(f4);
            entity.field_6259 = f5;
            entity.field_6241 = f6;
            posestack.method_22909();
            RenderSystem.applyModelViewMatrix();
            class_308.method_24211();
        }

        @Nullable
        public Tooltip getTooltip(EntryStack<class_1297> entry, TooltipContext context) {
            if (entry.isEmpty()) {
                return null;
            }
            class_1299 entity = ((class_1297)entry.getValue()).method_5864();
            Tooltip tooltip = Tooltip.create((class_2561[])new class_2561[0]);
            List<class_2561> components = EntityEntryDefinition.this.tryGetEntityToolTip(entry, (class_1297)entry.getValue(), context);
            if (context.getFlag().method_8035()) {
                components.add((class_2561)class_2561.method_43470((String)Objects.requireNonNull(class_2378.field_11145.method_10221((Object)entity)).toString()).method_27692(class_124.field_1063));
            }
            if (!components.isEmpty()) {
                tooltip.addAll(new class_2561[]{components.get(0)});
            }
            for (int i = 1; i < components.size(); ++i) {
                tooltip.add(components.get(i));
            }
            return tooltip;
        }
    }
}

