/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import io.github.fabricators_of_create.porting_lib.entity.MultiPartEntity;
import io.github.fabricators_of_create.porting_lib.entity.PartEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.pepperbell.simplenetworking.S2CPacket;
import net.minecraft.class_1259;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1322;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1370;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3614;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5532;
import org.jetbrains.annotations.Nullable;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFChestBlock;
import twilightforest.entity.EnforcedHomePoint;
import twilightforest.entity.TFPart;
import twilightforest.entity.ai.control.NagaMoveControl;
import twilightforest.entity.ai.goal.NagaAttackGoal;
import twilightforest.entity.ai.goal.NagaMovementPattern;
import twilightforest.entity.ai.goal.NagaSmashGoal;
import twilightforest.entity.boss.NagaSegment;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFSounds;
import twilightforest.loot.TFLootTables;
import twilightforest.network.TFPacketHandler;
import twilightforest.network.ThrowPlayerPacket;
import twilightforest.util.EntityUtil;
import twilightforest.world.registration.TFGenerationSettings;

public class Naga
extends class_1588
implements EnforcedHomePoint,
MultiPartEntity {
    private static final int TICKS_BEFORE_HEALING = 600;
    private static final int MAX_SEGMENTS = 12;
    private static final int LEASH_X = 46;
    private static final int LEASH_Y = 7;
    private static final int LEASH_Z = 46;
    private static final double DEFAULT_SPEED = 0.3;
    private int currentSegmentCount = 0;
    private final float healthPerSegment;
    private final NagaSegment[] bodySegments = new NagaSegment[12];
    private NagaMovementPattern movementAI;
    private int ticksSinceDamaged = 0;
    private final List<class_3222> hurtBy = new ArrayList<class_3222>();
    private final class_3213 bossInfo = new class_3213(this.method_5476(), class_1259.class_1260.field_5785, class_1259.class_1261.field_5791);
    private final class_1322 slowSpeed = new class_1322("Naga Slow Speed", 0.25, class_1322.class_1323.field_6328);
    private final class_1322 fastSpeed = new class_1322("Naga Fast Speed", 0.5, class_1322.class_1323.field_6328);
    private static final class_2940<Boolean> DATA_DAZE = class_2945.method_12791(Naga.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_CHARGE = class_2945.method_12791(Naga.class, (class_2941)class_2943.field_13323);

    public Naga(class_1299<? extends Naga> type, class_1937 level) {
        super(type, level);
        this.field_6013 = this.getStepHeight();
        this.field_6194 = 217;
        this.field_5985 = true;
        for (int i = 0; i < this.bodySegments.length; ++i) {
            this.bodySegments[i] = new NagaSegment(this);
        }
        this.goNormal();
        if (this.method_37908().method_8407() != class_1267.field_5802 && this.method_5996(class_5134.field_23716) != null) {
            boolean hard = this.field_6002.method_8407() == class_1267.field_5807;
            Objects.requireNonNull(this.method_5996(class_5134.field_23716)).method_26837(new class_1322("Difficulty Health Boost", hard ? 130.0 : 80.0, class_1322.class_1323.field_6328));
            this.method_6033(this.method_6063());
        }
        this.healthPerSegment = this.method_6063() / 10.0f;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_DAZE, (Object)false);
        this.field_6011.method_12784(DATA_CHARGE, (Object)false);
    }

    public boolean isDazed() {
        return (Boolean)this.field_6011.method_12789(DATA_DAZE);
    }

    public void setDazed(boolean daze) {
        this.field_6011.method_12778(DATA_DAZE, (Object)daze);
    }

    public boolean isCharging() {
        return (Boolean)this.field_6011.method_12789(DATA_CHARGE);
    }

    public void setCharging(boolean charge) {
        this.field_6011.method_12778(DATA_CHARGE, (Object)charge);
    }

    public NagaMovementPattern getMovementAI() {
        return this.movementAI;
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new NagaAttackGoal(this));
        this.field_6201.method_6277(3, (class_1352)new NagaSmashGoal(this));
        this.movementAI = new NagaMovementPattern(this);
        this.field_6201.method_6277(4, (class_1352)this.movementAI);
        this.field_6201.method_6277(5, (class_1352)new class_1370((class_1314)this, 1.0){

            public void method_6269() {
                Naga.this.method_5980(null);
                super.method_6269();
            }
        });
        this.field_6201.method_6277(8, (class_1352)new class_1379((class_1314)this, 1.0, 1){

            public void method_6269() {
                Naga.this.goNormal();
                super.method_6269();
            }

            protected class_243 method_6302() {
                return class_5532.method_31510((class_1314)this.field_6566, (int)30, (int)7);
            }
        });
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400<class_1657>((class_1308)this, class_1657.class, false){

            public boolean method_6264() {
                return Naga.this.method_18407(Naga.this.method_24515()) && super.method_6264();
            }
        });
        this.field_6207 = new NagaMoveControl(this);
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_37908().method_8608() || !this.method_37908().method_8450().method_8355(class_1928.field_19388)) {
            return;
        }
        class_238 bb = this.method_5829();
        int minx = class_3532.method_15357((double)(bb.field_1323 - 0.75));
        int miny = class_3532.method_15357((double)(bb.field_1322 + 1.01));
        int minz = class_3532.method_15357((double)(bb.field_1321 - 0.75));
        int maxx = class_3532.method_15357((double)(bb.field_1320 + 0.75));
        int maxy = class_3532.method_15357((double)(bb.field_1325 + 0.0));
        int maxz = class_3532.method_15357((double)(bb.field_1324 + 0.75));
        class_2338 min = new class_2338(minx, miny, minz);
        class_2338 max = new class_2338(maxx, maxy, maxz);
        if (this.method_37908().method_22343(min, max)) {
            for (class_2338 pos : class_2338.method_10097((class_2338)min, (class_2338)max)) {
                class_2680 state = this.method_37908().method_8320(pos);
                if (state.method_26207() != class_3614.field_15923 || !EntityUtil.canDestroyBlock(this.method_37908(), pos, state, (class_1297)this)) continue;
                this.method_37908().method_22352(pos, true);
            }
        }
    }

    public static class_5132.class_5133 registerAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 120.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23717, 80.0).method_26868(class_5134.field_23718, 0.25);
    }

    private void setSegmentsPerHealth() {
        int newSegments;
        int oldSegments = this.currentSegmentCount;
        this.currentSegmentCount = newSegments = class_3532.method_15340((int)((int)(this.method_6032() / this.healthPerSegment + (float)(this.method_6032() > 0.0f ? 2 : 0))), (int)0, (int)12);
        if (newSegments < oldSegments) {
            for (int i = newSegments; i < oldSegments; ++i) {
                this.bodySegments[i].selfDestruct();
            }
        } else if (newSegments > oldSegments) {
            this.activateBodySegments();
        }
        if (!this.method_37908().method_8608()) {
            double newSpeed = 0.3 - (double)((float)newSegments * -0.016666668f);
            if (newSpeed < 0.0) {
                newSpeed = 0.0;
            }
            Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(newSpeed);
        }
    }

    public boolean method_21749() {
        return false;
    }

    public boolean method_5771() {
        return false;
    }

    public void method_5773() {
        if (this.field_6213 > 0) {
            for (int k = 0; k < 5; ++k) {
                double d = this.method_6051().method_43059() * 0.02;
                double d1 = this.method_6051().method_43059() * 0.02;
                double d2 = this.method_6051().method_43059() * 0.02;
                this.method_37908().method_8406((class_2394)(this.method_6051().method_43056() ? class_2398.field_11236 : class_2398.field_11203), this.method_23317() + (double)(this.method_6051().method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), this.method_23318() + (double)(this.method_6051().method_43057() * this.method_17682()), this.method_23321() + (double)(this.method_6051().method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), d, d1, d2);
            }
        }
        if (this.isDazed()) {
            for (int i = 0; i < 5; ++i) {
                class_243 pos = new class_243(this.method_23317(), this.method_23318() + 2.15, this.method_23321()).method_1019(new class_243(1.5, 0.0, 0.0).method_1024((float)Math.toRadians(this.method_6051().method_43048(360))));
                this.method_37908().method_8406((class_2394)class_2398.field_11205, pos.method_10216(), pos.method_10214(), pos.method_10215(), 0.0, 0.0, 0.0);
            }
        }
        ++this.ticksSinceDamaged;
        if (!this.method_37908().method_8608() && this.ticksSinceDamaged > 600 && this.ticksSinceDamaged % 20 == 0) {
            this.method_6025(1.0f);
        }
        this.setSegmentsPerHealth();
        super.method_5773();
        this.moveSegments();
    }

    protected void method_5958() {
        class_243 vec3d;
        super.method_5958();
        if (this.method_5968() != null && (this.method_5858((class_1297)this.method_5968()) > 6400.0 || !this.areSelfAndTargetInHome((class_1297)this.method_5968()))) {
            this.method_5980(null);
        }
        double d = this.method_17681() * 4.0f;
        class_243 class_2432 = vec3d = this.method_6150() ? Objects.requireNonNull(this.method_5942().method_6345()).method_49((class_1297)this) : null;
        while (vec3d != null && vec3d.method_1028(this.method_23317(), vec3d.method_10214(), this.method_23321()) < d * d) {
            this.method_5942().method_6345().method_44();
            if (this.method_5942().method_6345().method_46()) {
                vec3d = null;
                continue;
            }
            vec3d = this.method_5942().method_6345().method_49((class_1297)this);
        }
        this.bossInfo.method_5408(this.method_6032() / this.method_6063());
    }

    protected class_3414 method_5994() {
        return (class_3414)TFSounds.NAGA_HISS.get();
    }

    protected class_3414 method_6011(class_1282 source) {
        return (class_3414)TFSounds.NAGA_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)TFSounds.NAGA_HURT.get();
    }

    public void goSlow() {
        Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6202(this.slowSpeed);
        Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6202(this.fastSpeed);
        Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_26835(this.slowSpeed);
    }

    public void goNormal() {
        Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6202(this.slowSpeed);
        Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6202(this.fastSpeed);
    }

    public void goFast() {
        Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6202(this.slowSpeed);
        Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6202(this.fastSpeed);
        Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_26835(this.fastSpeed);
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5679(class_1282 src) {
        return src.method_5529() != null && !this.isEntityWithinHomeArea(src.method_5529()) || src.method_5526() != null && !this.isEntityWithinHomeArea(src.method_5526()) || src.method_5534() || src.method_5535() || super.method_5679(src);
    }

    public boolean method_5747(float dist, float mult, class_1282 source) {
        return false;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source != class_1282.field_5868 && super.method_5643(source, amount)) {
            class_3222 player;
            this.ticksSinceDamaged = 0;
            class_1297 class_12972 = source.method_5529();
            if (class_12972 instanceof class_3222 && !this.hurtBy.contains(player = (class_3222)class_12972)) {
                this.hurtBy.add(player);
            }
            return true;
        }
        return false;
    }

    public boolean method_6121(class_1297 toAttack) {
        class_1309 living;
        if (this.movementAI.getState() == NagaMovementPattern.MovementState.CHARGE && toAttack instanceof class_1309 && (living = (class_1309)toAttack).method_6039()) {
            class_243 motion = this.method_18798();
            toAttack.method_5762(motion.method_10216() * 1.5, 0.5, motion.method_10215() * 1.5);
            this.method_5762(motion.method_10216() * -1.25, 0.5, motion.method_10215() * -1.25);
            if (toAttack instanceof class_3222) {
                class_3222 player = (class_3222)toAttack;
                player.method_6030().method_7956(5, (class_1309)player, user -> user.method_20236(player.method_6058()));
                TFPacketHandler.CHANNEL.sendToClient((S2CPacket)new ThrowPlayerPacket(motion.method_10216() * 3.0, motion.method_10214() + 0.75, motion.method_10215() * 3.0), player);
            }
            this.method_5643(class_1282.field_5869, 4.0f);
            this.method_37908().method_8396(null, toAttack.method_24515(), class_3417.field_15150, class_3419.field_15248, 1.0f, 0.8f + this.method_37908().method_8409().method_43057() * 0.4f);
            this.movementAI.doDaze();
            return false;
        }
        if (!this.isDazed()) {
            boolean result = super.method_6121(toAttack);
            if (result) {
                toAttack.method_5762((double)(-class_3532.method_15374((float)(this.method_36454() * (float)Math.PI / 180.0f)) * 2.0f), (double)0.4f, (double)(class_3532.method_15362((float)(this.method_36454() * (float)Math.PI / 180.0f)) * 2.0f));
            }
            return result;
        }
        return false;
    }

    public float method_6149(class_2338 pos) {
        if (!this.method_18407(pos)) {
            return Float.MIN_VALUE;
        }
        return 0.0f;
    }

    public void method_5982() {
        if (this.method_37908().method_8407() == class_1267.field_5801) {
            if (this.method_18412() != class_2338.field_10980) {
                this.method_37908().method_8501(this.method_18412(), ((class_2248)TFBlocks.NAGA_BOSS_SPAWNER.get()).method_9564());
            }
            this.method_31472();
        } else {
            super.method_5982();
        }
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        if (this.method_37908() instanceof class_3218) {
            for (NagaSegment seg : this.bodySegments) {
                seg.method_5768();
            }
        }
    }

    public boolean method_18407(class_2338 pos) {
        if (this.method_18413() == -1.0f) {
            return true;
        }
        int distX = Math.abs(this.method_18412().method_10263() - pos.method_10263());
        int distY = Math.abs(this.method_18412().method_10264() - pos.method_10264());
        int distZ = Math.abs(this.method_18412().method_10260() - pos.method_10260());
        return distX <= 46 && distY <= 7 && distZ <= 46;
    }

    public boolean isEntityWithinHomeArea(class_1297 entity) {
        return this.method_18407(entity.method_24515());
    }

    public boolean areSelfAndTargetInHome(class_1297 entity) {
        return this.method_18407(this.method_24515()) && this.isEntityWithinHomeArea(entity);
    }

    private void activateBodySegments() {
        for (int i = 0; i < this.currentSegmentCount; ++i) {
            NagaSegment segment = this.bodySegments[i];
            segment.activate();
            segment.method_5808(this.method_23317() + 0.1 * (double)i, this.method_23318() + 0.5, this.method_23321() + 0.1 * (double)i, this.method_6051().method_43057() * 360.0f, 0.0f);
            for (int j = 0; j < 20; ++j) {
                double d0 = this.method_6051().method_43059() * 0.02;
                double d1 = this.method_6051().method_43059() * 0.02;
                double d2 = this.method_6051().method_43059() * 0.02;
                this.method_37908().method_8406((class_2394)class_2398.field_11236, segment.method_23317() + (double)(this.method_6051().method_43057() * segment.method_17681() * 2.0f) - (double)segment.method_17681() - d0 * 10.0, segment.method_23318() + (double)(this.method_6051().method_43057() * segment.method_17682()) - d1 * 10.0, segment.method_23321() + (double)(this.method_6051().method_43057() * segment.method_17681() * 2.0f) - (double)segment.method_17681() - d2 * 10.0, d0, d1, d2);
            }
        }
    }

    private void moveSegments() {
        for (int i = 0; i < this.bodySegments.length; ++i) {
            this.bodySegments[i].method_5773();
            Naga leader = i == 0 ? this : this.bodySegments[i - 1];
            double followX = leader.method_23317();
            double followY = leader.method_23318();
            double followZ = leader.method_23321();
            float angle = (leader.method_36454() + 180.0f) * (float)Math.PI / 180.0f;
            double straightenForce = 0.05 + 1.0 / (double)(i + 1) * 0.5;
            double idealX = (double)(-class_3532.method_15374((float)angle)) * straightenForce;
            double idealZ = (double)class_3532.method_15362((float)angle) * straightenForce;
            double groundY = this.bodySegments[i].method_5757() ? followY + 2.0 : followY;
            double idealY = (groundY - followY) * straightenForce;
            class_243 diff = new class_243(this.bodySegments[i].method_23317() - followX, this.bodySegments[i].method_23318() - followY, this.bodySegments[i].method_23321() - followZ);
            diff = diff.method_1029();
            diff = diff.method_1031(idealX, idealY, idealZ).method_1029();
            double f = 2.0;
            double destX = followX + f * diff.method_10216();
            double destY = followY + f * diff.method_10214();
            double destZ = followZ + f * diff.method_10215();
            this.bodySegments[i].method_5814(destX, destY, destZ);
            double distance = class_3532.method_15355((float)((float)(diff.method_10216() * diff.method_10216() + diff.method_10215() * diff.method_10215())));
            if (i == 0) {
                diff = diff.method_1031(0.0, -0.15, 0.0);
            }
            this.bodySegments[i].method_5710((float)(Math.atan2(diff.method_10215(), diff.method_10216()) * 180.0 / Math.PI) + 90.0f, -((float)(Math.atan2(diff.method_10214(), distance) * 180.0 / Math.PI)));
        }
    }

    public void method_5652(class_2487 compound) {
        this.saveHomePointToNbt(compound);
        super.method_5652(compound);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.loadHomePointFromNbt(compound, 20);
        if (this.method_16914()) {
            this.bossInfo.method_5413(this.method_5476());
        }
    }

    public void method_6078(class_1282 cause) {
        super.method_6078(cause);
        if (!this.method_37908().method_8608()) {
            TFGenerationSettings.markStructureConquered(this.method_37908(), this.method_24515(), TFLandmark.NAGA_COURTYARD);
            for (class_3222 player : this.hurtBy) {
                TFAdvancements.HURT_BOSS.trigger(player, (class_1297)this);
            }
            TFLootTables.entityDropsIntoContainer((class_1309)this, this.method_16079(true, cause).method_309(class_173.field_1173), this.method_6051().method_43056() ? ((TFChestBlock)((Object)TFBlocks.TWILIGHT_OAK_CHEST.get())).method_9564() : ((TFChestBlock)((Object)TFBlocks.CANOPY_CHEST.get())).method_9564(), EntityUtil.bossChestLocation((class_1308)this));
        }
    }

    protected boolean method_27071() {
        return false;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        TFPart.assignPartIDs((class_1297)this);
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.bodySegments;
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossInfo.method_14088(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossInfo.method_14089(player);
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossInfo.method_5413(this.method_5476());
    }

    public float getStepHeight() {
        return 2.0f;
    }

    public boolean method_5974(double distance) {
        return false;
    }

    protected boolean method_5860(class_1297 entity) {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    protected float method_6120() {
        return 1.0f;
    }

    public boolean method_5822() {
        return false;
    }

    @Override
    public class_2338 getRestrictionCenter() {
        return this.method_18412();
    }

    @Override
    public void setRestriction(class_2338 pos, int dist) {
        this.method_18408(pos, dist);
    }
}

