/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import io.github.fabricators_of_create.porting_lib.entity.MultiPartEntity;
import io.github.fabricators_of_create.porting_lib.entity.PartEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1259;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1331;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFChestBlock;
import twilightforest.entity.EnforcedHomePoint;
import twilightforest.entity.IBreathAttacker;
import twilightforest.entity.TFPart;
import twilightforest.entity.ai.goal.HoverBeamGoal;
import twilightforest.entity.ai.goal.HoverSummonGoal;
import twilightforest.entity.ai.goal.HoverThenDropGoal;
import twilightforest.entity.boss.SnowQueenIceShield;
import twilightforest.entity.monster.IceCrystal;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDamageSources;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFSounds;
import twilightforest.loot.TFLootTables;
import twilightforest.util.EntityUtil;
import twilightforest.util.WorldUtil;
import twilightforest.world.registration.TFGenerationSettings;

public class SnowQueen
extends class_1588
implements IBreathAttacker,
EnforcedHomePoint,
MultiPartEntity {
    private static final int MAX_SUMMONS = 6;
    private static final class_2940<Boolean> BEAM_FLAG = class_2945.method_12791(SnowQueen.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Byte> PHASE_FLAG = class_2945.method_12791(SnowQueen.class, (class_2941)class_2943.field_13319);
    private final class_3213 bossInfo = new class_3213(this.method_5476(), class_1259.class_1260.field_5786, class_1259.class_1261.field_5795);
    private static final int MAX_DAMAGE_WHILE_BEAMING = 25;
    private static final float BREATH_DAMAGE = 4.0f;
    public final SnowQueenIceShield[] iceArray = new SnowQueenIceShield[7];
    private int summonsRemaining = 0;
    private int successfulDrops;
    private int maxDrops;
    private int damageWhileBeaming;
    private final List<class_3222> hurtBy = new ArrayList<class_3222>();

    public SnowQueen(class_1299<? extends SnowQueen> type, class_1937 world) {
        super(type, world);
        for (int i = 0; i < this.iceArray.length; ++i) {
            this.iceArray[i] = new SnowQueenIceShield(this);
        }
        this.setCurrentPhase(Phase.SUMMON);
        this.field_6194 = 317;
        this.field_6207 = new class_1331((class_1308)this, 10, true);
        this.method_5875(true);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new HoverSummonGoal(this));
        this.field_6201.method_6277(2, (class_1352)new HoverThenDropGoal(this, 80, 20));
        this.field_6201.method_6277(3, (class_1352)new HoverBeamGoal(this, 80, 100));
        this.addRestrictionGoals((class_1314)this, this.field_6201);
        this.field_6201.method_6277(6, (class_1352)new class_1366((class_1314)this, 1.0, true));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    public boolean method_5810() {
        return false;
    }

    public static class_5132.class_5133 registerAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23719, 0.23).method_26868(class_5134.field_23720, 0.23).method_26868(class_5134.field_23721, 7.0).method_26868(class_5134.field_23717, 40.0).method_26868(class_5134.field_23716, 200.0).method_26868(class_5134.field_23718, 0.75);
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(BEAM_FLAG, (Object)false);
        this.method_5841().method_12784(PHASE_FLAG, (Object)0);
    }

    protected class_3414 method_5994() {
        return (class_3414)TFSounds.SNOW_QUEEN_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 source) {
        return (class_3414)TFSounds.SNOW_QUEEN_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)TFSounds.SNOW_QUEEN_DEATH.get();
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().method_8608()) {
            this.bossInfo.method_5408(this.method_6032() / this.method_6063());
        } else {
            this.spawnParticles();
        }
    }

    private void spawnParticles() {
        for (int i = 0; i < 3; ++i) {
            float px = (this.method_6051().method_43057() - this.method_6051().method_43057()) * 0.3f;
            float py = this.method_5751() + (this.method_6051().method_43057() - this.method_6051().method_43057()) * 0.5f;
            float pz = (this.method_6051().method_43057() - this.method_6051().method_43057()) * 0.3f;
            this.method_37908().method_8406((class_2394)TFParticleType.SNOW_GUARDIAN.get(), this.field_6038 + (double)px, this.field_5971 + (double)py, this.field_5989 + (double)pz, 0.0, 0.0, 0.0);
        }
        if (this.getCurrentPhase() == Phase.DROP) {
            for (SnowQueenIceShield ice : this.iceArray) {
                float px = (this.method_6051().method_43057() - this.method_6051().method_43057()) * 0.5f;
                float py = (this.method_6051().method_43057() - this.method_6051().method_43057()) * 0.5f;
                float pz = (this.method_6051().method_43057() - this.method_6051().method_43057()) * 0.5f;
                this.method_37908().method_8406((class_2394)TFParticleType.SNOW_WARNING.get(), ((class_1297)ice).field_6038 + (double)px, ((class_1297)ice).field_5971 + (double)py, ((class_1297)ice).field_5989 + (double)pz, 0.0, 0.0, 0.0);
            }
        }
        if (this.isBreathing() && this.method_5805()) {
            class_243 look = this.method_5720();
            double dist = 0.5;
            double px = this.method_23317() + look.method_10216() * dist;
            double py = this.method_23318() + (double)1.7f + look.method_10214() * dist;
            double pz = this.method_23321() + look.method_10215() * dist;
            for (int i = 0; i < 10; ++i) {
                double dx = look.method_10216();
                double dy = 0.0;
                double dz = look.method_10215();
                double spread = 2.0 + this.method_6051().method_43058() * 2.5;
                double velocity = 2.0 + this.method_6051().method_43058() * 0.15;
                dx += this.method_6051().method_43059() * 0.0075 * spread;
                dy += this.method_6051().method_43059() * 0.0075 * spread;
                dz += this.method_6051().method_43059() * 0.0075 * spread;
                this.method_37908().method_8406((class_2394)TFParticleType.ICE_BEAM.get(), px, py, pz, dx *= velocity, dy *= velocity, dz *= velocity);
            }
        }
    }

    public void method_5773() {
        this.method_18800(this.method_18798().method_10216(), this.method_18798().method_10214() - 0.05, this.method_18798().method_10215());
        super.method_5773();
        for (int i = 0; i < this.iceArray.length; ++i) {
            this.iceArray[i].method_5773();
            if (i < this.iceArray.length - 1) {
                class_243 blockPos = this.getIceShieldPosition(i);
                this.iceArray[i].method_5814(blockPos.method_10216(), blockPos.method_10214(), blockPos.method_10215());
            } else {
                this.iceArray[i].method_5814(this.method_23317(), this.method_23318() - 1.0, this.method_23321());
            }
            this.iceArray[i].method_36456(this.getIceShieldAngle(i));
            if (this.method_37908().method_8608()) continue;
            this.applyShieldCollisions((class_1297)this.iceArray[i]);
        }
        if (this.field_6213 > 0) {
            for (int k = 0; k < 5; ++k) {
                double d = this.method_6051().method_43059() * 0.02;
                double d1 = this.method_6051().method_43059() * 0.02;
                double d2 = this.method_6051().method_43059() * 0.02;
                this.method_37908().method_8406((class_2394)(this.method_6051().method_43056() ? class_2398.field_11236 : class_2398.field_11203), this.method_23317() + (double)(this.method_6051().method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), this.method_23318() + (double)(this.method_6051().method_43057() * this.method_17682()), this.method_23321() + (double)(this.method_6051().method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), d, d1, d2);
            }
        }
    }

    public boolean method_5974(double distance) {
        return false;
    }

    public void method_5982() {
        if (this.method_37908().method_8407() == class_1267.field_5801) {
            if (this.method_18412() != class_2338.field_10980) {
                this.method_37908().method_8501(this.method_18412(), ((class_2248)TFBlocks.SNOW_QUEEN_BOSS_SPAWNER.get()).method_9564());
            }
            this.method_31472();
        } else {
            super.method_5982();
        }
    }

    public void method_6078(class_1282 cause) {
        super.method_6078(cause);
        if (!this.method_37908().method_8608()) {
            TFGenerationSettings.markStructureConquered(this.method_37908(), this.method_24515(), TFLandmark.ICE_TOWER);
            for (class_3222 player : this.hurtBy) {
                TFAdvancements.HURT_BOSS.trigger(player, (class_1297)this);
            }
            TFLootTables.entityDropsIntoContainer((class_1309)this, this.method_16079(true, cause).method_309(class_173.field_1173), ((TFChestBlock)((Object)TFBlocks.TWILIGHT_OAK_CHEST.get())).method_9564(), EntityUtil.bossChestLocation((class_1308)this));
        }
    }

    protected boolean method_27071() {
        return false;
    }

    private void applyShieldCollisions(class_1297 collider) {
        List list = this.method_37908().method_8335(collider, collider.method_5829().method_1009((double)-0.2f, (double)-0.2f, (double)-0.2f));
        for (class_1297 collided : list) {
            if (!collided.method_5810()) continue;
            this.applyShieldCollision(collider, collided);
        }
    }

    private void applyShieldCollision(class_1297 collider, class_1297 collided) {
        if (collided != this) {
            collided.method_5697(collider);
            if (collided instanceof class_1309 && this.method_6121(collided)) {
                class_243 motion = collided.method_18798();
                collided.method_18800(motion.method_10216(), motion.method_10214() + 0.4, motion.method_10215());
                this.method_5783((class_3414)TFSounds.SNOW_QUEEN_ATTACK.get(), 1.0f, 1.0f);
            }
        }
    }

    public boolean method_6121(class_1297 entity) {
        if (this.getCurrentPhase() == Phase.DROP) {
            return entity.method_5643(TFDamageSources.SQUISH, (float)this.method_26825(class_5134.field_23721));
        }
        return super.method_6121(entity);
    }

    protected void method_5958() {
        super.method_5958();
        if (this.getCurrentPhase() == Phase.SUMMON && this.getSummonsRemaining() == 0 && this.countMyMinions() <= 0) {
            this.setCurrentPhase(Phase.DROP);
        }
        if (this.getCurrentPhase() == Phase.DROP && this.successfulDrops >= this.maxDrops) {
            this.setCurrentPhase(Phase.BEAM);
        }
        if (this.getCurrentPhase() == Phase.BEAM && this.damageWhileBeaming >= 25) {
            this.setCurrentPhase(Phase.SUMMON);
        }
    }

    public boolean method_5643(class_1282 source, float damage) {
        class_3222 player;
        class_1297 class_12972;
        boolean result = super.method_5643(source, damage);
        if (result && this.getCurrentPhase() == Phase.BEAM) {
            this.damageWhileBeaming = (int)((float)this.damageWhileBeaming + damage);
        }
        if ((class_12972 = source.method_5529()) instanceof class_3222 && !this.hurtBy.contains(player = (class_3222)class_12972)) {
            this.hurtBy.add(player);
        }
        return result;
    }

    private class_243 getIceShieldPosition(int idx) {
        return this.getIceShieldPosition(this.getIceShieldAngle(idx), 1.0f);
    }

    private float getIceShieldAngle(int idx) {
        return 60.0f * (float)idx + (float)this.field_6012 * 5.0f;
    }

    private class_243 getIceShieldPosition(float angle, float distance) {
        double dx = Math.cos((double)angle * Math.PI / 180.0) * (double)distance;
        double dz = Math.sin((double)angle * Math.PI / 180.0) * (double)distance;
        return new class_243(this.method_23317() + dx, this.method_23318() + this.getShieldYOffset(), this.method_23321() + dz);
    }

    private double getShieldYOffset() {
        return 0.1f;
    }

    public boolean method_5747(float distance, float damageMultiplier, class_1282 cause) {
        return false;
    }

    public void destroyBlocksInAABB(class_238 box) {
        if (this.method_37908().method_8450().method_8355(class_1928.field_19388)) {
            for (class_2338 pos : WorldUtil.getAllInBB(box)) {
                class_2680 state = this.method_37908().method_8320(pos);
                if (state.method_26204() != class_2246.field_10295 && state.method_26204() != class_2246.field_10225) continue;
                this.method_37908().method_22352(pos, false);
                this.method_32876(class_5712.field_28165);
            }
        }
    }

    @Override
    public boolean isBreathing() {
        return (Boolean)this.field_6011.method_12789(BEAM_FLAG);
    }

    @Override
    public void setBreathing(boolean flag) {
        this.field_6011.method_12778(BEAM_FLAG, (Object)flag);
    }

    public Phase getCurrentPhase() {
        return Phase.values()[(Byte)this.field_6011.method_12789(PHASE_FLAG)];
    }

    public void setCurrentPhase(Phase currentPhase) {
        this.field_6011.method_12778(PHASE_FLAG, (Object)((byte)currentPhase.ordinal()));
        if (currentPhase == Phase.SUMMON) {
            this.setSummonsRemaining(6);
        }
        if (currentPhase == Phase.DROP) {
            this.successfulDrops = 0;
            this.maxDrops = 2 + this.method_6051().method_43048(3);
        }
        if (currentPhase == Phase.BEAM) {
            this.damageWhileBeaming = 0;
        }
    }

    public int getSummonsRemaining() {
        return this.summonsRemaining;
    }

    public void setSummonsRemaining(int summonsRemaining) {
        this.summonsRemaining = summonsRemaining;
    }

    public void summonMinionAt(class_1309 targetedEntity) {
        IceCrystal minion = new IceCrystal(this.method_37908());
        minion.method_5641(this.method_23317(), this.method_23318(), this.method_23321(), 0.0f, 0.0f);
        this.method_37908().method_8649((class_1297)minion);
        for (int i = 0; i < 100; ++i) {
            double attemptZ;
            double attemptY;
            double attemptX;
            if (this.method_18412() != class_2338.field_10980) {
                class_2338 home = this.method_18412();
                attemptX = (double)home.method_10263() + this.method_6051().method_43059() * 3.0;
                attemptY = (double)home.method_10264() + this.method_6051().method_43059() * 2.0;
                attemptZ = (double)home.method_10260() + this.method_6051().method_43059() * 3.0;
            } else {
                attemptX = targetedEntity.method_23317() + this.method_6051().method_43059() * 6.0;
                attemptY = targetedEntity.method_23318() + this.method_6051().method_43059() * 8.0;
                attemptZ = targetedEntity.method_23321() + this.method_6051().method_43059() * 6.0;
            }
            if (!minion.method_6082(attemptX, attemptY, attemptZ, true)) continue;
            this.method_32875(class_5712.field_28738, (class_1297)minion);
            break;
        }
        minion.method_5980(targetedEntity);
        minion.setToDieIn30Seconds();
        --this.summonsRemaining;
    }

    public int countMyMinions() {
        return this.method_37908().method_18467(IceCrystal.class, new class_238(this.method_23317(), this.method_23318(), this.method_23321(), this.method_23317() + 1.0, this.method_23318() + 1.0, this.method_23321() + 1.0).method_1009(32.0, 16.0, 32.0)).size();
    }

    public void incrementSuccessfulDrops() {
        ++this.successfulDrops;
    }

    @Override
    public void doBreathAttack(class_1297 target) {
        target.method_5643(TFDamageSources.CHILLING_BREATH, 4.0f);
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossInfo.method_5413(this.method_5476());
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossInfo.method_14088(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossInfo.method_14089(player);
    }

    public void method_5652(class_2487 compound) {
        this.saveHomePointToNbt(compound);
        super.method_5652(compound);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.loadHomePointFromNbt(compound, 20);
        if (this.method_16914()) {
            this.bossInfo.method_5413(this.method_5476());
        }
    }

    protected boolean method_5860(class_1297 entity) {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    protected float method_6120() {
        return 1.0f;
    }

    public boolean method_5822() {
        return false;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        TFPart.assignPartIDs((class_1297)this);
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.iceArray;
    }

    @Override
    public class_2338 getRestrictionCenter() {
        return this.method_18412();
    }

    @Override
    public void setRestriction(class_2338 pos, int dist) {
        this.method_18408(pos, dist);
    }

    public static enum Phase {
        SUMMON,
        DROP,
        BEAM;

    }
}

